/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A cursor that reads progressively rows from the database, it is useful for reading very large result sets.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Cursor original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.Cursor.class)
public class Cursor {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Cursor that = (Cursor) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Cursor> __TYPE_ARG = new TypeArg<>(    obj -> new Cursor((io.vertx.sqlclient.Cursor) obj),
    Cursor::getDelegate
  );

  private final io.vertx.sqlclient.Cursor delegate;
  
  public Cursor(io.vertx.sqlclient.Cursor delegate) {
    this.delegate = delegate;
  }

  public Cursor(Object delegate) {
    this.delegate = (io.vertx.sqlclient.Cursor)delegate;
  }

  public io.vertx.sqlclient.Cursor getDelegate() {
    return delegate;
  }

  /**
   * Read rows from the cursor, the result is provided asynchronously to the <code>handler</code>.
   * @param count the amount of rows to read
   * @param handler the handler for the result
   */
  public void read(int count, Handler<AsyncResult<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>> handler) { 
    delegate.read(count, new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), new TypeArg<io.vertx.reactivex.sqlclient.Row>(o0 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o0), o0 -> o0.getDelegate()))));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Read rows from the cursor, the result is provided asynchronously to the <code>handler</code>.
   * @param count the amount of rows to read
   * @return 
   */
  public Single<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> rxRead(int count) { 
    return AsyncResultSingle.toSingle(handler -> {
      read(count, handler);
    });
  }

  /**
   * Returns <code>true</code> when the cursor has results in progress and the {@link io.vertx.reactivex.sqlclient.Cursor#read} should be called to retrieve
   * them.
   * @return whether the cursor has more results,
   */
  public boolean hasMore() { 
    boolean ret = delegate.hasMore();
    return ret;
  }

  /**
   * Release the cursor.
   * <p/>
   * It should be called for prepared queries executed with a fetch size.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Cursor#close} but with a <code>completionHandler</code> called when the cursor has been released.
   * @param completionHandler 
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Cursor#close} but with a <code>completionHandler</code> called when the cursor has been released.
   * @return 
   */
  public Completable rxClose() { 
    return AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  /**
   * @return whether the cursor is closed
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  public static Cursor newInstance(io.vertx.sqlclient.Cursor arg) {
    return arg != null ? new Cursor(arg) : null;
  }

}
