/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A pool of SQL connections.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Pool original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.Pool.class)
public class Pool extends io.vertx.reactivex.sqlclient.SqlClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Pool that = (Pool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Pool> __TYPE_ARG = new TypeArg<>(    obj -> new Pool((io.vertx.sqlclient.Pool) obj),
    Pool::getDelegate
  );

  private final io.vertx.sqlclient.Pool delegate;
  
  public Pool(io.vertx.sqlclient.Pool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Pool(Object delegate) {
    super((io.vertx.sqlclient.Pool)delegate);
    this.delegate = (io.vertx.sqlclient.Pool)delegate;
  }

  public io.vertx.sqlclient.Pool getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>(o1 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.reactivex.sqlclient.Row>(o2 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>(o1 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.reactivex.sqlclient.Row>(o2 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

  /**
   * Create a connection pool to the database configured with the given <code>connectOptions</code> and default {@link io.vertx.sqlclient.PoolOptions}
   * @param connectOptions the options used to create the connection pool, such as database hostname
   * @return the connection pool
   */
  public static io.vertx.reactivex.sqlclient.Pool pool(io.vertx.sqlclient.SqlConnectOptions connectOptions) { 
    io.vertx.reactivex.sqlclient.Pool ret = io.vertx.reactivex.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.sqlclient.Pool.pool(connectOptions));
    return ret;
  }

  /**
   * Create a connection pool to the database configured with the given <code>connectOptions</code> and <code>poolOptions</code>.
   * @param connectOptions the options used to create the connection pool, such as database hostname
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.reactivex.sqlclient.Pool pool(io.vertx.sqlclient.SqlConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.sqlclient.Pool ret = io.vertx.reactivex.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.sqlclient.Pool.pool(connectOptions, poolOptions));
    return ret;
  }

  /**
   * Create a connection pool to the database configured with the given <code>connectOptions</code> and <code>poolOptions</code>.
   * @param vertx the Vertx instance to be used with the connection pool
   * @param connectOptions the options used to create the connection pool, such as database hostname
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.reactivex.sqlclient.Pool pool(io.vertx.reactivex.core.Vertx vertx, io.vertx.sqlclient.SqlConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.reactivex.sqlclient.Pool ret = io.vertx.reactivex.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.sqlclient.Pool.pool(vertx.getDelegate(), connectOptions, poolOptions));
    return ret;
  }

  /**
   * Get a connection from the pool.
   * @param handler the handler that will get the connection result
   */
  public void getConnection(Handler<AsyncResult<io.vertx.reactivex.sqlclient.SqlConnection>> handler) { 
    delegate.getConnection(new Handler<AsyncResult<io.vertx.sqlclient.SqlConnection>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.SqlConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get a connection from the pool.
   * @return 
   */
  public Single<io.vertx.reactivex.sqlclient.SqlConnection> rxGetConnection() { 
    return AsyncResultSingle.toSingle(handler -> {
      getConnection(handler);
    });
  }

  /**
   * 
   *
   * A connection is borrowed from the connection pool when the query is executed and then immediately returned
   * to the pool after it completes.
   * @param sql 
   * @return 
   */
  public io.vertx.reactivex.sqlclient.Query<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> query(String sql) { 
    io.vertx.reactivex.sqlclient.Query<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> ret = io.vertx.reactivex.sqlclient.Query.newInstance((io.vertx.sqlclient.Query)delegate.query(sql), TYPE_ARG_0);
    return ret;
  }

  /**
   * 
   *
   * A connection is borrowed from the connection pool when the query is executed and then immediately returned
   * to the pool after it completes.
   * @param sql 
   * @return 
   */
  public io.vertx.reactivex.sqlclient.PreparedQuery<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> preparedQuery(String sql) { 
    io.vertx.reactivex.sqlclient.PreparedQuery<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> ret = io.vertx.reactivex.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.preparedQuery(sql), TYPE_ARG_1);
    return ret;
  }

  /**
   * Borrow a connection from the pool and begin a transaction, the underlying connection will be returned
   * to the pool when the transaction ends.
   * @param handler 
   */
  public void begin(Handler<AsyncResult<io.vertx.reactivex.sqlclient.Transaction>> handler) { 
    delegate.begin(new Handler<AsyncResult<io.vertx.sqlclient.Transaction>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.Transaction> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.Transaction.newInstance((io.vertx.sqlclient.Transaction)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Borrow a connection from the pool and begin a transaction, the underlying connection will be returned
   * to the pool when the transaction ends.
   * @return 
   */
  public Single<io.vertx.reactivex.sqlclient.Transaction> rxBegin() { 
    return AsyncResultSingle.toSingle(handler -> {
      begin(handler);
    });
  }

  /**
   * Close the pool and release the associated resources.
   */
  public void close() { 
    delegate.close();
  }

  public static Pool newInstance(io.vertx.sqlclient.Pool arg) {
    return arg != null ? new Pool(arg) : null;
  }

}
