/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents single row of the result set.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Row original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.Row.class)
public class Row extends io.vertx.reactivex.sqlclient.Tuple {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Row that = (Row) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Row> __TYPE_ARG = new TypeArg<>(    obj -> new Row((io.vertx.sqlclient.Row) obj),
    Row::getDelegate
  );

  private final io.vertx.sqlclient.Row delegate;
  
  public Row(io.vertx.sqlclient.Row delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Row(Object delegate) {
    super((io.vertx.sqlclient.Row)delegate);
    this.delegate = (io.vertx.sqlclient.Row)delegate;
  }

  public io.vertx.sqlclient.Row getDelegate() {
    return delegate;
  }

  /**
   * Get a column name for the given <code>column</code>.
   * @param pos the column position
   * @return the column name or <code>null</code>
   */
  public String getColumnName(int pos) { 
    String ret = delegate.getColumnName(pos);
    return ret;
  }

  /**
   * Get a column position for the given column <code>name</code>.
   * @param name the column name
   * @return the column name or <code>-1</code> if not found
   */
  public int getColumnIndex(String name) { 
    int ret = delegate.getColumnIndex(name);
    return ret;
  }

  /**
   * Get an object value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Object getValue(String column) { 
    java.lang.Object ret = (Object) delegate.getValue(column);
    return ret;
  }

  /**
   * Get a boolean value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public Boolean getBoolean(String column) { 
    Boolean ret = delegate.getBoolean(column);
    return ret;
  }

  /**
   * Get a short value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public Short getShort(String column) { 
    Short ret = delegate.getShort(column);
    return ret;
  }

  /**
   * Get an integer value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public Integer getInteger(String column) { 
    Integer ret = delegate.getInteger(column);
    return ret;
  }

  /**
   * Get a long value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public Long getLong(String column) { 
    Long ret = delegate.getLong(column);
    return ret;
  }

  /**
   * Get a float value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public Float getFloat(String column) { 
    Float ret = delegate.getFloat(column);
    return ret;
  }

  /**
   * Get a double value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public Double getDouble(String column) { 
    Double ret = delegate.getDouble(column);
    return ret;
  }

  /**
   * Get a string value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public String getString(String column) { 
    String ret = delegate.getString(column);
    return ret;
  }

  /**
   * Get a JSON element for the given <code>column</code>, the element might be {@link io.vertx.reactivex.sqlclient.Tuple #JSON_NULL null} or one of the following types:
   * <ul>
   *   <li>String</li>
   *   <li>Number</li>
   *   <li>JsonObject</li>
   *   <li>JsonArray</li>
   *   <li>Boolean</li>
   * </ul>
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Object getJson(String column) { 
    java.lang.Object ret = (Object) delegate.getJson(column);
    return ret;
  }

  /**
   * Get a buffer value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public io.vertx.reactivex.core.buffer.Buffer getBuffer(String column) { 
    io.vertx.reactivex.core.buffer.Buffer ret = io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.getBuffer(column));
    return ret;
  }

  /**
   * Get a numeric value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public io.vertx.sqlclient.data.Numeric getNumeric(String column) { 
    io.vertx.sqlclient.data.Numeric ret = delegate.getNumeric(column);
    return ret;
  }

  /**
   * Get a temporal value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.temporal.Temporal getTemporal(String column) { 
    java.time.temporal.Temporal ret = delegate.getTemporal(column);
    return ret;
  }

  /**
   * Get {@link java.time.LocalDate} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalDate getLocalDate(String column) { 
    java.time.LocalDate ret = delegate.getLocalDate(column);
    return ret;
  }

  /**
   * Get {@link java.time.LocalTime} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalTime getLocalTime(String column) { 
    java.time.LocalTime ret = delegate.getLocalTime(column);
    return ret;
  }

  /**
   * Get {@link java.time.LocalDateTime} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalDateTime getLocalDateTime(String column) { 
    java.time.LocalDateTime ret = delegate.getLocalDateTime(column);
    return ret;
  }

  /**
   * Get {@link java.time.OffsetTime} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.OffsetTime getOffsetTime(String column) { 
    java.time.OffsetTime ret = delegate.getOffsetTime(column);
    return ret;
  }

  /**
   * Get {@link java.time.OffsetDateTime} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.OffsetDateTime getOffsetDateTime(String column) { 
    java.time.OffsetDateTime ret = delegate.getOffsetDateTime(column);
    return ret;
  }

  /**
   * Get {@link java.util.UUID} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.util.UUID getUUID(String column) { 
    java.util.UUID ret = delegate.getUUID(column);
    return ret;
  }

  /**
   * Get  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.math.BigDecimal getBigDecimal(String column) { 
    java.math.BigDecimal ret = delegate.getBigDecimal(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Boolean} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Boolean[] getArrayOfBooleans(String column) { 
    java.lang.Boolean[] ret = delegate.getArrayOfBooleans(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Boolean} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.lang.Boolean[] getBooleanArray(String column) { 
    java.lang.Boolean[] ret = delegate.getBooleanArray(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Short} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Short[] getArrayOfShorts(String column) { 
    java.lang.Short[] ret = delegate.getArrayOfShorts(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Short} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.lang.Short[] getShortArray(String column) { 
    java.lang.Short[] ret = delegate.getShortArray(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Integer} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Integer[] getArrayOfIntegers(String column) { 
    java.lang.Integer[] ret = delegate.getArrayOfIntegers(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Integer} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.lang.Integer[] getIntegerArray(String column) { 
    java.lang.Integer[] ret = delegate.getIntegerArray(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Long} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Long[] getArrayOfLongs(String column) { 
    java.lang.Long[] ret = delegate.getArrayOfLongs(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Long} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.lang.Long[] getLongArray(String column) { 
    java.lang.Long[] ret = delegate.getLongArray(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Float} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Float[] getArrayOfFloats(String column) { 
    java.lang.Float[] ret = delegate.getArrayOfFloats(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Float} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.lang.Float[] getFloatArray(String column) { 
    java.lang.Float[] ret = delegate.getFloatArray(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Double} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Double[] getArrayOfDoubles(String column) { 
    java.lang.Double[] ret = delegate.getArrayOfDoubles(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.Double} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.lang.Double[] getDoubleArray(String column) { 
    java.lang.Double[] ret = delegate.getDoubleArray(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public io.vertx.sqlclient.data.Numeric[] getArrayOfNumerics(String column) { 
    io.vertx.sqlclient.data.Numeric[] ret = delegate.getArrayOfNumerics(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column
   * @return the <code>column</code> value
   */
  @Deprecated()
  public io.vertx.sqlclient.data.Numeric[] getNumericArray(String column) { 
    io.vertx.sqlclient.data.Numeric[] ret = delegate.getNumericArray(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.String} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.String[] getArrayOfStrings(String column) { 
    java.lang.String[] ret = delegate.getArrayOfStrings(column);
    return ret;
  }

  /**
   * Get an array of {@link java.lang.String} value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.lang.String[] getStringArray(String column) { 
    java.lang.String[] ret = delegate.getStringArray(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.temporal.Temporal[] getArrayOfTemporals(String column) { 
    java.time.temporal.Temporal[] ret = delegate.getArrayOfTemporals(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.time.temporal.Temporal[] getTemporalArray(String column) { 
    java.time.temporal.Temporal[] ret = delegate.getTemporalArray(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalDate[] getArrayOfLocalDates(String column) { 
    java.time.LocalDate[] ret = delegate.getArrayOfLocalDates(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.time.LocalDate[] getLocalDateArray(String column) { 
    java.time.LocalDate[] ret = delegate.getLocalDateArray(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalTime[] getArrayOfLocalTimes(String column) { 
    java.time.LocalTime[] ret = delegate.getArrayOfLocalTimes(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.time.LocalTime[] getLocalTimeArray(String column) { 
    java.time.LocalTime[] ret = delegate.getLocalTimeArray(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.LocalDateTime[] getArrayOfLocalDateTimes(String column) { 
    java.time.LocalDateTime[] ret = delegate.getArrayOfLocalDateTimes(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.time.LocalDateTime[] getLocalDateTimeArray(String column) { 
    java.time.LocalDateTime[] ret = delegate.getLocalDateTimeArray(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.OffsetTime[] getArrayOfOffsetTimes(String column) { 
    java.time.OffsetTime[] ret = delegate.getArrayOfOffsetTimes(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.time.OffsetTime[] getOffsetTimeArray(String column) { 
    java.time.OffsetTime[] ret = delegate.getOffsetTimeArray(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.time.OffsetDateTime[] getArrayOfOffsetDateTimes(String column) { 
    java.time.OffsetDateTime[] ret = delegate.getArrayOfOffsetDateTimes(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.time.OffsetDateTime[] getOffsetDateTimeArray(String column) { 
    java.time.OffsetDateTime[] ret = delegate.getOffsetDateTimeArray(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.util.UUID[] getArrayOfUUIDs(String column) { 
    java.util.UUID[] ret = delegate.getArrayOfUUIDs(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.util.UUID[] getUUIDArray(String column) { 
    java.util.UUID[] ret = delegate.getUUIDArray(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.math.BigDecimal[] getArrayOfBigDecimals(String column) { 
    java.math.BigDecimal[] ret = delegate.getArrayOfBigDecimals(column);
    return ret;
  }

  /**
   * Get an array of  value for the given <code>column</code>.
   * @param column the column name
   * @return the <code>column</code> value
   */
  @Deprecated()
  public java.math.BigDecimal[] getBigDecimalArray(String column) { 
    java.math.BigDecimal[] ret = delegate.getBigDecimalArray(column);
    return ret;
  }

  /**
   * Get an array of JSON elements for the given <code>column</code>, the element might be {@link io.vertx.reactivex.sqlclient.Tuple #JSON_NULL null} or one of the following types:
   * <ul>
   *   <li>String</li>
   *   <li>Number</li>
   *   <li>JsonObject</li>
   *   <li>JsonArray</li>
   *   <li>Boolean</li>
   * </ul>
   * @param column the column name
   * @return the <code>column</code> value
   */
  public java.lang.Object[] getArrayOfJsons(String column) { 
    java.lang.Object[] ret = delegate.getArrayOfJsons(column);
    return ret;
  }

  /**
   * The JSON null literal value.
   * <br/>
   * It is used to distinguish a JSON null literal value from the Java <code>null</code> value. This is only
   * used when the database supports JSON types.
   */
  public static final java.lang.Object JSON_NULL = (Object) io.vertx.sqlclient.Row.JSON_NULL;
  public static Row newInstance(io.vertx.sqlclient.Row arg) {
    return arg != null ? new Row(arg) : null;
  }

}
