/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.amqp;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Builder to create a new {@link io.vertx.reactivex.amqp.AmqpMessage}.
 * <p>
 * Reference about the different metadata can be found on
 * <a href="http://docs.oasis-open.org/amqp/core/v1.0/amqp-core-messaging-v1.0.html#type-properties">AMQP message properties</a>.
 * <p>
 * Note that the body is set using <code>withBodyAs*</code> method depending on the passed type.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpMessageBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.amqp.AmqpMessageBuilder.class)
public class AmqpMessageBuilder {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpMessageBuilder that = (AmqpMessageBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AmqpMessageBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new AmqpMessageBuilder((io.vertx.amqp.AmqpMessageBuilder) obj),
    AmqpMessageBuilder::getDelegate
  );

  private final io.vertx.amqp.AmqpMessageBuilder delegate;
  
  public AmqpMessageBuilder(io.vertx.amqp.AmqpMessageBuilder delegate) {
    this.delegate = delegate;
  }

  public AmqpMessageBuilder(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpMessageBuilder)delegate;
  }

  public io.vertx.amqp.AmqpMessageBuilder getDelegate() {
    return delegate;
  }

  /**
   * @return a new instance of {@link io.vertx.reactivex.amqp.AmqpMessageBuilder}
   */
  public static io.vertx.reactivex.amqp.AmqpMessageBuilder create() { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)io.vertx.amqp.AmqpMessageBuilder.create());
    return ret;
  }

  /**
   * @return the message.
   */
  public io.vertx.reactivex.amqp.AmqpMessage build() { 
    io.vertx.reactivex.amqp.AmqpMessage ret = io.vertx.reactivex.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)delegate.build());
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder priority(short priority) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.priority(priority));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder durable(boolean durable) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.durable(durable));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder ttl(long ttl) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.ttl(ttl));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder firstAcquirer(boolean first) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.firstAcquirer(first));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder deliveryCount(int count) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.deliveryCount(count));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder id(String id) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.id(id));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder address(String address) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.address(address));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder replyTo(String replyTo) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.replyTo(replyTo));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder correlationId(String correlationId) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.correlationId(correlationId));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withBody(String value) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withBody(value));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withSymbolAsBody(String value) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withSymbolAsBody(value));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder subject(String subject) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.subject(subject));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder contentType(String ct) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.contentType(ct));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder contentEncoding(String ct) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.contentEncoding(ct));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder expiryTime(long expiry) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.expiryTime(expiry));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder creationTime(long ct) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.creationTime(ct));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder groupId(String gi) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.groupId(gi));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder replyToGroupId(String rt) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.replyToGroupId(rt));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder applicationProperties(JsonObject props) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.applicationProperties(props));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withBooleanAsBody(boolean v) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withBooleanAsBody(v));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withByteAsBody(byte v) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withByteAsBody(v));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withShortAsBody(short v) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withShortAsBody(v));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withIntegerAsBody(int v) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withIntegerAsBody(v));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withLongAsBody(long v) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withLongAsBody(v));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withFloatAsBody(float v) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withFloatAsBody(v));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withDoubleAsBody(double v) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withDoubleAsBody(v));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withCharAsBody(char c) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withCharAsBody(c));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withBufferAsBody(io.vertx.reactivex.core.buffer.Buffer buffer) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withBufferAsBody(buffer.getDelegate()));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withJsonObjectAsBody(JsonObject json) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withJsonObjectAsBody(json));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withJsonArrayAsBody(JsonArray json) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withJsonArrayAsBody(json));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withInstantAsBody(java.time.Instant v) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withInstantAsBody(v));
    return ret;
  }

  public io.vertx.reactivex.amqp.AmqpMessageBuilder withUuidAsBody(java.util.UUID v) { 
    io.vertx.reactivex.amqp.AmqpMessageBuilder ret = io.vertx.reactivex.amqp.AmqpMessageBuilder.newInstance((io.vertx.amqp.AmqpMessageBuilder)delegate.withUuidAsBody(v));
    return ret;
  }

  public static AmqpMessageBuilder newInstance(io.vertx.amqp.AmqpMessageBuilder arg) {
    return arg != null ? new AmqpMessageBuilder(arg) : null;
  }

}
