/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.amqp;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * AMQP Sender interface used to send messages.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpSender original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.amqp.AmqpSender.class)
public class AmqpSender implements io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.amqp.AmqpMessage> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpSender that = (AmqpSender) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AmqpSender> __TYPE_ARG = new TypeArg<>(    obj -> new AmqpSender((io.vertx.amqp.AmqpSender) obj),
    AmqpSender::getDelegate
  );

  private final io.vertx.amqp.AmqpSender delegate;
  
  public AmqpSender(io.vertx.amqp.AmqpSender delegate) {
    this.delegate = delegate;
  }

  public AmqpSender(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpSender)delegate;
  }

  public io.vertx.amqp.AmqpSender getDelegate() {
    return delegate;
  }

  private WriteStreamObserver<io.vertx.reactivex.amqp.AmqpMessage> observer;
  private WriteStreamSubscriber<io.vertx.reactivex.amqp.AmqpMessage> subscriber;

  public synchronized WriteStreamObserver<io.vertx.reactivex.amqp.AmqpMessage> toObserver() {
    if (observer == null) {
      Function<io.vertx.reactivex.amqp.AmqpMessage, io.vertx.amqp.AmqpMessage> conv = io.vertx.reactivex.amqp.AmqpMessage::getDelegate;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.reactivex.amqp.AmqpMessage> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.reactivex.amqp.AmqpMessage, io.vertx.amqp.AmqpMessage> conv = io.vertx.reactivex.amqp.AmqpMessage::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.reactivex.amqp.AmqpMessage> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.amqp.AmqpMessage>(o1 -> io.vertx.reactivex.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)o1), o1 -> o1.getDelegate());

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void write(io.vertx.reactivex.amqp.AmqpMessage data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void write(io.vertx.reactivex.amqp.AmqpMessage data) {
    write(data, ar -> { });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.Completable rxWrite(io.vertx.reactivex.amqp.AmqpMessage data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      write(data, $handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   */
  public void end() {
    end(ar -> { });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      end($handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.reactivex.amqp.AmqpMessage data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void end(io.vertx.reactivex.amqp.AmqpMessage data) {
    end(data, ar -> { });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.Completable rxEnd(io.vertx.reactivex.amqp.AmqpMessage data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      end(data, $handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.amqp.AmqpSender#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See  for an example of this being used.
   *
   * <p> The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.amqp.AmqpMessage> drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.reactivex.amqp.AmqpSender exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.amqp.AmqpSender setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  /**
   * Sends an AMQP message. The destination the configured sender address or the address configured in the message.
   * @param message the message, must not be <code>null</code>
   * @return the current sender
   */
  public io.vertx.reactivex.amqp.AmqpSender send(io.vertx.reactivex.amqp.AmqpMessage message) { 
    delegate.send(message.getDelegate());
    return this;
  }

  /**
   * Sends an AMQP message and waits for an acknowledgement. The acknowledgement handler is called with an
   *  marked as failed if the message has been rejected or re-routed. If the message has been accepted,
   * the handler is called with a success.
   * @param message the message, must not be <code>null</code>
   * @param acknowledgementHandler the acknowledgement handler, must not be <code>null</code>
   * @return the current sender
   */
  public io.vertx.reactivex.amqp.AmqpSender sendWithAck(io.vertx.reactivex.amqp.AmqpMessage message, Handler<AsyncResult<Void>> acknowledgementHandler) { 
    delegate.sendWithAck(message.getDelegate(), acknowledgementHandler);
    return this;
  }

  /**
   * Sends an AMQP message and waits for an acknowledgement. The acknowledgement handler is called with an
   *  marked as failed if the message has been rejected or re-routed. If the message has been accepted,
   * the handler is called with a success.
   * @param message the message, must not be <code>null</code>
   * @return the current sender
   */
  public io.vertx.reactivex.amqp.AmqpSender sendWithAck(io.vertx.reactivex.amqp.AmqpMessage message) {
    return 
sendWithAck(message, ar -> { });
  }

  /**
   * Sends an AMQP message and waits for an acknowledgement. The acknowledgement handler is called with an
   *  marked as failed if the message has been rejected or re-routed. If the message has been accepted,
   * the handler is called with a success.
   * @param message the message, must not be <code>null</code>
   * @return the current sender
   */
  public io.reactivex.Completable rxSendWithAck(io.vertx.reactivex.amqp.AmqpMessage message) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      sendWithAck(message, $handler);
    });
  }

  /**
   * Closes the sender.
   * @param handler called when the sender has been closed, must not be <code>null</code>
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Closes the sender.
   */
  public void close() {
    close(ar -> { });
  }

  /**
   * Closes the sender.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close($handler);
    });
  }

  /**
   * @return the configured address.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * Gets the connection having created the sender. Cannot be <code>null</code>
   * @return the connection having created the sender.
   */
  public io.vertx.reactivex.amqp.AmqpConnection connection() { 
    io.vertx.reactivex.amqp.AmqpConnection ret = io.vertx.reactivex.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)delegate.connection());
    return ret;
  }

  /**
   * @return the remaining credit, 0 is none.
   */
  public long remainingCredits() { 
    long ret = delegate.remainingCredits();
    return ret;
  }

  public static AmqpSender newInstance(io.vertx.amqp.AmqpSender arg) {
    return arg != null ? new AmqpSender(arg) : null;
  }

}
