/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.cassandra;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A  for  consumption.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.CassandraRowStream original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.cassandra.CassandraRowStream.class)
public class CassandraRowStream implements io.vertx.reactivex.core.streams.ReadStream<com.datastax.oss.driver.api.core.cql.Row> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CassandraRowStream that = (CassandraRowStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CassandraRowStream> __TYPE_ARG = new TypeArg<>(    obj -> new CassandraRowStream((io.vertx.cassandra.CassandraRowStream) obj),
    CassandraRowStream::getDelegate
  );

  private final io.vertx.cassandra.CassandraRowStream delegate;
  
  public CassandraRowStream(io.vertx.cassandra.CassandraRowStream delegate) {
    this.delegate = delegate;
  }

  public CassandraRowStream(Object delegate) {
    this.delegate = (io.vertx.cassandra.CassandraRowStream)delegate;
  }

  public io.vertx.cassandra.CassandraRowStream getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<com.datastax.oss.driver.api.core.cql.Row> observable;
  private io.reactivex.Flowable<com.datastax.oss.driver.api.core.cql.Row> flowable;

  public synchronized io.reactivex.Observable<com.datastax.oss.driver.api.core.cql.Row> toObservable() {
    if (observable == null) {
      observable = ObservableHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<com.datastax.oss.driver.api.core.cql.Row> toFlowable() {
    if (flowable == null) {
      flowable = FlowableHelper.toFlowable(this.getDelegate());
    }
    return flowable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<com.datastax.oss.driver.api.core.cql.Row> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<com.datastax.oss.driver.api.core.cql.Row> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream endHandler(Handler<Void> handler) { 
    delegate.endHandler(handler);
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream fetch(long l) { 
    delegate.fetch(l);
    return this;
  }

  public io.vertx.reactivex.cassandra.CassandraRowStream handler(Handler<com.datastax.oss.driver.api.core.cql.Row> handler) { 
    delegate.handler(handler);
    return this;
  }

  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<com.datastax.oss.driver.api.core.cql.Row> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<com.datastax.oss.driver.api.core.cql.Row> dst) {
    pipeTo(dst, ar -> { });
  }

  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<com.datastax.oss.driver.api.core.cql.Row> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      pipeTo(dst, $handler);
    });
  }

  /**
   * Get the  provided by the backing {@link io.vertx.reactivex.cassandra.ResultSet} for this stream.
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ExecutionInfo executionInfo() { 
    com.datastax.oss.driver.api.core.cql.ExecutionInfo ret = delegate.executionInfo();
    return ret;
  }

  /**
   * Get the  provided by the backing {@link io.vertx.reactivex.cassandra.ResultSet} for this stream.
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ColumnDefinitions columnDefinitions() { 
    com.datastax.oss.driver.api.core.cql.ColumnDefinitions ret = delegate.columnDefinitions();
    return ret;
  }

  public static CassandraRowStream newInstance(io.vertx.cassandra.CassandraRowStream arg) {
    return arg != null ? new CassandraRowStream(arg) : null;
  }

}
