/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents the writable side of an action that may, or may not, have occurred yet.
 * <p>
 * The {@link io.vertx.reactivex.core.Promise#future} method returns the {@link io.vertx.core.Future} associated with a promise, the future
 * can be used for getting notified of the promise completion and retrieve its value.
 * <p>
 * A promise extends <code>Handler<AsyncResult<T>></code> so it can be used as a callback.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Promise original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.Promise.class)
public class Promise<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Promise that = (Promise) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Promise> __TYPE_ARG = new TypeArg<>(    obj -> new Promise((io.vertx.core.Promise) obj),
    Promise::getDelegate
  );

  private final io.vertx.core.Promise<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public Promise(io.vertx.core.Promise delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public Promise(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.Promise)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.Promise getDelegate() {
    return delegate;
  }


  /**
   * Create a promise that hasn't completed yet
   * @return the promise
   */
  public static <T> io.vertx.reactivex.core.Promise<T> promise() { 
    io.vertx.reactivex.core.Promise<T> ret = io.vertx.reactivex.core.Promise.newInstance((io.vertx.core.Promise)io.vertx.core.Promise.promise(), TypeArg.unknown());
    return ret;
  }

  /**
   * Set the result. Any handler will be called, if there is one, and the promise will be marked as completed.
   * <p/>
   * Any handler set on the associated promise will be called.
   * @param result the result
   */
  public void complete(T result) { 
    delegate.complete(__typeArg_0.<T>unwrap(result));
  }

  /**
   * Calls <code>complete(null)</code>
   */
  public void complete() { 
    delegate.complete();
  }

  /**
   * Set the failure. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param cause the failure cause
   */
  public void fail(java.lang.Throwable cause) { 
    delegate.fail(cause);
  }

  /**
   * Calls {@link io.vertx.reactivex.core.Promise#fail} with the <code>message</code>.
   * @param message the failure message
   */
  public void fail(String message) { 
    delegate.fail(message);
  }

  /**
   * Like {@link io.vertx.reactivex.core.Promise#complete} but returns <code>false</code> when the promise is already completed instead of throwing
   * an {@link java.lang.IllegalStateException}, it returns <code>true</code> otherwise.
   * @param result the result
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryComplete(T result) { 
    boolean ret = delegate.tryComplete(__typeArg_0.<T>unwrap(result));
    return ret;
  }

  /**
   * Calls <code>tryComplete(null)</code>.
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryComplete() { 
    boolean ret = delegate.tryComplete();
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.Promise#fail} but returns <code>false</code> when the promise is already completed instead of throwing
   * an {@link java.lang.IllegalStateException}, it returns <code>true</code> otherwise.
   * @param cause the failure cause
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryFail(java.lang.Throwable cause) { 
    boolean ret = delegate.tryFail(cause);
    return ret;
  }

  /**
   * Calls {@link io.vertx.reactivex.core.Promise#fail} with the <code>message</code>.
   * @param message the failure message
   * @return false when the future is already completed
   */
  public boolean tryFail(String message) { 
    boolean ret = delegate.tryFail(message);
    return ret;
  }

  /**
   * @return the {@link io.vertx.core.Future} associated with this promise, it can be used to be aware of the promise completion
   */
  public io.vertx.core.Future<T> future() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.core.Future<T> ret = delegate.future();
    cached_0 = ret;
    return ret;
  }

  private io.vertx.core.Future<T> cached_0;
  public static <T> Promise<T> newInstance(io.vertx.core.Promise arg) {
    return arg != null ? new Promise<T>(arg) : null;
  }

  public static <T> Promise<T> newInstance(io.vertx.core.Promise arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new Promise<T>(arg, __typeArg_T) : null;
  }

}
