/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.eventbus;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Vert.x event-bus is a light-weight distributed messaging system which allows different parts of your application,
 * or different applications and services to communicate with each in a loosely coupled way.
 * <p>
 * An event-bus supports publish-subscribe messaging, point-to-point messaging and request-response messaging.
 * <p>
 * Message delivery is best-effort and messages can be lost if failure of all or part of the event bus occurs.
 * <p>
 * Please refer to the documentation for more information on the event bus.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.EventBus original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.eventbus.EventBus.class)
public class EventBus implements io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventBus that = (EventBus) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<EventBus> __TYPE_ARG = new TypeArg<>(    obj -> new EventBus((io.vertx.core.eventbus.EventBus) obj),
    EventBus::getDelegate
  );

  private final io.vertx.core.eventbus.EventBus delegate;
  
  public EventBus(io.vertx.core.eventbus.EventBus delegate) {
    this.delegate = delegate;
  }

  public EventBus(Object delegate) {
    this.delegate = (io.vertx.core.eventbus.EventBus)delegate;
  }

  public io.vertx.core.eventbus.EventBus getDelegate() {
    return delegate;
  }


  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Sends a message.
   * <p>
   * The message will be delivered to at most one of the handlers registered to the address.
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus send(String address, java.lang.Object message) { 
    delegate.send(address, message);
    return this;
  }

  /**
   * Like  but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus send(String address, java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options) { 
    delegate.send(address, message, options);
    return this;
  }

  /**
   * Sends a message and and specify a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * <p>
   * The message will be delivered to at most one of the handlers registered to the address.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param replyHandler reply handler will be called when any reply from the recipient is received
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus request(String address, java.lang.Object message, Handler<AsyncResult<io.vertx.reactivex.core.eventbus.Message<T>>> replyHandler) { 
    delegate.request(address, message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)ar.result(), TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Sends a message and and specify a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * <p>
   * The message will be delivered to at most one of the handlers registered to the address.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus request(String address, java.lang.Object message) {
    return 
request(address, message, ar -> { });
  }

  /**
   * Sends a message and and specify a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * <p>
   * The message will be delivered to at most one of the handlers registered to the address.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.reactivex.Single<io.vertx.reactivex.core.eventbus.Message<T>> rxRequest(String address, java.lang.Object message) { 
    return AsyncResultSingle.toSingle($handler -> {
      request(address, message, $handler);
    });
  }

  /**
   * Like  but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @param replyHandler reply handler will be called when any reply from the recipient is received
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus request(String address, java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options, Handler<AsyncResult<io.vertx.reactivex.core.eventbus.Message<T>>> replyHandler) { 
    delegate.request(address, message, options, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)ar.result(), TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like  but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus request(String address, java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options) {
    return 
request(address, message, options, ar -> { });
  }

  /**
   * Like  but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.reactivex.Single<io.vertx.reactivex.core.eventbus.Message<T>> rxRequest(String address, java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      request(address, message, options, $handler);
    });
  }

  /**
   * Publish a message.<p>
   * The message will be delivered to all handlers registered to the address.
   * @param address the address to publish it to
   * @param message the message, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus publish(String address, java.lang.Object message) { 
    delegate.publish(address, message);
    return this;
  }

  /**
   * Like  but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to publish it to
   * @param message the message, may be <code>null</code>
   * @param options the delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus publish(String address, java.lang.Object message, io.vertx.core.eventbus.DeliveryOptions options) { 
    delegate.publish(address, message, options);
    return this;
  }

  /**
   * Create a message consumer against the specified address.
   * <p>
   * The returned consumer is not yet registered
   * at the address, registration will be effective when {@link io.vertx.reactivex.core.eventbus.MessageConsumer#handler}
   * is called.
   * @param address the address that it will register it at
   * @return the event bus message consumer
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageConsumer<T> consumer(String address) { 
    io.vertx.reactivex.core.eventbus.MessageConsumer<T> ret = io.vertx.reactivex.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.consumer(address), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a consumer and register it against the specified address.
   * @param address the address that will register it at
   * @param handler the handler that will process the received messages
   * @return the event bus message consumer
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageConsumer<T> consumer(String address, Handler<io.vertx.reactivex.core.eventbus.Message<T>> handler) { 
    io.vertx.reactivex.core.eventbus.MessageConsumer<T> ret = io.vertx.reactivex.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.consumer(address, new Handler<io.vertx.core.eventbus.Message<T>>() {
      public void handle(io.vertx.core.eventbus.Message<T> event) {
        handler.handle(io.vertx.reactivex.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)event, TypeArg.unknown()));
      }
    }), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#consumer} but the address won't be propagated across the cluster.
   * @param address the address to register it at
   * @return the event bus message consumer
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageConsumer<T> localConsumer(String address) { 
    io.vertx.reactivex.core.eventbus.MessageConsumer<T> ret = io.vertx.reactivex.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.localConsumer(address), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#consumer} but the address won't be propagated across the cluster.
   * @param address the address that will register it at
   * @param handler the handler that will process the received messages
   * @return the event bus message consumer
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageConsumer<T> localConsumer(String address, Handler<io.vertx.reactivex.core.eventbus.Message<T>> handler) { 
    io.vertx.reactivex.core.eventbus.MessageConsumer<T> ret = io.vertx.reactivex.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.localConsumer(address, new Handler<io.vertx.core.eventbus.Message<T>>() {
      public void handle(io.vertx.core.eventbus.Message<T> event) {
        handler.handle(io.vertx.reactivex.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)event, TypeArg.unknown()));
      }
    }), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a message sender against the specified address.
   * <p>
   * The returned sender will invoke the 
   * method when the stream {@link io.vertx.reactivex.core.streams.WriteStream#write} method is called with the sender
   * address and the provided data.
   * @param address the address to send it to
   * @return The sender
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageProducer<T> sender(String address) { 
    io.vertx.reactivex.core.eventbus.MessageProducer<T> ret = io.vertx.reactivex.core.eventbus.MessageProducer.newInstance((io.vertx.core.eventbus.MessageProducer)delegate.sender(address), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#sender} but specifying delivery options that will be used for configuring the delivery of
   * the message.
   * @param address the address to send it to
   * @param options the delivery options
   * @return The sender
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageProducer<T> sender(String address, io.vertx.core.eventbus.DeliveryOptions options) { 
    io.vertx.reactivex.core.eventbus.MessageProducer<T> ret = io.vertx.reactivex.core.eventbus.MessageProducer.newInstance((io.vertx.core.eventbus.MessageProducer)delegate.sender(address, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Create a message publisher against the specified address.
   * <p>
   * The returned publisher will invoke the 
   * method when the stream {@link io.vertx.reactivex.core.streams.WriteStream#write} method is called with the publisher
   * address and the provided data.
   * @param address The address to publish it to
   * @return The publisher
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageProducer<T> publisher(String address) { 
    io.vertx.reactivex.core.eventbus.MessageProducer<T> ret = io.vertx.reactivex.core.eventbus.MessageProducer.newInstance((io.vertx.core.eventbus.MessageProducer)delegate.publisher(address), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.eventbus.EventBus#publisher} but specifying delivery options that will be used for configuring the delivery of
   * the message.
   * @param address the address to publish it to
   * @param options the delivery options
   * @return The publisher
   */
  public <T> io.vertx.reactivex.core.eventbus.MessageProducer<T> publisher(String address, io.vertx.core.eventbus.DeliveryOptions options) { 
    io.vertx.reactivex.core.eventbus.MessageProducer<T> ret = io.vertx.reactivex.core.eventbus.MessageProducer.newInstance((io.vertx.core.eventbus.MessageProducer)delegate.publisher(address, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Add an interceptor that will be called whenever a message is sent from Vert.x
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus addOutboundInterceptor(Handler<io.vertx.reactivex.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.addOutboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>() {
      public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
        interceptor.handle(io.vertx.reactivex.core.eventbus.DeliveryContext.newInstance((io.vertx.core.eventbus.DeliveryContext)event, TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Remove an interceptor that was added by {@link io.vertx.reactivex.core.eventbus.EventBus#addOutboundInterceptor}
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus removeOutboundInterceptor(Handler<io.vertx.reactivex.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.removeOutboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>() {
      public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
        interceptor.handle(io.vertx.reactivex.core.eventbus.DeliveryContext.newInstance((io.vertx.core.eventbus.DeliveryContext)event, TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Add an interceptor that will be called whenever a message is received by Vert.x
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus addInboundInterceptor(Handler<io.vertx.reactivex.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.addInboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>() {
      public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
        interceptor.handle(io.vertx.reactivex.core.eventbus.DeliveryContext.newInstance((io.vertx.core.eventbus.DeliveryContext)event, TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Remove an interceptor that was added by {@link io.vertx.reactivex.core.eventbus.EventBus#addInboundInterceptor}
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.reactivex.core.eventbus.EventBus removeInboundInterceptor(Handler<io.vertx.reactivex.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.removeInboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>() {
      public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
        interceptor.handle(io.vertx.reactivex.core.eventbus.DeliveryContext.newInstance((io.vertx.core.eventbus.DeliveryContext)event, TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Register a message codec.
   * <p>
   * You can register a message codec if you want to send any non standard message across the event bus.
   * E.g. you might want to send POJOs directly across the event bus.
   * <p>
   * To use a message codec for a send, you should specify it in the delivery options.
   * @param codec the message codec to register
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus registerCodec(io.vertx.core.eventbus.MessageCodec codec) { 
    io.vertx.reactivex.core.eventbus.EventBus ret = io.vertx.reactivex.core.eventbus.EventBus.newInstance((io.vertx.core.eventbus.EventBus)delegate.registerCodec(codec));
    return ret;
  }

  /**
   * Unregister a message codec.
   * <p>
   * @param name the name of the codec
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.eventbus.EventBus unregisterCodec(String name) { 
    io.vertx.reactivex.core.eventbus.EventBus ret = io.vertx.reactivex.core.eventbus.EventBus.newInstance((io.vertx.core.eventbus.EventBus)delegate.unregisterCodec(name));
    return ret;
  }

  public static EventBus newInstance(io.vertx.core.eventbus.EventBus arg) {
    return arg != null ? new EventBus(arg) : null;
  }

}
