/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.file;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a file on the file-system which can be read from, or written to asynchronously.
 * <p>
 * This class also implements {@link io.vertx.reactivex.core.streams.ReadStream} and
 * {@link io.vertx.reactivex.core.streams.WriteStream}. This allows the data to be piped to and from
 * other streams, e.g. an {@link io.vertx.reactivex.core.http.HttpClientRequest} instance,
 * using the {@link io.vertx.reactivex.core.streams.Pipe} class
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.file.AsyncFile original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.file.AsyncFile.class)
public class AsyncFile implements io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer>, io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncFile that = (AsyncFile) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AsyncFile> __TYPE_ARG = new TypeArg<>(    obj -> new AsyncFile((io.vertx.core.file.AsyncFile) obj),
    AsyncFile::getDelegate
  );

  private final io.vertx.core.file.AsyncFile delegate;
  
  public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
    this.delegate = delegate;
  }

  public AsyncFile(Object delegate) {
    this.delegate = (io.vertx.core.file.AsyncFile)delegate;
  }

  public io.vertx.core.file.AsyncFile getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
    if (flowable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  private WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> observer;
  private WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> toObserver() {
    if (observer == null) {
      Function<io.vertx.reactivex.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.reactivex.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.buffer.Buffer>(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void write(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void write(io.vertx.reactivex.core.buffer.Buffer data) {
    write(data, ar -> { });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      write(data, $handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   */
  public void end() {
    end(ar -> { });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      end($handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   */
  public void end(io.vertx.reactivex.core.buffer.Buffer data) {
    end(data, ar -> { });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.Completable rxEnd(io.vertx.reactivex.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      end(data, $handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.core.file.AsyncFile#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
    pipeTo(dst, ar -> { });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      pipeTo(dst, $handler);
    });
  }

  public io.vertx.reactivex.core.file.AsyncFile handler(Handler<io.vertx.reactivex.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event));
      }
    });
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Close the file. The actual close happens asynchronously.
   * The handler will be called when the close is complete, or an error occurs.
   * @param handler the handler
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the file. The actual close happens asynchronously.
   * The handler will be called when the close is complete, or an error occurs.
   */
  public void close() {
    close(ar -> { });
  }

  /**
   * Close the file. The actual close happens asynchronously.
   * The handler will be called when the close is complete, or an error occurs.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close($handler);
    });
  }

  /**
   * Write a {@link io.vertx.reactivex.core.buffer.Buffer} to the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * If <code>position</code> lies outside of the current size
   * of the file, the file will be enlarged to encompass it.
   * <p>
   * When multiple writes are invoked on the same file
   * there are no guarantees as to order in which those writes actually occur
   * <p>
   * The handler will be called when the write is complete, or if an error occurs.
   * @param buffer the buffer to write
   * @param position the position in the file to write it at
   * @param handler the handler to call when the write is complete
   */
  public void write(io.vertx.reactivex.core.buffer.Buffer buffer, long position, Handler<AsyncResult<Void>> handler) { 
    delegate.write(buffer.getDelegate(), position, handler);
  }

  /**
   * Write a {@link io.vertx.reactivex.core.buffer.Buffer} to the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * If <code>position</code> lies outside of the current size
   * of the file, the file will be enlarged to encompass it.
   * <p>
   * When multiple writes are invoked on the same file
   * there are no guarantees as to order in which those writes actually occur
   * <p>
   * The handler will be called when the write is complete, or if an error occurs.
   * @param buffer the buffer to write
   * @param position the position in the file to write it at
   */
  public void write(io.vertx.reactivex.core.buffer.Buffer buffer, long position) {
    write(buffer, position, ar -> { });
  }

  /**
   * Write a {@link io.vertx.reactivex.core.buffer.Buffer} to the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * If <code>position</code> lies outside of the current size
   * of the file, the file will be enlarged to encompass it.
   * <p>
   * When multiple writes are invoked on the same file
   * there are no guarantees as to order in which those writes actually occur
   * <p>
   * The handler will be called when the write is complete, or if an error occurs.
   * @param buffer the buffer to write
   * @param position the position in the file to write it at
   * @return 
   */
  public io.reactivex.Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer buffer, long position) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      write(buffer, position, $handler);
    });
  }

  /**
   * Reads <code>length</code> bytes of data from the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * The read data will be written into the specified <code>Buffer buffer</code> at position <code>offset</code>.
   * <p>
   * If data is read past the end of the file then zero bytes will be read.<p>
   * When multiple reads are invoked on the same file there are no guarantees as to order in which those reads actually occur.
   * <p>
   * The handler will be called when the close is complete, or if an error occurs.
   * @param buffer the buffer to read into
   * @param offset the offset into the buffer where the data will be read
   * @param position the position in the file where to start reading
   * @param length the number of bytes to read
   * @param handler the handler to call when the write is complete
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.file.AsyncFile read(io.vertx.reactivex.core.buffer.Buffer buffer, int offset, long position, int length, Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>> handler) { 
    delegate.read(buffer.getDelegate(), offset, position, length, new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>() {
      public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Reads <code>length</code> bytes of data from the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * The read data will be written into the specified <code>Buffer buffer</code> at position <code>offset</code>.
   * <p>
   * If data is read past the end of the file then zero bytes will be read.<p>
   * When multiple reads are invoked on the same file there are no guarantees as to order in which those reads actually occur.
   * <p>
   * The handler will be called when the close is complete, or if an error occurs.
   * @param buffer the buffer to read into
   * @param offset the offset into the buffer where the data will be read
   * @param position the position in the file where to start reading
   * @param length the number of bytes to read
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.file.AsyncFile read(io.vertx.reactivex.core.buffer.Buffer buffer, int offset, long position, int length) {
    return 
read(buffer, offset, position, length, ar -> { });
  }

  /**
   * Reads <code>length</code> bytes of data from the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * The read data will be written into the specified <code>Buffer buffer</code> at position <code>offset</code>.
   * <p>
   * If data is read past the end of the file then zero bytes will be read.<p>
   * When multiple reads are invoked on the same file there are no guarantees as to order in which those reads actually occur.
   * <p>
   * The handler will be called when the close is complete, or if an error occurs.
   * @param buffer the buffer to read into
   * @param offset the offset into the buffer where the data will be read
   * @param position the position in the file where to start reading
   * @param length the number of bytes to read
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.Single<io.vertx.reactivex.core.buffer.Buffer> rxRead(io.vertx.reactivex.core.buffer.Buffer buffer, int offset, long position, int length) { 
    return AsyncResultSingle.toSingle($handler -> {
      read(buffer, offset, position, length, $handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.file.AsyncFile#flush} but the handler will be called when the flush is complete or if an error occurs
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.core.file.AsyncFile flush(Handler<AsyncResult<Void>> handler) { 
    delegate.flush(handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.reactivex.core.file.AsyncFile#flush} but the handler will be called when the flush is complete or if an error occurs
   * @return 
   */
  public io.vertx.reactivex.core.file.AsyncFile flush() {
    return 
flush(ar -> { });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.file.AsyncFile#flush} but the handler will be called when the flush is complete or if an error occurs
   * @return 
   */
  public io.reactivex.Completable rxFlush() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      flush($handler);
    });
  }

  /**
   * Sets the position from which data will be read from when using the file as a {@link io.vertx.reactivex.core.streams.ReadStream}.
   * @param readPos the position in the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.file.AsyncFile setReadPos(long readPos) { 
    delegate.setReadPos(readPos);
    return this;
  }

  /**
   * Sets the number of bytes that will be read when using the file as a {@link io.vertx.reactivex.core.streams.ReadStream}.
   * @param readLength the bytes that will be read from the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.file.AsyncFile setReadLength(long readLength) { 
    delegate.setReadLength(readLength);
    return this;
  }

  /**
   * @return the number of bytes that will be read when using the file as a {@link io.vertx.reactivex.core.streams.ReadStream}
   */
  public long getReadLength() { 
    long ret = delegate.getReadLength();
    return ret;
  }

  /**
   * Sets the position from which data will be written when using the file as a {@link io.vertx.reactivex.core.streams.WriteStream}.
   * @param writePos the position in the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.file.AsyncFile setWritePos(long writePos) { 
    delegate.setWritePos(writePos);
    return this;
  }

  /**
   * @return the current write position the file is at
   */
  public long getWritePos() { 
    long ret = delegate.getWritePos();
    return ret;
  }

  /**
   * Sets the buffer size that will be used to read the data from the file. Changing this value will impact how much
   * the data will be read at a time from the file system.
   * @param readBufferSize the buffer size
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.file.AsyncFile setReadBufferSize(int readBufferSize) { 
    delegate.setReadBufferSize(readBufferSize);
    return this;
  }

  public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
    return arg != null ? new AsyncFile(arg) : null;
  }

}
