/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.shareddata;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous map.
 * <p>
 * {@link io.vertx.reactivex.core.shareddata.AsyncMap} does <em>not</em> allow <code>null</code> to be used as a key or value.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.AsyncMap original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.shareddata.AsyncMap.class)
public class AsyncMap<K,V> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncMap that = (AsyncMap) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AsyncMap> __TYPE_ARG = new TypeArg<>(    obj -> new AsyncMap((io.vertx.core.shareddata.AsyncMap) obj),
    AsyncMap::getDelegate
  );

  private final io.vertx.core.shareddata.AsyncMap<K,V> delegate;
  public final TypeArg<K> __typeArg_0;
  public final TypeArg<V> __typeArg_1;
  
  public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public AsyncMap(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.core.shareddata.AsyncMap)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public io.vertx.core.shareddata.AsyncMap getDelegate() {
    return delegate;
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @param resultHandler - this will be called some time later with the async result.
   */
  public void get(K k, Handler<AsyncResult<V>> resultHandler) { 
    delegate.get(__typeArg_0.<K>unwrap(k), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   */
  public void get(K k) {
    get(k, ar -> { });
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @return 
   */
  public io.reactivex.Maybe<V> rxGet(K k) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      get(k, $handler);
    });
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @param completionHandler - this will be called some time later to signify the value has been put
   */
  public void put(K k, V v, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.put(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), completionHandler);
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   */
  public void put(K k, V v) {
    put(k, v, ar -> { });
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @return 
   */
  public io.reactivex.Completable rxPut(K k, V v) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      put(k, v, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @param completionHandler the handler
   */
  public void put(K k, V v, long ttl, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.put(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl, completionHandler);
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   */
  public void put(K k, V v, long ttl) {
    put(k, v, ttl, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   */
  public io.reactivex.Completable rxPut(K k, V v, long ttl) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      put(k, v, ttl, $handler);
    });
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @param completionHandler the handler
   */
  public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> completionHandler) { 
    delegate.putIfAbsent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   */
  public void putIfAbsent(K k, V v) {
    putIfAbsent(k, v, ar -> { });
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @return 
   */
  public io.reactivex.Maybe<V> rxPutIfAbsent(K k, V v) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      putIfAbsent(k, v, $handler);
    });
  }

  /**
   * Link {@link io.vertx.reactivex.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @param completionHandler the handler
   */
  public void putIfAbsent(K k, V v, long ttl, Handler<AsyncResult<V>> completionHandler) { 
    delegate.putIfAbsent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl, new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Link {@link io.vertx.reactivex.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   */
  public void putIfAbsent(K k, V v, long ttl) {
    putIfAbsent(k, v, ttl, ar -> { });
  }

  /**
   * Link {@link io.vertx.reactivex.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   */
  public io.reactivex.Maybe<V> rxPutIfAbsent(K k, V v, long ttl) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      putIfAbsent(k, v, ttl, $handler);
    });
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @param resultHandler - this will be called some time later to signify the value has been removed
   */
  public void remove(K k, Handler<AsyncResult<V>> resultHandler) { 
    delegate.remove(__typeArg_0.<K>unwrap(k), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   */
  public void remove(K k) {
    remove(k, ar -> { });
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @return 
   */
  public io.reactivex.Maybe<V> rxRemove(K k) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      remove(k, $handler);
    });
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @param resultHandler - this will be called some time later to signify the value has been removed
   */
  public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.removeIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), resultHandler);
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   */
  public void removeIfPresent(K k, V v) {
    removeIfPresent(k, v, ar -> { });
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @return 
   */
  public io.reactivex.Single<Boolean> rxRemoveIfPresent(K k, V v) { 
    return AsyncResultSingle.toSingle($handler -> {
      removeIfPresent(k, v, $handler);
    });
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @param resultHandler the result handler will be passed the previous value
   */
  public void replace(K k, V v, Handler<AsyncResult<V>> resultHandler) { 
    delegate.replace(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   */
  public void replace(K k, V v) {
    replace(k, v, ar -> { });
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @return 
   */
  public io.reactivex.Maybe<V> rxReplace(K k, V v) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      replace(k, v, $handler);
    });
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @param resultHandler the result handler
   */
  public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.replaceIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(oldValue), __typeArg_1.<V>unwrap(newValue), resultHandler);
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   */
  public void replaceIfPresent(K k, V oldValue, V newValue) {
    replaceIfPresent(k, oldValue, newValue, ar -> { });
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @return 
   */
  public io.reactivex.Single<Boolean> rxReplaceIfPresent(K k, V oldValue, V newValue) { 
    return AsyncResultSingle.toSingle($handler -> {
      replaceIfPresent(k, oldValue, newValue, $handler);
    });
  }

  /**
   * Clear all entries in the map
   * @param resultHandler called on completion
   */
  public void clear(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.clear(resultHandler);
  }

  /**
   * Clear all entries in the map
   */
  public void clear() {
    clear(ar -> { });
  }

  /**
   * Clear all entries in the map
   * @return 
   */
  public io.reactivex.Completable rxClear() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      clear($handler);
    });
  }

  /**
   * Provide the number of entries in the map
   * @param resultHandler handler which will receive the number of entries
   */
  public void size(Handler<AsyncResult<Integer>> resultHandler) { 
    delegate.size(resultHandler);
  }

  /**
   * Provide the number of entries in the map
   */
  public void size() {
    size(ar -> { });
  }

  /**
   * Provide the number of entries in the map
   * @return 
   */
  public io.reactivex.Single<Integer> rxSize() { 
    return AsyncResultSingle.toSingle($handler -> {
      size($handler);
    });
  }

  public static <K,V> AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg) {
    return arg != null ? new AsyncMap<K,V>(arg) : null;
  }

  public static <K,V> AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
    return arg != null ? new AsyncMap<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
