/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Hashing Algorithm. A common interface to interact with any system provided algorithms.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.HashingAlgorithm original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.HashingAlgorithm.class)
public class HashingAlgorithm {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HashingAlgorithm that = (HashingAlgorithm) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HashingAlgorithm> __TYPE_ARG = new TypeArg<>(    obj -> new HashingAlgorithm((io.vertx.ext.auth.HashingAlgorithm) obj),
    HashingAlgorithm::getDelegate
  );

  private final io.vertx.ext.auth.HashingAlgorithm delegate;
  
  public HashingAlgorithm(io.vertx.ext.auth.HashingAlgorithm delegate) {
    this.delegate = delegate;
  }

  public HashingAlgorithm(Object delegate) {
    this.delegate = (io.vertx.ext.auth.HashingAlgorithm)delegate;
  }

  public io.vertx.ext.auth.HashingAlgorithm getDelegate() {
    return delegate;
  }


  /**
   * return the symbolic name for the algorithm
   * @return short id e.g.: sha512.
   */
  public String id() { 
    String ret = delegate.id();
    return ret;
  }

  /**
   * return the list of param names required for this algorithm.
   * @return set of param names.
   */
  public Set<String> params() { 
    Set<String> ret = delegate.params();
    return ret;
  }

  /**
   * Should the encoded string use the default separator to split fields.
   * @return true by default.
   */
  public boolean needsSeparator() { 
    boolean ret = delegate.needsSeparator();
    return ret;
  }

  public static HashingAlgorithm newInstance(io.vertx.ext.auth.HashingAlgorithm arg) {
    return arg != null ? new HashingAlgorithm(arg) : null;
  }

}
