/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.authorization;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The role of an AuthorizationProvider is to return a set of Authorization.
 * Note that each AuthorizationProvider must provide its own unique Id
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.AuthorizationProvider original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.AuthorizationProvider.class)
public class AuthorizationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuthorizationProvider that = (AuthorizationProvider) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AuthorizationProvider> __TYPE_ARG = new TypeArg<>(    obj -> new AuthorizationProvider((io.vertx.ext.auth.authorization.AuthorizationProvider) obj),
    AuthorizationProvider::getDelegate
  );

  private final io.vertx.ext.auth.authorization.AuthorizationProvider delegate;
  
  public AuthorizationProvider(io.vertx.ext.auth.authorization.AuthorizationProvider delegate) {
    this.delegate = delegate;
  }

  public AuthorizationProvider(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authorization.AuthorizationProvider)delegate;
  }

  public io.vertx.ext.auth.authorization.AuthorizationProvider getDelegate() {
    return delegate;
  }

  /**
   * create an authorization provider with the specified id and authorizations
   * @param id 
   * @param authorizations 
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.authorization.AuthorizationProvider create(String id, Set<io.vertx.reactivex.ext.auth.authorization.Authorization> authorizations) { 
    io.vertx.reactivex.ext.auth.authorization.AuthorizationProvider ret = io.vertx.reactivex.ext.auth.authorization.AuthorizationProvider.newInstance((io.vertx.ext.auth.authorization.AuthorizationProvider)io.vertx.ext.auth.authorization.AuthorizationProvider.create(id, authorizations.stream().map(elt -> elt.getDelegate()).collect(Collectors.toSet())));
    return ret;
  }

  /**
   * returns the id of the authorization provider
   * @return 
   */
  public String getId() { 
    String ret = delegate.getId();
    return ret;
  }

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update
   * @param handler result handler
   */
  public void getAuthorizations(io.vertx.reactivex.ext.auth.User user, Handler<AsyncResult<Void>> handler) { 
    delegate.getAuthorizations(user.getDelegate(), handler);
  }

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update
   */
  public void getAuthorizations(io.vertx.reactivex.ext.auth.User user) {
    getAuthorizations(user, ar -> { });
  }

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update
   * @return 
   */
  public io.reactivex.Completable rxGetAuthorizations(io.vertx.reactivex.ext.auth.User user) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      getAuthorizations(user, $handler);
    });
  }

  public static AuthorizationProvider newInstance(io.vertx.ext.auth.authorization.AuthorizationProvider arg) {
    return arg != null ? new AuthorizationProvider(arg) : null;
  }

}
