/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2.providers;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Simplified factory to create an  for Dropbox.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.DropboxAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.providers.DropboxAuth.class)
public class DropboxAuth {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DropboxAuth that = (DropboxAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DropboxAuth> __TYPE_ARG = new TypeArg<>(    obj -> new DropboxAuth((io.vertx.ext.auth.oauth2.providers.DropboxAuth) obj),
    DropboxAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.DropboxAuth delegate;
  
  public DropboxAuth(io.vertx.ext.auth.oauth2.providers.DropboxAuth delegate) {
    this.delegate = delegate;
  }

  public DropboxAuth(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.providers.DropboxAuth)delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.DropboxAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for Dropbox
   * @param vertx 
   * @param clientId the client id given to you by Dropbox
   * @param clientSecret the client secret given to you by Dropbox
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, String clientId, String clientSecret) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.DropboxAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Dropbox
   * @param vertx 
   * @param clientId the client id given to you by Dropbox
   * @param clientSecret the client secret given to you by Dropbox
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, String clientId, String clientSecret, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.DropboxAuth.create(vertx.getDelegate(), clientId, clientSecret, httpClientOptions));
    return ret;
  }

  public static DropboxAuth newInstance(io.vertx.ext.auth.oauth2.providers.DropboxAuth arg) {
    return arg != null ? new DropboxAuth(arg) : null;
  }

}
