/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2.providers;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Simplified factory to create an  for Keycloak.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.KeycloakAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.providers.KeycloakAuth.class)
public class KeycloakAuth extends io.vertx.reactivex.ext.auth.oauth2.providers.OpenIDConnectAuth {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KeycloakAuth that = (KeycloakAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KeycloakAuth> __TYPE_ARG = new TypeArg<>(    obj -> new KeycloakAuth((io.vertx.ext.auth.oauth2.providers.KeycloakAuth) obj),
    KeycloakAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.KeycloakAuth delegate;
  
  public KeycloakAuth(io.vertx.ext.auth.oauth2.providers.KeycloakAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public KeycloakAuth(Object delegate) {
    super((io.vertx.ext.auth.oauth2.providers.KeycloakAuth)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.providers.KeycloakAuth)delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.KeycloakAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for Keycloak
   * @param vertx 
   * @param config the json config file exported from Keycloak admin console
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, JsonObject config) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.KeycloakAuth.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Keycloak
   * @param vertx 
   * @param flow the oauth2 flow to use
   * @param config the json config file exported from Keycloak admin console
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2FlowType flow, JsonObject config) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.KeycloakAuth.create(vertx.getDelegate(), flow, config));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Keycloak
   * @param vertx 
   * @param config the json config file exported from Keycloak admin console
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, JsonObject config, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.KeycloakAuth.create(vertx.getDelegate(), config, httpClientOptions));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Keycloak
   * @param vertx 
   * @param flow the oauth2 flow to use
   * @param config the json config file exported from Keycloak admin console
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2FlowType flow, JsonObject config, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.KeycloakAuth.create(vertx.getDelegate(), flow, config, httpClientOptions));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config
   * @param handler the instantiated Oauth2 provider instance handler
   */
  public static void discover(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config, Handler<AsyncResult<io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth>> handler) { 
    io.vertx.ext.auth.oauth2.providers.KeycloakAuth.discover(vertx.getDelegate(), config, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config
   */
  public static void discover(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) {
    discover(vertx, config, ar -> { });
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth> rxDiscover(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    return AsyncResultSingle.toSingle($handler -> {
      discover(vertx, config, $handler);
    });
  }

  public static KeycloakAuth newInstance(io.vertx.ext.auth.oauth2.providers.KeycloakAuth arg) {
    return arg != null ? new KeycloakAuth(arg) : null;
  }

}
