/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.sqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Utility to create users/roles/permissions. This is a helper class and not intended to be a full user
 * management utility. While the standard authentication and authorization interfaces will require usually
 * read only access to the database, in order to use this API a full read/write access must be granted.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.sqlclient.SqlUserUtil original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.sqlclient.SqlUserUtil.class)
public class SqlUserUtil {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlUserUtil that = (SqlUserUtil) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SqlUserUtil> __TYPE_ARG = new TypeArg<>(    obj -> new SqlUserUtil((io.vertx.ext.auth.sqlclient.SqlUserUtil) obj),
    SqlUserUtil::getDelegate
  );

  private final io.vertx.ext.auth.sqlclient.SqlUserUtil delegate;
  
  public SqlUserUtil(io.vertx.ext.auth.sqlclient.SqlUserUtil delegate) {
    this.delegate = delegate;
  }

  public SqlUserUtil(Object delegate) {
    this.delegate = (io.vertx.ext.auth.sqlclient.SqlUserUtil)delegate;
  }

  public io.vertx.ext.auth.sqlclient.SqlUserUtil getDelegate() {
    return delegate;
  }

  /**
   * Create an instance of the user helper.
   * @param client the client with write rights to the database.
   * @return the instance
   */
  public static io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil create(io.vertx.reactivex.sqlclient.SqlClient client) { 
    io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil ret = io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil.newInstance((io.vertx.ext.auth.sqlclient.SqlUserUtil)io.vertx.ext.auth.sqlclient.SqlUserUtil.create(client.getDelegate()));
    return ret;
  }

  /**
   * Create an instance of the user helper with custom queries.
   * @param client the client with write rights to the database.
   * @param insertUserSQL 
   * @param insertUserRoleSQL 
   * @param insertRolePermissionSQL 
   * @return the instance
   */
  public static io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil create(io.vertx.reactivex.sqlclient.SqlClient client, String insertUserSQL, String insertUserRoleSQL, String insertRolePermissionSQL) { 
    io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil ret = io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil.newInstance((io.vertx.ext.auth.sqlclient.SqlUserUtil)io.vertx.ext.auth.sqlclient.SqlUserUtil.create(client.getDelegate(), insertUserSQL, insertUserRoleSQL, insertRolePermissionSQL));
    return ret;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined strategy
   * @param resultHandler the ResultHandler will be provided with the result of the operation
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil createUser(String username, String password, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createUser(username, password, resultHandler);
    return this;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined strategy
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil createUser(String username, String password) {
    return 
createUser(username, password, ar -> { });
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined strategy
   * @return fluent self
   */
  public io.reactivex.Completable rxCreateUser(String username, String password) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createUser(username, password, $handler);
    });
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.reactivex.ext.auth.HashingStrategy#hash}
   * @param resultHandler the ResultHandler will be provided with the result of the operation
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil createHashedUser(String username, String hash, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createHashedUser(username, hash, resultHandler);
    return this;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.reactivex.ext.auth.HashingStrategy#hash}
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil createHashedUser(String username, String hash) {
    return 
createHashedUser(username, hash, ar -> { });
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.reactivex.ext.auth.HashingStrategy#hash}
   * @return fluent self
   */
  public io.reactivex.Completable rxCreateHashedUser(String username, String hash) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createHashedUser(username, hash, $handler);
    });
  }

  /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param role a to be set
   * @param resultHandler the ResultHandler will be provided with the result of the operation
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil createUserRole(String username, String role, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createUserRole(username, role, resultHandler);
    return this;
  }

  /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param role a to be set
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil createUserRole(String username, String role) {
    return 
createUserRole(username, role, ar -> { });
  }

  /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param role a to be set
   * @return fluent self
   */
  public io.reactivex.Completable rxCreateUserRole(String username, String role) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createUserRole(username, role, $handler);
    });
  }

  /**
   * Insert a role permission into a database.
   * @param role a to be set
   * @param permission the permission to be set
   * @param resultHandler the ResultHandler will be provided with the result of the operation
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil createRolePermission(String role, String permission, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createRolePermission(role, permission, resultHandler);
    return this;
  }

  /**
   * Insert a role permission into a database.
   * @param role a to be set
   * @param permission the permission to be set
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.sqlclient.SqlUserUtil createRolePermission(String role, String permission) {
    return 
createRolePermission(role, permission, ar -> { });
  }

  /**
   * Insert a role permission into a database.
   * @param role a to be set
   * @param permission the permission to be set
   * @return fluent self
   */
  public io.reactivex.Completable rxCreateRolePermission(String role, String permission) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createRolePermission(role, permission, $handler);
    });
  }

  public static SqlUserUtil newInstance(io.vertx.ext.auth.sqlclient.SqlUserUtil arg) {
    return arg != null ? new SqlUserUtil(arg) : null;
  }

}
