/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.webauthn;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating FIDO2 MetaDataService.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.webauthn.MetaDataService original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.webauthn.MetaDataService.class)
public class MetaDataService {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MetaDataService that = (MetaDataService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MetaDataService> __TYPE_ARG = new TypeArg<>(    obj -> new MetaDataService((io.vertx.ext.auth.webauthn.MetaDataService) obj),
    MetaDataService::getDelegate
  );

  private final io.vertx.ext.auth.webauthn.MetaDataService delegate;
  
  public MetaDataService(io.vertx.ext.auth.webauthn.MetaDataService delegate) {
    this.delegate = delegate;
  }

  public MetaDataService(Object delegate) {
    this.delegate = (io.vertx.ext.auth.webauthn.MetaDataService)delegate;
  }

  public io.vertx.ext.auth.webauthn.MetaDataService getDelegate() {
    return delegate;
  }

  /**
   * Fetches the FIDO2 TOC for the given URL and process the entries to the metadata store.
   * Only valid entries will be stored. The operation will return <code>true</code> only if all
   * entries have been added. <code>false</code> if they have been processed but at least one was
   * invalid.
   *
   * The operation will only fail on network problems.
   * @param url the url to the TOC
   * @param handler the async handler to process the response
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.webauthn.MetaDataService fetchTOC(String url, Handler<AsyncResult<Boolean>> handler) { 
    delegate.fetchTOC(url, handler);
    return this;
  }

  /**
   * Fetches the FIDO2 TOC for the given URL and process the entries to the metadata store.
   * Only valid entries will be stored. The operation will return <code>true</code> only if all
   * entries have been added. <code>false</code> if they have been processed but at least one was
   * invalid.
   *
   * The operation will only fail on network problems.
   * @param url the url to the TOC
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.webauthn.MetaDataService fetchTOC(String url) {
    return 
fetchTOC(url, ar -> { });
  }

  /**
   * Fetches the FIDO2 TOC for the given URL and process the entries to the metadata store.
   * Only valid entries will be stored. The operation will return <code>true</code> only if all
   * entries have been added. <code>false</code> if they have been processed but at least one was
   * invalid.
   *
   * The operation will only fail on network problems.
   * @param url the url to the TOC
   * @return fluent self
   */
  public io.reactivex.Single<Boolean> rxFetchTOC(String url) { 
    return AsyncResultSingle.toSingle($handler -> {
      fetchTOC(url, $handler);
    });
  }

  /**
   * Manually feed a Meta Data Statement to the service.
   * @param statement the json statement
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.webauthn.MetaDataService addStatement(JsonObject statement) { 
    delegate.addStatement(statement);
    return this;
  }

  /**
   * Clears all loaded statements, both from the TOC and manually inserted.
   * The flush operation will not cancel any in-flight TOC download/processing.
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.webauthn.MetaDataService flush() { 
    delegate.flush();
    return this;
  }

  public static MetaDataService newInstance(io.vertx.ext.auth.webauthn.MetaDataService arg) {
    return arg != null ? new MetaDataService(arg) : null;
  }

}
