/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.sql;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A common asynchronous client interface for interacting with SQL compliant database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.sql.SQLClient.class)
public class SQLClient implements io.vertx.reactivex.ext.sql.SQLOperations {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SQLClient that = (SQLClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SQLClient> __TYPE_ARG = new TypeArg<>(    obj -> new SQLClient((io.vertx.ext.sql.SQLClient) obj),
    SQLClient::getDelegate
  );

  private final io.vertx.ext.sql.SQLClient delegate;
  
  public SQLClient(io.vertx.ext.sql.SQLClient delegate) {
    this.delegate = delegate;
  }

  public SQLClient(Object delegate) {
    this.delegate = (io.vertx.ext.sql.SQLClient)delegate;
  }

  public io.vertx.ext.sql.SQLClient getDelegate() {
    return delegate;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingle(String sql) {
    return 
querySingle(sql, ar -> { });
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public io.reactivex.Maybe<JsonArray> rxQuerySingle(String sql) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      querySingle(sql, $handler);
    });
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @param handler the result handler
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingleWithParams(String sql, JsonArray arguments) {
    return 
querySingleWithParams(sql, arguments, ar -> { });
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public io.reactivex.Maybe<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      querySingleWithParams(sql, arguments, $handler);
    });
  }

  /**
   * Returns a connection that can be used to perform SQL operations on. It's important to remember
   * to close the connection when you are done, so it is returned to the pool.
   * @param handler the handler which is called when the <code>JdbcConnection</code> object is ready for use.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient getConnection(Handler<AsyncResult<io.vertx.reactivex.ext.sql.SQLConnection>> handler) { 
    delegate.getConnection(new Handler<AsyncResult<io.vertx.ext.sql.SQLConnection>>() {
      public void handle(AsyncResult<io.vertx.ext.sql.SQLConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.sql.SQLConnection.newInstance((io.vertx.ext.sql.SQLConnection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Returns a connection that can be used to perform SQL operations on. It's important to remember
   * to close the connection when you are done, so it is returned to the pool.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient getConnection() {
    return 
getConnection(ar -> { });
  }

  /**
   * Returns a connection that can be used to perform SQL operations on. It's important to remember
   * to close the connection when you are done, so it is returned to the pool.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.sql.SQLConnection> rxGetConnection() { 
    return AsyncResultSingle.toSingle($handler -> {
      getConnection($handler);
    });
  }

  /**
   * Close the client and release all resources.
   * Call the handler when close is complete.
   * @param handler the handler that will be called when close is complete
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the client and release all resources.
   * Call the handler when close is complete.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close($handler);
    });
  }

  /**
   * Close the client
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Execute a single SQL statement, this method acquires a connection from the the pool and executes the SQL
   * statement and returns it back after the execution.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLClient query(String sql, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> handler) { 
    delegate.query(sql, handler);
    return this;
  }

  /**
   * Execute a single SQL statement, this method acquires a connection from the the pool and executes the SQL
   * statement and returns it back after the execution.
   * @param sql the statement to execute
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLClient query(String sql) {
    return 
query(sql, ar -> { });
  }

  /**
   * Execute a single SQL statement, this method acquires a connection from the the pool and executes the SQL
   * statement and returns it back after the execution.
   * @param sql the statement to execute
   * @return self
   */
  public io.reactivex.Single<io.vertx.ext.sql.ResultSet> rxQuery(String sql) { 
    return AsyncResultSingle.toSingle($handler -> {
      query(sql, $handler);
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient queryStream(String sql, Handler<AsyncResult<io.vertx.reactivex.ext.sql.SQLRowStream>> handler) { 
    delegate.queryStream(sql, new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>() {
      public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.sql.SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient queryStream(String sql) {
    return 
queryStream(sql, ar -> { });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.sql.SQLRowStream> rxQueryStream(String sql) { 
    return AsyncResultSingle.toSingle($handler -> {
      queryStream(sql, $handler);
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<io.vertx.reactivex.ext.sql.SQLRowStream>> handler) { 
    delegate.queryStreamWithParams(sql, params, new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>() {
      public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.sql.SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient queryStreamWithParams(String sql, JsonArray params) {
    return 
queryStreamWithParams(sql, params, ar -> { });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.sql.SQLRowStream> rxQueryStreamWithParams(String sql, JsonArray params) { 
    return AsyncResultSingle.toSingle($handler -> {
      queryStreamWithParams(sql, params, $handler);
    });
  }

  /**
   * Execute a single SQL prepared statement, this method acquires a connection from the the pool and executes the SQL
   * prepared statement and returns it back after the execution.
   * @param sql the statement to execute
   * @param arguments the arguments to the statement
   * @param handler the result handler
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLClient queryWithParams(String sql, JsonArray arguments, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> handler) { 
    delegate.queryWithParams(sql, arguments, handler);
    return this;
  }

  /**
   * Execute a single SQL prepared statement, this method acquires a connection from the the pool and executes the SQL
   * prepared statement and returns it back after the execution.
   * @param sql the statement to execute
   * @param arguments the arguments to the statement
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLClient queryWithParams(String sql, JsonArray arguments) {
    return 
queryWithParams(sql, arguments, ar -> { });
  }

  /**
   * Execute a single SQL prepared statement, this method acquires a connection from the the pool and executes the SQL
   * prepared statement and returns it back after the execution.
   * @param sql the statement to execute
   * @param arguments the arguments to the statement
   * @return self
   */
  public io.reactivex.Single<io.vertx.ext.sql.ResultSet> rxQueryWithParams(String sql, JsonArray arguments) { 
    return AsyncResultSingle.toSingle($handler -> {
      queryWithParams(sql, arguments, $handler);
    });
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param handler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient update(String sql, Handler<AsyncResult<io.vertx.ext.sql.UpdateResult>> handler) { 
    delegate.update(sql, handler);
    return this;
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient update(String sql) {
    return 
update(sql, ar -> { });
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.UpdateResult> rxUpdate(String sql) { 
    return AsyncResultSingle.toSingle($handler -> {
      update(sql, $handler);
    });
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @param handler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient updateWithParams(String sql, JsonArray params, Handler<AsyncResult<io.vertx.ext.sql.UpdateResult>> handler) { 
    delegate.updateWithParams(sql, params, handler);
    return this;
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient updateWithParams(String sql, JsonArray params) {
    return 
updateWithParams(sql, params, ar -> { });
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.UpdateResult> rxUpdateWithParams(String sql, JsonArray params) { 
    return AsyncResultSingle.toSingle($handler -> {
      updateWithParams(sql, params, $handler);
    });
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @param handler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient call(String sql, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> handler) { 
    delegate.call(sql, handler);
    return this;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient call(String sql) {
    return 
call(sql, ar -> { });
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.ResultSet> rxCall(String sql) { 
    return AsyncResultSingle.toSingle($handler -> {
      call(sql, $handler);
    });
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @param handler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> handler) { 
    delegate.callWithParams(sql, params, outputs, handler);
    return this;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLClient callWithParams(String sql, JsonArray params, JsonArray outputs) {
    return 
callWithParams(sql, params, outputs, ar -> { });
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.ResultSet> rxCallWithParams(String sql, JsonArray params, JsonArray outputs) { 
    return AsyncResultSingle.toSingle($handler -> {
      callWithParams(sql, params, outputs, $handler);
    });
  }

  public static SQLClient newInstance(io.vertx.ext.sql.SQLClient arg) {
    return arg != null ? new SQLClient(arg) : null;
  }

}
