/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.stomp;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a STOMP destination.
 * Depending on the implementation, the message delivery is different. Queue are sending message to only one
 * subscribers, while topics are broadcasting the message to all subscribers.
 * <p/>
 * Implementations <strong>must</strong> be thread-safe.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.Destination original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.stomp.Destination.class)
public class Destination {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Destination that = (Destination) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Destination> __TYPE_ARG = new TypeArg<>(    obj -> new Destination((io.vertx.ext.stomp.Destination) obj),
    Destination::getDelegate
  );

  private final io.vertx.ext.stomp.Destination delegate;
  
  public Destination(io.vertx.ext.stomp.Destination delegate) {
    this.delegate = delegate;
  }

  public Destination(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.Destination)delegate;
  }

  public io.vertx.ext.stomp.Destination getDelegate() {
    return delegate;
  }


  public static io.vertx.reactivex.ext.stomp.Destination topic(io.vertx.reactivex.core.Vertx vertx, String destination) { 
    io.vertx.reactivex.ext.stomp.Destination ret = io.vertx.reactivex.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)io.vertx.ext.stomp.Destination.topic(vertx.getDelegate(), destination));
    return ret;
  }

  public static io.vertx.reactivex.ext.stomp.Destination queue(io.vertx.reactivex.core.Vertx vertx, String destination) { 
    io.vertx.reactivex.ext.stomp.Destination ret = io.vertx.reactivex.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)io.vertx.ext.stomp.Destination.queue(vertx.getDelegate(), destination));
    return ret;
  }

  public static io.vertx.reactivex.ext.stomp.Destination bridge(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.stomp.BridgeOptions options) { 
    io.vertx.reactivex.ext.stomp.Destination ret = io.vertx.reactivex.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)io.vertx.ext.stomp.Destination.bridge(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @return the destination address.
   */
  public String destination() { 
    String ret = delegate.destination();
    return ret;
  }

  /**
   * Dispatches the given frame.
   * @param connection the connection
   * @param frame the frame
   * @return the current instance of {@link io.vertx.reactivex.ext.stomp.Destination}
   */
  public io.vertx.reactivex.ext.stomp.Destination dispatch(io.vertx.reactivex.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame frame) { 
    delegate.dispatch(connection.getDelegate(), frame);
    return this;
  }

  /**
   * Handles a subscription request to the current {@link io.vertx.reactivex.ext.stomp.Destination}.
   * @param connection the connection
   * @param frame the <code>SUBSCRIBE</code> frame
   * @return the current instance of {@link io.vertx.reactivex.ext.stomp.Destination}
   */
  public io.vertx.reactivex.ext.stomp.Destination subscribe(io.vertx.reactivex.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame frame) { 
    delegate.subscribe(connection.getDelegate(), frame);
    return this;
  }

  /**
   * Handles a un-subscription request to the current {@link io.vertx.reactivex.ext.stomp.Destination}.
   * @param connection the connection
   * @param frame the <code>UNSUBSCRIBE</code> frame
   * @return <code>true</code> if the un-subscription has been handled, <code>false</code> otherwise.
   */
  public boolean unsubscribe(io.vertx.reactivex.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame frame) { 
    boolean ret = delegate.unsubscribe(connection.getDelegate(), frame);
    return ret;
  }

  /**
   * Removes all subscriptions of the given connection
   * @param connection the connection
   * @return the current instance of {@link io.vertx.reactivex.ext.stomp.Destination}
   */
  public io.vertx.reactivex.ext.stomp.Destination unsubscribeConnection(io.vertx.reactivex.ext.stomp.StompServerConnection connection) { 
    delegate.unsubscribeConnection(connection.getDelegate());
    return this;
  }

  /**
   * Handles a <code>ACK</code> frame.
   * @param connection the connection
   * @param frame the <code>ACK</code> frame
   * @return <code>true</code> if the destination has handled the frame (meaning it has sent the message with id)
   */
  public boolean ack(io.vertx.reactivex.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame frame) { 
    boolean ret = delegate.ack(connection.getDelegate(), frame);
    return ret;
  }

  /**
   * Handles a <code>NACK</code> frame.
   * @param connection the connection
   * @param frame the <code>NACK</code> frame
   * @return <code>true</code> if the destination has handled the frame (meaning it has sent the message with id)
   */
  public boolean nack(io.vertx.reactivex.ext.stomp.StompServerConnection connection, io.vertx.ext.stomp.Frame frame) { 
    boolean ret = delegate.nack(connection.getDelegate(), frame);
    return ret;
  }

  /**
   * Gets all subscription ids for the given destination hold by the given client
   * @param connection the connection (client)
   * @return the list of subscription id, empty if none
   */
  public List<String> getSubscriptions(io.vertx.reactivex.ext.stomp.StompServerConnection connection) { 
    List<String> ret = delegate.getSubscriptions(connection.getDelegate());
    return ret;
  }

  /**
   * Gets the number of subscriptions attached to the current {@link io.vertx.reactivex.ext.stomp.Destination}.
   * @return the number of subscriptions.
   */
  public int numberOfSubscriptions() { 
    int ret = delegate.numberOfSubscriptions();
    return ret;
  }

  /**
   * Checks whether or not the given address matches with the current destination.
   * @param address the address
   * @return <code>true</code> if it matches, <code>false</code> otherwise.
   */
  public boolean matches(String address) { 
    boolean ret = delegate.matches(address);
    return ret;
  }

  public static Destination newInstance(io.vertx.ext.stomp.Destination arg) {
    return arg != null ? new Destination(arg) : null;
  }

}
