/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.stomp;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface implemented to customize the destination creation.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.DestinationFactory original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.stomp.DestinationFactory.class)
public class DestinationFactory {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DestinationFactory that = (DestinationFactory) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DestinationFactory> __TYPE_ARG = new TypeArg<>(    obj -> new DestinationFactory((io.vertx.ext.stomp.DestinationFactory) obj),
    DestinationFactory::getDelegate
  );

  private final io.vertx.ext.stomp.DestinationFactory delegate;
  
  public DestinationFactory(io.vertx.ext.stomp.DestinationFactory delegate) {
    this.delegate = delegate;
  }

  public DestinationFactory(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.DestinationFactory)delegate;
  }

  public io.vertx.ext.stomp.DestinationFactory getDelegate() {
    return delegate;
  }

  /**
   * Creates a destination for the given <em>address</em>.
   * @param vertx the vert.x instance used by the STOMP server.
   * @param name the destination name.
   * @return the destination, <code>null</code> to reject the creation.
   */
  public io.vertx.reactivex.ext.stomp.Destination create(io.vertx.reactivex.core.Vertx vertx, String name) { 
    io.vertx.reactivex.ext.stomp.Destination ret = io.vertx.reactivex.ext.stomp.Destination.newInstance((io.vertx.ext.stomp.Destination)delegate.create(vertx.getDelegate(), name));
    return ret;
  }

  public static DestinationFactory newInstance(io.vertx.ext.stomp.DestinationFactory arg) {
    return arg != null ? new DestinationFactory(arg) : null;
  }

}
