/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.api.validation;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This function is an inner wrapper for ParameterTypeValidator inside ValidationHandler parameter maps. <b>Don't
 * instantiate this class</b>, if you want to add custom ParameterTypeValidator to a parameter use functions in
 * {@link io.vertx.reactivex.ext.web.api.validation.HTTPRequestValidationHandler}
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.validation.ParameterValidationRule original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.api.validation.ParameterValidationRule.class)
public class ParameterValidationRule {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParameterValidationRule that = (ParameterValidationRule) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ParameterValidationRule> __TYPE_ARG = new TypeArg<>(    obj -> new ParameterValidationRule((io.vertx.ext.web.api.validation.ParameterValidationRule) obj),
    ParameterValidationRule::getDelegate
  );

  private final io.vertx.ext.web.api.validation.ParameterValidationRule delegate;
  
  public ParameterValidationRule(io.vertx.ext.web.api.validation.ParameterValidationRule delegate) {
    this.delegate = delegate;
  }

  public ParameterValidationRule(Object delegate) {
    this.delegate = (io.vertx.ext.web.api.validation.ParameterValidationRule)delegate;
  }

  public io.vertx.ext.web.api.validation.ParameterValidationRule getDelegate() {
    return delegate;
  }

  /**
   * This function return the name of the parameter expected into parameter lists
   * @return name of the parameter
   */
  @Deprecated()
  public String getName() { 
    String ret = delegate.getName();
    return ret;
  }

  /**
   * This function will be called when there is only a string as parameter. It will throw a ValidationError in an
   * error during validation occurs
   * @param value list of values that will be validated
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.RequestParameter validateSingleParam(String value) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.validateSingleParam(value));
    return ret;
  }

  /**
   * This function will be called when there is a List<String> that need to be validated. It must check if array is
   * expected or not. It will throw a ValidationError in an error during validation occurs
   * @param value list of values that will be validated
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.RequestParameter validateArrayParam(List<String> value) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.validateArrayParam(value));
    return ret;
  }

  /**
   * Return true if parameter is optional
   * @return true if is optional, false otherwise
   */
  @Deprecated()
  public boolean isOptional() { 
    boolean ret = delegate.isOptional();
    return ret;
  }

  /**
   * Return ParameterTypeValidator instance used inside this parameter validation rule
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator parameterTypeValidator() { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)delegate.parameterTypeValidator());
    return ret;
  }

  /**
   * allowEmptyValue is used in query, header, cookie and form parameters. This is its behaviour:
   * <ol>
   * <li>During validation, the ValidationHandler check if there's a parameter with combination of location and name
   * as defined in this rule </li>
   * <li>If it not exists, It will check allowEmptyValue and if there's a default value set inside
   * ParameterTypeValidator:</li>
   * <ul>
   * <li>If this condition it's true, It marks as validated the parameter and returns the default value (inside
   * RequestParameter)</li>
   * <li>If this condition it's false, It throws ValidationException</li>
   * </ul>
   * <li>If the parameter exists, It checks if parameter is null or empty string:</li>
   * <ul>
   * <li>If allowEmptyValue it's true, It marks as validated the parameter and returns the default value if it exists
   * (inside RequestParameter)</li>
   * <li>If allowEmptyValue it's false, It throws ValidationException</li>
   * </ul>
   * </ol>
   * @return value of allowEmptyValue
   */
  @Deprecated()
  public boolean allowEmptyValue() { 
    boolean ret = delegate.allowEmptyValue();
    return ret;
  }

  public static ParameterValidationRule newInstance(io.vertx.ext.web.api.validation.ParameterValidationRule arg) {
    return arg != null ? new ParameterValidationRule(arg) : null;
  }

}
