/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.common;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Utility API to verify which environment is the web application running.
 *
 * The utility will check initially for the existence of a system property under the name `vertx.mode`,
 * if there is no such property then it will look under the environment variables under the name `VERTX_MODE`.
 *
 * This value will be then used when the API is invoked. By itself this utility will not
 * affect the behavior of your application, however you can use it to simplify your handlers, e.g.:
 *
 * When the development mode is active you can log more information or disable caches.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.common.WebEnvironment original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.common.WebEnvironment.class)
public class WebEnvironment {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebEnvironment that = (WebEnvironment) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WebEnvironment> __TYPE_ARG = new TypeArg<>(    obj -> new WebEnvironment((io.vertx.ext.web.common.WebEnvironment) obj),
    WebEnvironment::getDelegate
  );

  private final io.vertx.ext.web.common.WebEnvironment delegate;
  
  public WebEnvironment(io.vertx.ext.web.common.WebEnvironment delegate) {
    this.delegate = delegate;
  }

  public WebEnvironment(Object delegate) {
    this.delegate = (io.vertx.ext.web.common.WebEnvironment)delegate;
  }

  public io.vertx.ext.web.common.WebEnvironment getDelegate() {
    return delegate;
  }

  /**
   * Will return true if the mode is not null and equals ignoring case the string "dev"
   * @return always boolean
   */
  public static boolean development() { 
    boolean ret = io.vertx.ext.web.common.WebEnvironment.development();
    return ret;
  }

  /**
   * The current mode from the system properties with fallback to environment variables
   * @return String with mode value or null
   */
  public static String mode() { 
    String ret = io.vertx.ext.web.common.WebEnvironment.mode();
    return ret;
  }

  public static final String SYSTEM_PROPERTY_NAME = io.vertx.ext.web.common.WebEnvironment.SYSTEM_PROPERTY_NAME;
  public static final String ENV_VARIABLE_NAME = io.vertx.ext.web.common.WebEnvironment.ENV_VARIABLE_NAME;
  public static WebEnvironment newInstance(io.vertx.ext.web.common.WebEnvironment arg) {
    return arg != null ? new WebEnvironment(arg) : null;
  }

}
