/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Base interface for auth handlers.
 * <p>
 * An auth handler allows your application to provide authentication/authorization support.
 * <p>
 * Auth handler requires a {@link io.vertx.reactivex.ext.web.handler.SessionHandler} to be on the routing chain before it.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.AuthHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.AuthHandler.class)
public interface AuthHandler extends io.vertx.reactivex.ext.web.handler.AuthenticationHandler, Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  io.vertx.ext.web.handler.AuthHandler getDelegate();

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  @Deprecated()
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event);

  /**
   * Returns
   * @param context 
   * @return 
   */
  @Deprecated()
  public String authenticateHeader(io.vertx.reactivex.ext.web.RoutingContext context);

  /**
   * This method is called to perform any post authentication tasks, such as redirects.
   * Overrides must call context.next() on success.
   * @param ctx the routing context
   */
  @Deprecated()
  public void postAuthentication(io.vertx.reactivex.ext.web.RoutingContext ctx);

  /**
   * Add a required authority for this auth handler
   * @param authority the authority
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.handler.AuthHandler addAuthority(String authority);

  /**
   * Add a set of required authorities for this auth handler
   * @param authorities the set of authorities
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.handler.AuthHandler addAuthorities(Set<String> authorities);

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @param handler the handler for the result.
   */
  @Deprecated()
  public void authorize(io.vertx.reactivex.ext.auth.User user, Handler<AsyncResult<Void>> handler);

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   */
  @Deprecated()
  public void authorize(io.vertx.reactivex.ext.auth.User user);

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @return 
   */
  @Deprecated()
  public io.reactivex.Completable rxAuthorize(io.vertx.reactivex.ext.auth.User user);

  public static AuthHandler newInstance(io.vertx.ext.web.handler.AuthHandler arg) {
    return arg != null ? new AuthHandlerImpl(arg) : null;
  }

}

class AuthHandlerImpl implements AuthHandler {
  private final io.vertx.ext.web.handler.AuthHandler delegate;
  
  public AuthHandlerImpl(io.vertx.ext.web.handler.AuthHandler delegate) {
    this.delegate = delegate;
  }

  public AuthHandlerImpl(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.AuthHandler)delegate;
  }

  public io.vertx.ext.web.handler.AuthHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  @Deprecated()
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Returns
   * @param context 
   * @return 
   */
  @Deprecated()
  public String authenticateHeader(io.vertx.reactivex.ext.web.RoutingContext context) { 
    String ret = delegate.authenticateHeader(context.getDelegate());
    return ret;
  }

  /**
   * This method is called to perform any post authentication tasks, such as redirects.
   * Overrides must call context.next() on success.
   * @param ctx the routing context
   */
  @Deprecated()
  public void postAuthentication(io.vertx.reactivex.ext.web.RoutingContext ctx) { 
    delegate.postAuthentication(ctx.getDelegate());
  }

  /**
   * Add a required authority for this auth handler
   * @param authority the authority
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.handler.AuthHandler addAuthority(String authority) { 
    delegate.addAuthority(authority);
    return this;
  }

  /**
   * Add a set of required authorities for this auth handler
   * @param authorities the set of authorities
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.handler.AuthHandler addAuthorities(Set<String> authorities) { 
    delegate.addAuthorities(authorities);
    return this;
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @param handler the handler for the result.
   */
  @Deprecated()
  public void authorize(io.vertx.reactivex.ext.auth.User user, Handler<AsyncResult<Void>> handler) { 
    delegate.authorize(user.getDelegate(), handler);
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   */
  @Deprecated()
  public void authorize(io.vertx.reactivex.ext.auth.User user) {
    authorize(user, ar -> { });
  }

  /**
   * Authorizes the given user against all added authorities.
   * @param user a user.
   * @return 
   */
  @Deprecated()
  public io.reactivex.Completable rxAuthorize(io.vertx.reactivex.ext.auth.User user) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      authorize(user, $handler);
    });
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @param handler the handler to be called once the information is available.
   */
  @Deprecated()
  public void parseCredentials(io.vertx.reactivex.ext.web.RoutingContext context, Handler<AsyncResult<io.vertx.ext.auth.authentication.Credentials>> handler) { 
    delegate.parseCredentials(context.getDelegate(), handler);
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   */
  @Deprecated()
  public void parseCredentials(io.vertx.reactivex.ext.web.RoutingContext context) {
    parseCredentials(context, ar -> { });
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @return 
   */
  @Deprecated()
  public io.reactivex.Single<io.vertx.ext.auth.authentication.Credentials> rxParseCredentials(io.vertx.reactivex.ext.web.RoutingContext context) { 
    return AsyncResultSingle.toSingle($handler -> {
      parseCredentials(context, $handler);
    });
  }

}
