/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This handler adds a CSRF token to requests which mutate state. In order change the state a (XSRF-TOKEN) cookie is set
 * with a unique token, that is expected to be sent back in a (X-XSRF-TOKEN) header.
 *
 * The behavior is to check the request body header and cookie for validity.
 *
 * This Handler requires session support, thus should be added somewhere below Session and Body handlers.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.CSRFHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.CSRFHandler.class)
public class CSRFHandler implements Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CSRFHandler that = (CSRFHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CSRFHandler> __TYPE_ARG = new TypeArg<>(    obj -> new CSRFHandler((io.vertx.ext.web.handler.CSRFHandler) obj),
    CSRFHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.CSRFHandler delegate;
  
  public CSRFHandler(io.vertx.ext.web.handler.CSRFHandler delegate) {
    this.delegate = delegate;
  }

  public CSRFHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.CSRFHandler)delegate;
  }

  public io.vertx.ext.web.handler.CSRFHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Instantiate a new CSRFHandlerImpl with a secret
   * <p>
   * <pre>
   * CSRFHandler.create("s3cr37")
   * </pre>
   * @param vertx 
   * @param secret server secret to sign the token.
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.CSRFHandler create(io.vertx.reactivex.core.Vertx vertx, String secret) { 
    io.vertx.reactivex.ext.web.handler.CSRFHandler ret = io.vertx.reactivex.ext.web.handler.CSRFHandler.newInstance((io.vertx.ext.web.handler.CSRFHandler)io.vertx.ext.web.handler.CSRFHandler.create(vertx.getDelegate(), secret));
    return ret;
  }

  /**
   * Set the origin for this server. When this value is set, extra validation will occur. The request
   * must match the origin server, port and protocol.
   * @param origin the origin for this server e.g.: <code>https://www.foo.com</code>.
   * @return fluent
   */
  public io.vertx.reactivex.ext.web.handler.CSRFHandler setOrigin(String origin) { 
    delegate.setOrigin(origin);
    return this;
  }

  /**
   * Set the cookie name. By default XSRF-TOKEN is used as it is the expected name by AngularJS however other frameworks
   * might use other names.
   * @param name a new name for the cookie.
   * @return fluent
   */
  public io.vertx.reactivex.ext.web.handler.CSRFHandler setCookieName(String name) { 
    delegate.setCookieName(name);
    return this;
  }

  /**
   * Set the cookie path. By default / is used.
   * @param path a new path for the cookie.
   * @return fluent
   */
  public io.vertx.reactivex.ext.web.handler.CSRFHandler setCookiePath(String path) { 
    delegate.setCookiePath(path);
    return this;
  }

  /**
   * Set the cookie <code>httpOnly</code> attribute. When setting to <code>false</code> the CSRF handler will behave in
   * Double Submit Cookie mode. When set to <code>true</code> then it will operate in Cookie-to-header mode.
   *
   * For more information <a href="https://cheatsheetseries.owasp.org/cheatsheets/Cross-Site_Request_Forgery_Prevention_Cheat_Sheet.html#double-submit-cookie">https://cheatsheetseries.owasp.org/cheatsheets/Cross-Site_Request_Forgery_Prevention_Cheat_Sheet.html#double-submit-cookie</a>
   * @param httpOnly a new name for the header.
   * @return fluent
   */
  public io.vertx.reactivex.ext.web.handler.CSRFHandler setCookieHttpOnly(boolean httpOnly) { 
    delegate.setCookieHttpOnly(httpOnly);
    return this;
  }

  /**
   * Set the header name. By default X-XSRF-TOKEN is used as it is the expected name by AngularJS however other
   * frameworks might use other names.
   * @param name a new name for the header.
   * @return fluent
   */
  public io.vertx.reactivex.ext.web.handler.CSRFHandler setHeaderName(String name) { 
    delegate.setHeaderName(name);
    return this;
  }

  /**
   * Should the handler give warning messages if this handler is used in other than https protocols?
   * @param nag true to nag
   * @return fluent
   */
  public io.vertx.reactivex.ext.web.handler.CSRFHandler setNagHttps(boolean nag) { 
    delegate.setNagHttps(nag);
    return this;
  }

  /**
   * Set the timeout for tokens generated by the handler, by default it uses the default from the session handler.
   * @param timeout token timeout
   * @return fluent
   */
  public io.vertx.reactivex.ext.web.handler.CSRFHandler setTimeout(long timeout) { 
    delegate.setTimeout(timeout);
    return this;
  }

  public static final String DEFAULT_COOKIE_NAME = io.vertx.ext.web.handler.CSRFHandler.DEFAULT_COOKIE_NAME;
  public static final String DEFAULT_COOKIE_PATH = io.vertx.ext.web.handler.CSRFHandler.DEFAULT_COOKIE_PATH;
  public static final String DEFAULT_HEADER_NAME = io.vertx.ext.web.handler.CSRFHandler.DEFAULT_HEADER_NAME;
  public static CSRFHandler newInstance(io.vertx.ext.web.handler.CSRFHandler arg) {
    return arg != null ? new CSRFHandler(arg) : null;
  }

}
