/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A pretty error handler for rendering error pages. When working in development mode
 * exception details will be returned in the server responses, otherwise or when
 * manually specified no exception details are returned in the HTTP response.
 *
 * The reason the display of the exception details is by default dependent of the mode
 * is to follow the security best practices:
 * <a href="https://www.owasp.org/index.php/Improper_Error_Handling">https://www.owasp.org/index.php/Improper_Error_Handling</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.ErrorHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.ErrorHandler.class)
public class ErrorHandler implements Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ErrorHandler that = (ErrorHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ErrorHandler> __TYPE_ARG = new TypeArg<>(    obj -> new ErrorHandler((io.vertx.ext.web.handler.ErrorHandler) obj),
    ErrorHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.ErrorHandler delegate;
  
  public ErrorHandler(io.vertx.ext.web.handler.ErrorHandler delegate) {
    this.delegate = delegate;
  }

  public ErrorHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.ErrorHandler)delegate;
  }

  public io.vertx.ext.web.handler.ErrorHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create an error handler using defaults
   * @param vertx 
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.ErrorHandler create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.handler.ErrorHandler ret = io.vertx.reactivex.ext.web.handler.ErrorHandler.newInstance((io.vertx.ext.web.handler.ErrorHandler)io.vertx.ext.web.handler.ErrorHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create an error handler
   * @param vertx 
   * @param errorTemplateName the error template name - will be looked up from the classpath
   * @param displayExceptionDetails true if exception details should be displayed
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.ErrorHandler create(io.vertx.reactivex.core.Vertx vertx, String errorTemplateName, boolean displayExceptionDetails) { 
    io.vertx.reactivex.ext.web.handler.ErrorHandler ret = io.vertx.reactivex.ext.web.handler.ErrorHandler.newInstance((io.vertx.ext.web.handler.ErrorHandler)io.vertx.ext.web.handler.ErrorHandler.create(vertx.getDelegate(), errorTemplateName, displayExceptionDetails));
    return ret;
  }

  /**
   * Create an error handler
   * @param vertx 
   * @param displayExceptionDetails true if exception details should be displayed
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.ErrorHandler create(io.vertx.reactivex.core.Vertx vertx, boolean displayExceptionDetails) { 
    io.vertx.reactivex.ext.web.handler.ErrorHandler ret = io.vertx.reactivex.ext.web.handler.ErrorHandler.newInstance((io.vertx.ext.web.handler.ErrorHandler)io.vertx.ext.web.handler.ErrorHandler.create(vertx.getDelegate(), displayExceptionDetails));
    return ret;
  }

  /**
   * Create an error handler
   * @param vertx 
   * @param errorTemplateName the error template name - will be looked up from the classpath
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.ErrorHandler create(io.vertx.reactivex.core.Vertx vertx, String errorTemplateName) { 
    io.vertx.reactivex.ext.web.handler.ErrorHandler ret = io.vertx.reactivex.ext.web.handler.ErrorHandler.newInstance((io.vertx.ext.web.handler.ErrorHandler)io.vertx.ext.web.handler.ErrorHandler.create(vertx.getDelegate(), errorTemplateName));
    return ret;
  }

  /**
   * The default template to use for rendering
   */
  public static final String DEFAULT_ERROR_HANDLER_TEMPLATE = io.vertx.ext.web.handler.ErrorHandler.DEFAULT_ERROR_HANDLER_TEMPLATE;
  public static ErrorHandler newInstance(io.vertx.ext.web.handler.ErrorHandler arg) {
    return arg != null ? new ErrorHandler(arg) : null;
  }

}
