/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler which selectively executes another handler if a precondition is met.
 *
 * There are cases where applications are build as multi tenant, in this cases one of the
 * common tasks is to configure different authentication mechanisms for each tenant.
 *
 * This handler will allow registering any other handler and will only execute it if
 * the precondition is met. There are 2 way of defining a precondition:
 *
 * <ul>
 *     <li>A http header value for example <pre>X-Tenant</pre></li>
 *     <li>A custom extractor function that can return a String from the context</li>
 * </ul>
 *
 * Requests that pass the validation will contain a new key in the routing context with
 * the tenant id, for the case of being a default handler the value if this key will be "default".
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.MultiTenantHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.MultiTenantHandler.class)
public class MultiTenantHandler implements Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MultiTenantHandler that = (MultiTenantHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MultiTenantHandler> __TYPE_ARG = new TypeArg<>(    obj -> new MultiTenantHandler((io.vertx.ext.web.handler.MultiTenantHandler) obj),
    MultiTenantHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.MultiTenantHandler delegate;
  
  public MultiTenantHandler(io.vertx.ext.web.handler.MultiTenantHandler delegate) {
    this.delegate = delegate;
  }

  public MultiTenantHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.MultiTenantHandler)delegate;
  }

  public io.vertx.ext.web.handler.MultiTenantHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a MultiTenant handler that will extract the tenant id from a given header name.
   * @param header the header to lookup (e.g.: "X-Tenant")
   * @return the new handler.
   */
  public static io.vertx.reactivex.ext.web.handler.MultiTenantHandler create(String header) { 
    io.vertx.reactivex.ext.web.handler.MultiTenantHandler ret = io.vertx.reactivex.ext.web.handler.MultiTenantHandler.newInstance((io.vertx.ext.web.handler.MultiTenantHandler)io.vertx.ext.web.handler.MultiTenantHandler.create(header));
    return ret;
  }

  /**
   * Create a MultiTenant handler using a custom tenant extraction function.
   * @param tenantExtractor the function that extracts the tenant id from the request
   * @return the new handler.
   */
  public static io.vertx.reactivex.ext.web.handler.MultiTenantHandler create(Function<io.vertx.reactivex.ext.web.RoutingContext, String> tenantExtractor) { 
    io.vertx.reactivex.ext.web.handler.MultiTenantHandler ret = io.vertx.reactivex.ext.web.handler.MultiTenantHandler.newInstance((io.vertx.ext.web.handler.MultiTenantHandler)io.vertx.ext.web.handler.MultiTenantHandler.create(new Function<io.vertx.ext.web.RoutingContext,String>() {
      public String apply(io.vertx.ext.web.RoutingContext arg) {
        String ret = tenantExtractor.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret;
      }
    }));
    return ret;
  }

  /**
   * Create a MultiTenant handler using a custom tenant extraction function.
   * @param tenantExtractor the function that extracts the tenant id from the request
   * @param contextKey the custom key to store the tenant id in the context
   * @return the new handler.
   */
  public static io.vertx.reactivex.ext.web.handler.MultiTenantHandler create(Function<io.vertx.reactivex.ext.web.RoutingContext, String> tenantExtractor, String contextKey) { 
    io.vertx.reactivex.ext.web.handler.MultiTenantHandler ret = io.vertx.reactivex.ext.web.handler.MultiTenantHandler.newInstance((io.vertx.ext.web.handler.MultiTenantHandler)io.vertx.ext.web.handler.MultiTenantHandler.create(new Function<io.vertx.ext.web.RoutingContext,String>() {
      public String apply(io.vertx.ext.web.RoutingContext arg) {
        String ret = tenantExtractor.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret;
      }
    }, contextKey));
    return ret;
  }

  /**
   * Add a handler for a given tenant to this handler.
   *
   * Both tenant and handler cannot be null.
   * @param tenant the tenant id
   * @param handler the handler to register.
   * @return a fluent reference to self.
   */
  public io.vertx.reactivex.ext.web.handler.MultiTenantHandler addTenantHandler(String tenant, Handler<io.vertx.reactivex.ext.web.RoutingContext> handler) { 
    delegate.addTenantHandler(tenant, new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        handler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * Remove a handler for a given tenant from this handler.
   *
   * Tenant cannot be null.
   * @param tenant the tenant id
   * @return a fluent reference to self.
   */
  public io.vertx.reactivex.ext.web.handler.MultiTenantHandler removeTenant(String tenant) { 
    delegate.removeTenant(tenant);
    return this;
  }

  /**
   * Add a default handler for the case when no tenant was matched.
   *
   * The handler cannot be null.
   * @param handler the handler to register.
   * @return a fluent reference to self.
   */
  public io.vertx.reactivex.ext.web.handler.MultiTenantHandler addDefaultHandler(Handler<io.vertx.reactivex.ext.web.RoutingContext> handler) { 
    delegate.addDefaultHandler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        handler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * The default key used to identify a tenant in the context data.
   */
  public static final String TENANT = io.vertx.ext.web.handler.MultiTenantHandler.TENANT;
  public static MultiTenantHandler newInstance(io.vertx.ext.web.handler.MultiTenantHandler arg) {
    return arg != null ? new MultiTenantHandler(arg) : null;
  }

}
