/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An auth handler that's used to handle auth by redirecting user to a custom login page.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.RedirectAuthHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.RedirectAuthHandler.class)
public class RedirectAuthHandler implements io.vertx.reactivex.ext.web.handler.AuthenticationHandler, Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedirectAuthHandler that = (RedirectAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedirectAuthHandler> __TYPE_ARG = new TypeArg<>(    obj -> new RedirectAuthHandler((io.vertx.ext.web.handler.RedirectAuthHandler) obj),
    RedirectAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.RedirectAuthHandler delegate;
  
  public RedirectAuthHandler(io.vertx.ext.web.handler.RedirectAuthHandler delegate) {
    this.delegate = delegate;
  }

  public RedirectAuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.RedirectAuthHandler)delegate;
  }

  public io.vertx.ext.web.handler.RedirectAuthHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Returns
   * @param context 
   * @return 
   */
  public String authenticateHeader(io.vertx.reactivex.ext.web.RoutingContext context) { 
    String ret = delegate.authenticateHeader(context.getDelegate());
    return ret;
  }

  /**
   * This method is called to perform any post authentication tasks, such as redirects.
   * Overrides must call context.next() on success.
   * @param ctx the routing context
   */
  public void postAuthentication(io.vertx.reactivex.ext.web.RoutingContext ctx) { 
    delegate.postAuthentication(ctx.getDelegate());
  }

  /**
   * Create a handler
   * @param authProvider the auth service to use
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.RedirectAuthHandler create(io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider authProvider) { 
    io.vertx.reactivex.ext.web.handler.RedirectAuthHandler ret = io.vertx.reactivex.ext.web.handler.RedirectAuthHandler.newInstance((io.vertx.ext.web.handler.RedirectAuthHandler)io.vertx.ext.web.handler.RedirectAuthHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * Create a handler
   * @param authProvider the auth service to use
   * @param loginRedirectURL the url to redirect the user to
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.RedirectAuthHandler create(io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider authProvider, String loginRedirectURL) { 
    io.vertx.reactivex.ext.web.handler.RedirectAuthHandler ret = io.vertx.reactivex.ext.web.handler.RedirectAuthHandler.newInstance((io.vertx.ext.web.handler.RedirectAuthHandler)io.vertx.ext.web.handler.RedirectAuthHandler.create(authProvider.getDelegate(), loginRedirectURL));
    return ret;
  }

  /**
   * Create a handler
   * @param authProvider the auth service to use
   * @param loginRedirectURL the url to redirect the user to
   * @param returnURLParam the name of param used to store return url information in session
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.RedirectAuthHandler create(io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider authProvider, String loginRedirectURL, String returnURLParam) { 
    io.vertx.reactivex.ext.web.handler.RedirectAuthHandler ret = io.vertx.reactivex.ext.web.handler.RedirectAuthHandler.newInstance((io.vertx.ext.web.handler.RedirectAuthHandler)io.vertx.ext.web.handler.RedirectAuthHandler.create(authProvider.getDelegate(), loginRedirectURL, returnURLParam));
    return ret;
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @param handler the handler to be called once the information is available.
   */
  public void parseCredentials(io.vertx.reactivex.ext.web.RoutingContext context, Handler<AsyncResult<io.vertx.ext.auth.authentication.Credentials>> handler) { 
    delegate.parseCredentials(context.getDelegate(), handler);
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   */
  public void parseCredentials(io.vertx.reactivex.ext.web.RoutingContext context) {
    parseCredentials(context, ar -> { });
  }

  /**
   * Parses the credentials from the request into a JsonObject. The implementation should
   * be able to extract the required info for the auth provider in the format the provider
   * expects.
   * @param context the routing context
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.auth.authentication.Credentials> rxParseCredentials(io.vertx.reactivex.ext.web.RoutingContext context) { 
    return AsyncResultSingle.toSingle($handler -> {
      parseCredentials(context, $handler);
    });
  }

  /**
   * Default path the user will be redirected to
   */
  public static final String DEFAULT_LOGIN_REDIRECT_URL = io.vertx.ext.web.handler.RedirectAuthHandler.DEFAULT_LOGIN_REDIRECT_URL;
  /**
   * Default name of param used to store return url information in session
   */
  public static final String DEFAULT_RETURN_URL_PARAM = io.vertx.ext.web.handler.RedirectAuthHandler.DEFAULT_RETURN_URL_PARAM;
  public static RedirectAuthHandler newInstance(io.vertx.ext.web.handler.RedirectAuthHandler arg) {
    return arg != null ? new RedirectAuthHandler(arg) : null;
  }

}
