/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler which sets the response content type automatically according to the best <code>Accept</code> header match.
 *
 * The header is set only if:
 * <ul>
 * <li>no object is stored in the routing context under the name {@link io.vertx.reactivex.ext.web.handler.ResponseContentTypeHandler}</li>
 * <li>a match is found</li>
 * <li>the header is not present already</li>
 * <li>content length header is absent or set to something different than zero</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.ResponseContentTypeHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.ResponseContentTypeHandler.class)
public class ResponseContentTypeHandler implements Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResponseContentTypeHandler that = (ResponseContentTypeHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ResponseContentTypeHandler> __TYPE_ARG = new TypeArg<>(    obj -> new ResponseContentTypeHandler((io.vertx.ext.web.handler.ResponseContentTypeHandler) obj),
    ResponseContentTypeHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.ResponseContentTypeHandler delegate;
  
  public ResponseContentTypeHandler(io.vertx.ext.web.handler.ResponseContentTypeHandler delegate) {
    this.delegate = delegate;
  }

  public ResponseContentTypeHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.ResponseContentTypeHandler)delegate;
  }

  public io.vertx.ext.web.handler.ResponseContentTypeHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a response content type handler.
   * @return the response content type handler
   */
  public static io.vertx.reactivex.ext.web.handler.ResponseContentTypeHandler create() { 
    io.vertx.reactivex.ext.web.handler.ResponseContentTypeHandler ret = io.vertx.reactivex.ext.web.handler.ResponseContentTypeHandler.newInstance((io.vertx.ext.web.handler.ResponseContentTypeHandler)io.vertx.ext.web.handler.ResponseContentTypeHandler.create());
    return ret;
  }

  /**
   * Create a response content type handler with a custom disable flag.
   * @param disableFlag 
   * @return the response content type handler
   */
  public static io.vertx.reactivex.ext.web.handler.ResponseContentTypeHandler create(String disableFlag) { 
    io.vertx.reactivex.ext.web.handler.ResponseContentTypeHandler ret = io.vertx.reactivex.ext.web.handler.ResponseContentTypeHandler.newInstance((io.vertx.ext.web.handler.ResponseContentTypeHandler)io.vertx.ext.web.handler.ResponseContentTypeHandler.create(disableFlag));
    return ret;
  }

  public static final String DEFAULT_DISABLE_FLAG = io.vertx.ext.web.handler.ResponseContentTypeHandler.DEFAULT_DISABLE_FLAG;
  public static ResponseContentTypeHandler newInstance(io.vertx.ext.web.handler.ResponseContentTypeHandler arg) {
    return arg != null ? new ResponseContentTypeHandler(arg) : null;
  }

}
