/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler for serving static resources from the file system or classpath.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.StaticHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.StaticHandler.class)
public class StaticHandler implements Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StaticHandler that = (StaticHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<StaticHandler> __TYPE_ARG = new TypeArg<>(    obj -> new StaticHandler((io.vertx.ext.web.handler.StaticHandler) obj),
    StaticHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.StaticHandler delegate;
  
  public StaticHandler(io.vertx.ext.web.handler.StaticHandler delegate) {
    this.delegate = delegate;
  }

  public StaticHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.StaticHandler)delegate;
  }

  public io.vertx.ext.web.handler.StaticHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a handler using defaults
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.StaticHandler create() { 
    io.vertx.reactivex.ext.web.handler.StaticHandler ret = io.vertx.reactivex.ext.web.handler.StaticHandler.newInstance((io.vertx.ext.web.handler.StaticHandler)io.vertx.ext.web.handler.StaticHandler.create());
    return ret;
  }

  /**
   * Create a handler, specifying web-root
   * @param root the web-root
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.StaticHandler create(String root) { 
    io.vertx.reactivex.ext.web.handler.StaticHandler ret = io.vertx.reactivex.ext.web.handler.StaticHandler.newInstance((io.vertx.ext.web.handler.StaticHandler)io.vertx.ext.web.handler.StaticHandler.create(root));
    return ret;
  }

  /**
   * Enable/Disable access to the root of the filesystem
   * @param allowRootFileSystemAccess whether root access is allowed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setAllowRootFileSystemAccess(boolean allowRootFileSystemAccess) { 
    delegate.setAllowRootFileSystemAccess(allowRootFileSystemAccess);
    return this;
  }

  /**
   * Set the web root
   * @param webRoot the web root
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setWebRoot(String webRoot) { 
    delegate.setWebRoot(webRoot);
    return this;
  }

  /**
   * Set whether files are read-only and will never change
   * @param readOnly whether files are read-only
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setFilesReadOnly(boolean readOnly) { 
    delegate.setFilesReadOnly(readOnly);
    return this;
  }

  /**
   * Set value for max age in caching headers
   * @param maxAgeSeconds maximum time for browser to cache, in seconds
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setMaxAgeSeconds(long maxAgeSeconds) { 
    delegate.setMaxAgeSeconds(maxAgeSeconds);
    return this;
  }

  /**
   * Set whether cache header handling is enabled
   * @param enabled true if enabled
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setCachingEnabled(boolean enabled) { 
    delegate.setCachingEnabled(enabled);
    return this;
  }

  /**
   * Set whether directory listing is enabled
   * @param directoryListing true if enabled
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setDirectoryListing(boolean directoryListing) { 
    delegate.setDirectoryListing(directoryListing);
    return this;
  }

  /**
   * Set whether hidden files should be served
   * @param includeHidden true if hidden files should be served
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setIncludeHidden(boolean includeHidden) { 
    delegate.setIncludeHidden(includeHidden);
    return this;
  }

  /**
   * Set the server cache entry timeout when caching is enabled
   * @param timeout the timeout, in ms
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setCacheEntryTimeout(long timeout) { 
    delegate.setCacheEntryTimeout(timeout);
    return this;
  }

  /**
   * Set the index page
   * @param indexPage the index page
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setIndexPage(String indexPage) { 
    delegate.setIndexPage(indexPage);
    return this;
  }

  /**
   * Set the max cache size, when caching is enabled
   * @param maxCacheSize the max cache size
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setMaxCacheSize(int maxCacheSize) { 
    delegate.setMaxCacheSize(maxCacheSize);
    return this;
  }

  /**
   * Set the file mapping for http2push and link preload
   * @param http2PushMappings the mapping for http2 push
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setHttp2PushMapping(List<io.vertx.ext.web.Http2PushMapping> http2PushMappings) { 
    delegate.setHttp2PushMapping(http2PushMappings);
    return this;
  }

  /**
   * Skip compression if the media type of the file to send is in the provided <code>mediaTypes</code> set.
   * <code>Content-Encoding</code> header set to <code>identity</code> for the types present in the <code>mediaTypes</code> set
   * @param mediaTypes the set of mime types that are already compressed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler skipCompressionForMediaTypes(Set<String> mediaTypes) { 
    delegate.skipCompressionForMediaTypes(mediaTypes);
    return this;
  }

  /**
   * Skip compression if the suffix of the file to send is in the provided <code>fileSuffixes</code> set.
   * <code>Content-Encoding</code> header set to <code>identity</code> for the suffixes present in the <code>fileSuffixes</code> set
   * @param fileSuffixes the set of file suffixes that are already compressed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler skipCompressionForSuffixes(Set<String> fileSuffixes) { 
    delegate.skipCompressionForSuffixes(fileSuffixes);
    return this;
  }

  /**
   * Set whether async filesystem access should always be used
   * @param alwaysAsyncFS true for always async FS access
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setAlwaysAsyncFS(boolean alwaysAsyncFS) { 
    delegate.setAlwaysAsyncFS(alwaysAsyncFS);
    return this;
  }

  /**
   * Set whether async/sync filesystem tuning should enabled
   * @param enableFSTuning true to enabled FS tuning
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setEnableFSTuning(boolean enableFSTuning) { 
    delegate.setEnableFSTuning(enableFSTuning);
    return this;
  }

  /**
   * Set the max serve time in ns, above which serves are considered slow
   * @param maxAvgServeTimeNanoSeconds max serve time, in ns
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setMaxAvgServeTimeNs(long maxAvgServeTimeNanoSeconds) { 
    delegate.setMaxAvgServeTimeNs(maxAvgServeTimeNanoSeconds);
    return this;
  }

  /**
   * Set the directory template to be used when directory listing
   * @param directoryTemplate the directory template
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setDirectoryTemplate(String directoryTemplate) { 
    delegate.setDirectoryTemplate(directoryTemplate);
    return this;
  }

  /**
   * Set whether range requests (resumable downloads; media streaming) should be enabled.
   * @param enableRangeSupport true to enable range support
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setEnableRangeSupport(boolean enableRangeSupport) { 
    delegate.setEnableRangeSupport(enableRangeSupport);
    return this;
  }

  /**
   * Set whether vary header should be sent with response.
   * @param varyHeader true to sent vary header
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setSendVaryHeader(boolean varyHeader) { 
    delegate.setSendVaryHeader(varyHeader);
    return this;
  }

  /**
   * Set the default content encoding for text related files. This allows overriding the system settings default value.
   * @param contentEncoding the desired content encoding e.g.: "UTF-8"
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.StaticHandler setDefaultContentEncoding(String contentEncoding) { 
    delegate.setDefaultContentEncoding(contentEncoding);
    return this;
  }

  /**
   * Default value of the web-root, where files are served from
   */
  public static final String DEFAULT_WEB_ROOT = io.vertx.ext.web.handler.StaticHandler.DEFAULT_WEB_ROOT;
  /**
   * Default value of whether files are read -only and never will be updated
   */
  public static final boolean DEFAULT_FILES_READ_ONLY = io.vertx.ext.web.handler.StaticHandler.DEFAULT_FILES_READ_ONLY;
  /**
   * Default max age for cache headers
   */
  public static final long DEFAULT_MAX_AGE_SECONDS = io.vertx.ext.web.handler.StaticHandler.DEFAULT_MAX_AGE_SECONDS;
  /**
   * Default of whether cache header handling is enabled
   */
  public static final boolean DEFAULT_CACHING_ENABLED = io.vertx.ext.web.handler.StaticHandler.DEFAULT_CACHING_ENABLED;
  /**
   * Default of whether directory listing is enabled
   */
  public static final boolean DEFAULT_DIRECTORY_LISTING = io.vertx.ext.web.handler.StaticHandler.DEFAULT_DIRECTORY_LISTING;
  /**
   * Default template file to use for directory listing
   */
  public static final String DEFAULT_DIRECTORY_TEMPLATE = io.vertx.ext.web.handler.StaticHandler.DEFAULT_DIRECTORY_TEMPLATE;
  /**
   * Default of whether hidden files can be served
   */
  public static final boolean DEFAULT_INCLUDE_HIDDEN = io.vertx.ext.web.handler.StaticHandler.DEFAULT_INCLUDE_HIDDEN;
  /**
   * Default cache entry timeout, when caching
   */
  public static final long DEFAULT_CACHE_ENTRY_TIMEOUT = io.vertx.ext.web.handler.StaticHandler.DEFAULT_CACHE_ENTRY_TIMEOUT;
  /**
   * The default index page
   */
  public static final String DEFAULT_INDEX_PAGE = io.vertx.ext.web.handler.StaticHandler.DEFAULT_INDEX_PAGE;
  /**
   * The default max cache size
   */
  public static final int DEFAULT_MAX_CACHE_SIZE = io.vertx.ext.web.handler.StaticHandler.DEFAULT_MAX_CACHE_SIZE;
  /**
   * Default of whether async filesystem access should always be used
   */
  public static final boolean DEFAULT_ALWAYS_ASYNC_FS = io.vertx.ext.web.handler.StaticHandler.DEFAULT_ALWAYS_ASYNC_FS;
  /**
   * Default of whether fs async/sync tuning should be used
   */
  public static final boolean DEFAULT_ENABLE_FS_TUNING = io.vertx.ext.web.handler.StaticHandler.DEFAULT_ENABLE_FS_TUNING;
  /**
   * Default max avg serve time, in ns, over which serving will be considered slow
   */
  public static final long DEFAULT_MAX_AVG_SERVE_TIME_NS = io.vertx.ext.web.handler.StaticHandler.DEFAULT_MAX_AVG_SERVE_TIME_NS;
  /**
   * Default of whether Range request handling support should be used
   */
  public static final boolean DEFAULT_RANGE_SUPPORT = io.vertx.ext.web.handler.StaticHandler.DEFAULT_RANGE_SUPPORT;
  /**
   * Default of whether access to the root of the file system should be allowed or just allow from the current working
   * directory.
   */
  public static final boolean DEFAULT_ROOT_FILESYSTEM_ACCESS = io.vertx.ext.web.handler.StaticHandler.DEFAULT_ROOT_FILESYSTEM_ACCESS;
  /**
   * Default of whether vary header should be sent.
   */
  public static final boolean DEFAULT_SEND_VARY_HEADER = io.vertx.ext.web.handler.StaticHandler.DEFAULT_SEND_VARY_HEADER;
  public static StaticHandler newInstance(io.vertx.ext.web.handler.StaticHandler arg) {
    return arg != null ? new StaticHandler(arg) : null;
  }

}
