/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.openapi;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface to build a Vert.x Web  from an OpenAPI 3 contract. <br/>
 * To add an handler, use {@link io.vertx.reactivex.ext.web.openapi.RouterBuilder#operation} (String, Handler)}<br/>
 * Usage example:
 * <pre>
 * <code>RouterBuilder.create(vertx, "src/resources/spec.yaml", asyncResult -> {
  if (!asyncResult.succeeded()) {
     // IO failure or spec invalid</code> else {
 *     RouterBuilder routerBuilder = asyncResult.result();
 *     RouterBuilder.operation("operation_id").handler(routingContext -> {
 *        // Do something
 *     }, routingContext -> {
 *        // Do something with failure handler
 *     });
 *     Router router = routerBuilder.createRouter();
 *  }
 * });
 * }
 * </pre>
 * <br/>
 * Handlers are loaded in this order:<br/>
 *  <ol>
 *   <li>Body handler (Customizable with </li>
 *   <li>Custom global handlers configurable with </li>
 *   <li>Global security handlers defined in upper spec level</li>
 *   <li>Operation specific security handlers</li>
 *   <li>Generated validation handler</li>
 *   <li>User handlers or "Not implemented" handler</li>
 * </ol>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.openapi.RouterBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.openapi.RouterBuilder.class)
public class RouterBuilder {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RouterBuilder that = (RouterBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RouterBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new RouterBuilder((io.vertx.ext.web.openapi.RouterBuilder) obj),
    RouterBuilder::getDelegate
  );

  private final io.vertx.ext.web.openapi.RouterBuilder delegate;
  
  public RouterBuilder(io.vertx.ext.web.openapi.RouterBuilder delegate) {
    this.delegate = delegate;
  }

  public RouterBuilder(Object delegate) {
    this.delegate = (io.vertx.ext.web.openapi.RouterBuilder)delegate;
  }

  public io.vertx.ext.web.openapi.RouterBuilder getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.web.openapi.Operation> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.web.openapi.Operation>(o1 -> io.vertx.reactivex.ext.web.openapi.Operation.newInstance((io.vertx.ext.web.openapi.Operation)o1), o1 -> o1.getDelegate());

  /**
   * Access to an operation defined in the contract with <code>operationId</code>
   * @param operationId the id of the operation
   * @return the requested operation
   */
  public io.vertx.reactivex.ext.web.openapi.Operation operation(String operationId) { 
    io.vertx.reactivex.ext.web.openapi.Operation ret = io.vertx.reactivex.ext.web.openapi.Operation.newInstance((io.vertx.ext.web.openapi.Operation)delegate.operation(operationId));
    return ret;
  }

  /**
   * @return all operations defined in the contract
   */
  public List<io.vertx.reactivex.ext.web.openapi.Operation> operations() { 
    List<io.vertx.reactivex.ext.web.openapi.Operation> ret = delegate.operations().stream().map(elt -> io.vertx.reactivex.ext.web.openapi.Operation.newInstance((io.vertx.ext.web.openapi.Operation)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * Supply your own BodyHandler if you would like to control body limit, uploads directory and deletion of uploaded
   * files.
   * If you provide a null body handler, you won't be able to validate request bodies
   * @param bodyHandler 
   * @return self
   */
  public io.vertx.reactivex.ext.web.openapi.RouterBuilder bodyHandler(io.vertx.reactivex.ext.web.handler.BodyHandler bodyHandler) { 
    delegate.bodyHandler(bodyHandler.getDelegate());
    return this;
  }

  /**
   * Add global handler to be applied prior to  being generated. <br/>
   * Please note that you should not add a body handler inside that list. If you want to modify the body handler,
   * please use 
   * @param rootHandler 
   * @return self
   */
  public io.vertx.reactivex.ext.web.openapi.RouterBuilder rootHandler(Handler<io.vertx.reactivex.ext.web.RoutingContext> rootHandler) { 
    delegate.rootHandler(new Handler<io.vertx.ext.web.RoutingContext>() {
      public void handle(io.vertx.ext.web.RoutingContext event) {
        rootHandler.handle(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event));
      }
    });
    return this;
  }

  /**
   * Mount to paths that have to follow a security schema a security handler
   * @param securitySchemaName 
   * @param handler 
   * @return self
   */
  public io.vertx.reactivex.ext.web.openapi.RouterBuilder securityHandler(String securitySchemaName, io.vertx.reactivex.ext.web.handler.AuthenticationHandler handler) { 
    delegate.securityHandler(securitySchemaName, handler.getDelegate());
    return this;
  }

  /**
   * Introspect the OpenAPI spec to mount handlers for all operations that specifies a x-vertx-event-bus annotation.
   * Please give a look at
   * <a href="https://vertx.io/docs/vertx-web-api-service/java/">vertx-web-api-service documentation</a>
   * for more informations
   * @return self
   */
  public io.vertx.reactivex.ext.web.openapi.RouterBuilder mountServicesFromExtensions() { 
    delegate.mountServicesFromExtensions();
    return this;
  }

  /**
   * Set options of router builder. For more info {@link io.vertx.ext.web.openapi.RouterBuilderOptions}
   * @param options 
   * @return self
   */
  public io.vertx.reactivex.ext.web.openapi.RouterBuilder setOptions(io.vertx.ext.web.openapi.RouterBuilderOptions options) { 
    delegate.setOptions(options);
    return this;
  }

  /**
   * @return options of router builder. For more info {@link io.vertx.ext.web.openapi.RouterBuilderOptions}
   */
  public io.vertx.ext.web.openapi.RouterBuilderOptions getOptions() { 
    io.vertx.ext.web.openapi.RouterBuilderOptions ret = delegate.getOptions();
    return ret;
  }

  /**
   * @return holder used by self to process the OpenAPI. You can use it to resolve <code>$ref</code>s
   */
  public io.vertx.reactivex.ext.web.openapi.OpenAPIHolder getOpenAPI() { 
    io.vertx.reactivex.ext.web.openapi.OpenAPIHolder ret = io.vertx.reactivex.ext.web.openapi.OpenAPIHolder.newInstance((io.vertx.ext.web.openapi.OpenAPIHolder)delegate.getOpenAPI());
    return ret;
  }

  /**
   * @return schema router used by self to internally manage all {@link io.vertx.reactivex.json.schema.Schema} instances
   */
  public io.vertx.reactivex.json.schema.SchemaRouter getSchemaRouter() { 
    io.vertx.reactivex.json.schema.SchemaRouter ret = io.vertx.reactivex.json.schema.SchemaRouter.newInstance((io.vertx.json.schema.SchemaRouter)delegate.getSchemaRouter());
    return ret;
  }

  /**
   * @return schema parser used by self to parse all {@link io.vertx.reactivex.json.schema.Schema}
   */
  public io.vertx.reactivex.json.schema.SchemaParser getSchemaParser() { 
    io.vertx.reactivex.json.schema.SchemaParser ret = io.vertx.reactivex.json.schema.SchemaParser.newInstance((io.vertx.json.schema.SchemaParser)delegate.getSchemaParser());
    return ret;
  }

  /**
   * When set, this function is called while creating the payload of 
   * @param serviceExtraPayloadMapper 
   * @return self
   */
  public io.vertx.reactivex.ext.web.openapi.RouterBuilder serviceExtraPayloadMapper(Function<io.vertx.reactivex.ext.web.RoutingContext, JsonObject> serviceExtraPayloadMapper) { 
    delegate.serviceExtraPayloadMapper(new Function<io.vertx.ext.web.RoutingContext,JsonObject>() {
      public JsonObject apply(io.vertx.ext.web.RoutingContext arg) {
        JsonObject ret = serviceExtraPayloadMapper.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
   * without assigned handlers<br/>
   *
   * <b>Note:</b> Router is built when this function is called and the path definition ordering in contract is respected.
   * @return 
   */
  public io.vertx.reactivex.ext.web.Router createRouter() { 
    io.vertx.reactivex.ext.web.Router ret = io.vertx.reactivex.ext.web.Router.newInstance((io.vertx.ext.web.Router)delegate.createRouter());
    return ret;
  }

  /**
   * Like 
   * @param vertx 
   * @param url 
   * @param handler 
   */
  public static void create(io.vertx.reactivex.core.Vertx vertx, String url, Handler<AsyncResult<io.vertx.reactivex.ext.web.openapi.RouterBuilder>> handler) { 
    io.vertx.ext.web.openapi.RouterBuilder.create(vertx.getDelegate(), url, new Handler<AsyncResult<io.vertx.ext.web.openapi.RouterBuilder>>() {
      public void handle(AsyncResult<io.vertx.ext.web.openapi.RouterBuilder> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.openapi.RouterBuilder.newInstance((io.vertx.ext.web.openapi.RouterBuilder)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like 
   * @param vertx 
   * @param url 
   */
  public static void create(io.vertx.reactivex.core.Vertx vertx, String url) {
    create(vertx, url, ar -> { });
  }

  /**
   * Like 
   * @param vertx 
   * @param url 
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.web.openapi.RouterBuilder> rxCreate(io.vertx.reactivex.core.Vertx vertx, String url) { 
    return AsyncResultSingle.toSingle($handler -> {
      create(vertx, url, $handler);
    });
  }

  /**
   * Like 
   * @param vertx 
   * @param url 
   * @param options 
   * @param handler 
   */
  public static void create(io.vertx.reactivex.core.Vertx vertx, String url, io.vertx.ext.web.openapi.OpenAPILoaderOptions options, Handler<AsyncResult<io.vertx.reactivex.ext.web.openapi.RouterBuilder>> handler) { 
    io.vertx.ext.web.openapi.RouterBuilder.create(vertx.getDelegate(), url, options, new Handler<AsyncResult<io.vertx.ext.web.openapi.RouterBuilder>>() {
      public void handle(AsyncResult<io.vertx.ext.web.openapi.RouterBuilder> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.openapi.RouterBuilder.newInstance((io.vertx.ext.web.openapi.RouterBuilder)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like 
   * @param vertx 
   * @param url 
   * @param options 
   */
  public static void create(io.vertx.reactivex.core.Vertx vertx, String url, io.vertx.ext.web.openapi.OpenAPILoaderOptions options) {
    create(vertx, url, options, ar -> { });
  }

  /**
   * Like 
   * @param vertx 
   * @param url 
   * @param options 
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.web.openapi.RouterBuilder> rxCreate(io.vertx.reactivex.core.Vertx vertx, String url, io.vertx.ext.web.openapi.OpenAPILoaderOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      create(vertx, url, options, $handler);
    });
  }

  public static RouterBuilder newInstance(io.vertx.ext.web.openapi.RouterBuilder arg) {
    return arg != null ? new RouterBuilder(arg) : null;
  }

}
