/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.sstore;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A session store which stores sessions in a distributed map so they are available across the cluster.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.sstore.ClusteredSessionStore original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.sstore.ClusteredSessionStore.class)
public class ClusteredSessionStore extends io.vertx.reactivex.ext.web.sstore.SessionStore {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusteredSessionStore that = (ClusteredSessionStore) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ClusteredSessionStore> __TYPE_ARG = new TypeArg<>(    obj -> new ClusteredSessionStore((io.vertx.ext.web.sstore.ClusteredSessionStore) obj),
    ClusteredSessionStore::getDelegate
  );

  private final io.vertx.ext.web.sstore.ClusteredSessionStore delegate;
  
  public ClusteredSessionStore(io.vertx.ext.web.sstore.ClusteredSessionStore delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public ClusteredSessionStore(Object delegate) {
    super((io.vertx.ext.web.sstore.ClusteredSessionStore)delegate);
    this.delegate = (io.vertx.ext.web.sstore.ClusteredSessionStore)delegate;
  }

  public io.vertx.ext.web.sstore.ClusteredSessionStore getDelegate() {
    return delegate;
  }

  /**
   * Create a session store
   * @param vertx the Vert.x instance
   * @param sessionMapName the session map name
   * @return the session store
   */
  public static io.vertx.reactivex.ext.web.sstore.ClusteredSessionStore create(io.vertx.reactivex.core.Vertx vertx, String sessionMapName) { 
    io.vertx.reactivex.ext.web.sstore.ClusteredSessionStore ret = io.vertx.reactivex.ext.web.sstore.ClusteredSessionStore.newInstance((io.vertx.ext.web.sstore.ClusteredSessionStore)io.vertx.ext.web.sstore.ClusteredSessionStore.create(vertx.getDelegate(), sessionMapName));
    return ret;
  }

  /**
   * Create a session store.<p/>
   *
   * The retry timeout value, configures how long the session handler will retry to get a session from the store
   * when it is not found.
   * @param vertx the Vert.x instance
   * @param sessionMapName the session map name
   * @param retryTimeout the store retry timeout, in ms
   * @return the session store
   */
  public static io.vertx.reactivex.ext.web.sstore.ClusteredSessionStore create(io.vertx.reactivex.core.Vertx vertx, String sessionMapName, long retryTimeout) { 
    io.vertx.reactivex.ext.web.sstore.ClusteredSessionStore ret = io.vertx.reactivex.ext.web.sstore.ClusteredSessionStore.newInstance((io.vertx.ext.web.sstore.ClusteredSessionStore)io.vertx.ext.web.sstore.ClusteredSessionStore.create(vertx.getDelegate(), sessionMapName, retryTimeout));
    return ret;
  }

  /**
   * Create a session store
   * @param vertx the Vert.x instance
   * @return the session store
   */
  public static io.vertx.reactivex.ext.web.sstore.ClusteredSessionStore create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.sstore.ClusteredSessionStore ret = io.vertx.reactivex.ext.web.sstore.ClusteredSessionStore.newInstance((io.vertx.ext.web.sstore.ClusteredSessionStore)io.vertx.ext.web.sstore.ClusteredSessionStore.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a session store.<p/>
   *
   * The retry timeout value, configures how long the session handler will retry to get a session from the store
   * when it is not found.
   * @param vertx the Vert.x instance
   * @param retryTimeout the store retry timeout, in ms
   * @return the session store
   */
  public static io.vertx.reactivex.ext.web.sstore.ClusteredSessionStore create(io.vertx.reactivex.core.Vertx vertx, long retryTimeout) { 
    io.vertx.reactivex.ext.web.sstore.ClusteredSessionStore ret = io.vertx.reactivex.ext.web.sstore.ClusteredSessionStore.newInstance((io.vertx.ext.web.sstore.ClusteredSessionStore)io.vertx.ext.web.sstore.ClusteredSessionStore.create(vertx.getDelegate(), retryTimeout));
    return ret;
  }

  /**
   * Default length for a session id.
   * More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
   */
  public static final int DEFAULT_SESSIONID_LENGTH = io.vertx.ext.web.sstore.ClusteredSessionStore.DEFAULT_SESSIONID_LENGTH;
  /**
   * The default name used for the session map
   */
  public static final String DEFAULT_SESSION_MAP_NAME = io.vertx.ext.web.sstore.ClusteredSessionStore.DEFAULT_SESSION_MAP_NAME;
  /**
   * Default retry time out, in ms, for a session not found in this store.
   */
  public static final long DEFAULT_RETRY_TIMEOUT = io.vertx.ext.web.sstore.ClusteredSessionStore.DEFAULT_RETRY_TIMEOUT;
  public static ClusteredSessionStore newInstance(io.vertx.ext.web.sstore.ClusteredSessionStore arg) {
    return arg != null ? new ClusteredSessionStore(arg) : null;
  }

}
