/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.sstore;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A session store is used to store sessions for an Vert.x-Web web app
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.sstore.SessionStore original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.sstore.SessionStore.class)
public class SessionStore {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SessionStore that = (SessionStore) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SessionStore> __TYPE_ARG = new TypeArg<>(    obj -> new SessionStore((io.vertx.ext.web.sstore.SessionStore) obj),
    SessionStore::getDelegate
  );

  private final io.vertx.ext.web.sstore.SessionStore delegate;
  
  public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
    this.delegate = delegate;
  }

  public SessionStore(Object delegate) {
    this.delegate = (io.vertx.ext.web.sstore.SessionStore)delegate;
  }

  public io.vertx.ext.web.sstore.SessionStore getDelegate() {
    return delegate;
  }

  /**
   * Create a Session store given a backend and configuration JSON.
   * @param vertx vertx instance
   * @return the store or runtime exception
   */
  public static io.vertx.reactivex.ext.web.sstore.SessionStore create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.sstore.SessionStore ret = io.vertx.reactivex.ext.web.sstore.SessionStore.newInstance((io.vertx.ext.web.sstore.SessionStore)io.vertx.ext.web.sstore.SessionStore.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a Session store given a backend and configuration JSON.
   * @param vertx vertx instance
   * @param options extra options for initialization
   * @return the store or runtime exception
   */
  public static io.vertx.reactivex.ext.web.sstore.SessionStore create(io.vertx.reactivex.core.Vertx vertx, JsonObject options) { 
    io.vertx.reactivex.ext.web.sstore.SessionStore ret = io.vertx.reactivex.ext.web.sstore.SessionStore.newInstance((io.vertx.ext.web.sstore.SessionStore)io.vertx.ext.web.sstore.SessionStore.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Initialize this store.
   * @param vertx the vertx instance
   * @param options optional Json with extra configuration options
   * @return self
   */
  public io.vertx.reactivex.ext.web.sstore.SessionStore init(io.vertx.reactivex.core.Vertx vertx, JsonObject options) { 
    delegate.init(vertx.getDelegate(), options);
    return this;
  }

  /**
   * The retry timeout value in milli seconds used by the session handler when it retrieves a value from the store.<p/>
   *
   * A non positive value means there is no retry at all.
   * @return the timeout value, in ms
   */
  public long retryTimeout() { 
    long ret = delegate.retryTimeout();
    return ret;
  }

  /**
   * Create a new session using the default min length.
   * @param timeout - the session timeout, in ms
   * @return the session
   */
  public io.vertx.reactivex.ext.web.Session createSession(long timeout) { 
    io.vertx.reactivex.ext.web.Session ret = io.vertx.reactivex.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.createSession(timeout));
    return ret;
  }

  /**
   * Create a new session.
   * @param timeout - the session timeout, in ms
   * @param length - the required length for the session id
   * @return the session
   */
  public io.vertx.reactivex.ext.web.Session createSession(long timeout, int length) { 
    io.vertx.reactivex.ext.web.Session ret = io.vertx.reactivex.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.createSession(timeout, length));
    return ret;
  }

  /**
   * Get the session with the specified ID.
   * @param cookieValue the unique ID of the session
   * @param resultHandler will be called with a result holding the session, or a failure
   */
  public void get(String cookieValue, Handler<AsyncResult<io.vertx.reactivex.ext.web.Session>> resultHandler) { 
    delegate.get(cookieValue, new Handler<AsyncResult<io.vertx.ext.web.Session>>() {
      public void handle(AsyncResult<io.vertx.ext.web.Session> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.Session.newInstance((io.vertx.ext.web.Session)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get the session with the specified ID.
   * @param cookieValue the unique ID of the session
   */
  public void get(String cookieValue) {
    get(cookieValue, ar -> { });
  }

  /**
   * Get the session with the specified ID.
   * @param cookieValue the unique ID of the session
   * @return 
   */
  public io.reactivex.Maybe<io.vertx.reactivex.ext.web.Session> rxGet(String cookieValue) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      get(cookieValue, $handler);
    });
  }

  /**
   * Delete the session with the specified ID.
   * @param id the session id
   * @param resultHandler will be called with a success or a failure
   */
  public void delete(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.delete(id, resultHandler);
  }

  /**
   * Delete the session with the specified ID.
   * @param id the session id
   */
  public void delete(String id) {
    delete(id, ar -> { });
  }

  /**
   * Delete the session with the specified ID.
   * @param id the session id
   * @return 
   */
  public io.reactivex.Completable rxDelete(String id) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      delete(id, $handler);
    });
  }

  /**
   * Add a session with the specified ID.
   * @param session the session
   * @param resultHandler will be called with a success or a failure
   */
  public void put(io.vertx.reactivex.ext.web.Session session, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.put(session.getDelegate(), resultHandler);
  }

  /**
   * Add a session with the specified ID.
   * @param session the session
   */
  public void put(io.vertx.reactivex.ext.web.Session session) {
    put(session, ar -> { });
  }

  /**
   * Add a session with the specified ID.
   * @param session the session
   * @return 
   */
  public io.reactivex.Completable rxPut(io.vertx.reactivex.ext.web.Session session) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      put(session, $handler);
    });
  }

  /**
   * Remove all sessions from the store.
   * @param resultHandler will be called with a success or a failure
   */
  public void clear(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.clear(resultHandler);
  }

  /**
   * Remove all sessions from the store.
   */
  public void clear() {
    clear(ar -> { });
  }

  /**
   * Remove all sessions from the store.
   * @return 
   */
  public io.reactivex.Completable rxClear() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      clear($handler);
    });
  }

  /**
   * Get the number of sessions in the store.
   * <p>
   * Beware of the result which is just an estimate, in particular with distributed session stores.
   * @param resultHandler will be called with the number, or a failure
   */
  public void size(Handler<AsyncResult<Integer>> resultHandler) { 
    delegate.size(resultHandler);
  }

  /**
   * Get the number of sessions in the store.
   * <p>
   * Beware of the result which is just an estimate, in particular with distributed session stores.
   */
  public void size() {
    size(ar -> { });
  }

  /**
   * Get the number of sessions in the store.
   * <p>
   * Beware of the result which is just an estimate, in particular with distributed session stores.
   * @return 
   */
  public io.reactivex.Single<Integer> rxSize() { 
    return AsyncResultSingle.toSingle($handler -> {
      size($handler);
    });
  }

  /**
   * Close the store
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Default length for a session id.
   * More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
   */
  public static final int DEFAULT_SESSIONID_LENGTH = io.vertx.ext.web.sstore.SessionStore.DEFAULT_SESSIONID_LENGTH;
  public static SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
    return arg != null ? new SessionStore(arg) : null;
  }

}
