/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.json.schema;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Parse a Json Schema. The parser can be extended to support custom keywords using 
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.SchemaParser original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.json.schema.SchemaParser.class)
public class SchemaParser {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SchemaParser that = (SchemaParser) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SchemaParser> __TYPE_ARG = new TypeArg<>(    obj -> new SchemaParser((io.vertx.json.schema.SchemaParser) obj),
    SchemaParser::getDelegate
  );

  private final io.vertx.json.schema.SchemaParser delegate;
  
  public SchemaParser(io.vertx.json.schema.SchemaParser delegate) {
    this.delegate = delegate;
  }

  public SchemaParser(Object delegate) {
    this.delegate = (io.vertx.json.schema.SchemaParser)delegate;
  }

  public io.vertx.json.schema.SchemaParser getDelegate() {
    return delegate;
  }

  /**
   * Build a schema from provided json assigning a random scope. This method registers the parsed schema (and relative subschemas) to the schema router
   * @param jsonSchema JSON representing the schema
   * @return the schema instance
   */
  public io.vertx.reactivex.json.schema.Schema parse(JsonObject jsonSchema) { 
    io.vertx.reactivex.json.schema.Schema ret = io.vertx.reactivex.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.parse(jsonSchema));
    return ret;
  }

  /**
   * Build a schema from provided json. This method registers the parsed schema (and relative subschemas) to the schema router
   * @param jsonSchema JSON representing the schema
   * @param schemaPointer Scope of schema. Must be a JSONPointer with absolute URI
   * @return the schema instance
   */
  public io.vertx.reactivex.json.schema.Schema parse(JsonObject jsonSchema, io.vertx.reactivex.core.json.pointer.JsonPointer schemaPointer) { 
    io.vertx.reactivex.json.schema.Schema ret = io.vertx.reactivex.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.parse(jsonSchema, schemaPointer.getDelegate()));
    return ret;
  }

  /**
   * Builds a true of false schema assigning a random scope
   * @param jsonSchema JSON representing the schema
   * @return the schema instance
   */
  public io.vertx.reactivex.json.schema.Schema parse(Boolean jsonSchema) { 
    io.vertx.reactivex.json.schema.Schema ret = io.vertx.reactivex.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.parse(jsonSchema));
    return ret;
  }

  /**
   * Builds a true of false schema
   * @param jsonSchema JSON representing the schema
   * @param schemaPointer Scope of schema. Must be a JSONPointer with absolute URI
   * @return the schema instance
   */
  public io.vertx.reactivex.json.schema.Schema parse(Boolean jsonSchema, io.vertx.reactivex.core.json.pointer.JsonPointer schemaPointer) { 
    io.vertx.reactivex.json.schema.Schema ret = io.vertx.reactivex.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.parse(jsonSchema, schemaPointer.getDelegate()));
    return ret;
  }

  /**
   * Build a schema from provided unparsed json assigning a random scope. This method registers the parsed schema (and relative subschemas) to the schema router
   * @param unparsedJson Unparsed JSON representing the schema.
   * @return the schema instance
   */
  public io.vertx.reactivex.json.schema.Schema parseFromString(String unparsedJson) { 
    io.vertx.reactivex.json.schema.Schema ret = io.vertx.reactivex.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.parseFromString(unparsedJson));
    return ret;
  }

  /**
   * Build a schema from provided unparsed json. This method registers the parsed schema (and relative subschemas) to the schema router
   * @param unparsedJson Unparsed JSON representing the schema.
   * @param schemaPointer Scope of schema. Must be a JSONPointer with absolute URI
   * @return the schema instance
   */
  public io.vertx.reactivex.json.schema.Schema parseFromString(String unparsedJson, io.vertx.reactivex.core.json.pointer.JsonPointer schemaPointer) { 
    io.vertx.reactivex.json.schema.Schema ret = io.vertx.reactivex.json.schema.Schema.newInstance((io.vertx.json.schema.Schema)delegate.parseFromString(unparsedJson, schemaPointer.getDelegate()));
    return ret;
  }

  /**
   * Get schema router registered to this schema parser
   * @return 
   */
  public io.vertx.reactivex.json.schema.SchemaRouter getSchemaRouter() { 
    io.vertx.reactivex.json.schema.SchemaRouter ret = io.vertx.reactivex.json.schema.SchemaRouter.newInstance((io.vertx.json.schema.SchemaRouter)delegate.getSchemaRouter());
    return ret;
  }

  /**
   * Create a new {@link io.vertx.reactivex.json.schema.SchemaParser} for OpenAPI schemas
   * @param router 
   * @return 
   */
  public static io.vertx.reactivex.json.schema.SchemaParser createOpenAPI3SchemaParser(io.vertx.reactivex.json.schema.SchemaRouter router) { 
    io.vertx.reactivex.json.schema.SchemaParser ret = io.vertx.reactivex.json.schema.SchemaParser.newInstance((io.vertx.json.schema.SchemaParser)io.vertx.json.schema.SchemaParser.createOpenAPI3SchemaParser(router.getDelegate()));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.reactivex.json.schema.SchemaParser} for Json Schema Draft-7 schemas
   * @param router 
   * @return 
   */
  public static io.vertx.reactivex.json.schema.SchemaParser createDraft7SchemaParser(io.vertx.reactivex.json.schema.SchemaRouter router) { 
    io.vertx.reactivex.json.schema.SchemaParser ret = io.vertx.reactivex.json.schema.SchemaParser.newInstance((io.vertx.json.schema.SchemaParser)io.vertx.json.schema.SchemaParser.createDraft7SchemaParser(router.getDelegate()));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.reactivex.json.schema.SchemaParser} for Json Schema Draft2019-09 schemas
   * @param router 
   * @return 
   */
  public static io.vertx.reactivex.json.schema.SchemaParser createDraft201909SchemaParser(io.vertx.reactivex.json.schema.SchemaRouter router) { 
    io.vertx.reactivex.json.schema.SchemaParser ret = io.vertx.reactivex.json.schema.SchemaParser.newInstance((io.vertx.json.schema.SchemaParser)io.vertx.json.schema.SchemaParser.createDraft201909SchemaParser(router.getDelegate()));
    return ret;
  }

  /**
   * Add a  to this schema parser to support custom keywords
   * @param factory new factory
   * @return a reference to this
   */
  public io.vertx.reactivex.json.schema.SchemaParser withValidatorFactory(io.vertx.json.schema.common.ValidatorFactory factory) { 
    delegate.withValidatorFactory(factory);
    return this;
  }

  /**
   * Add a custom format validator
   * @param formatName format name
   * @param predicate predicate for the new format
   * @return a reference to this
   */
  public io.vertx.reactivex.json.schema.SchemaParser withStringFormatValidator(String formatName, java.util.function.Predicate<String> predicate) { 
    delegate.withStringFormatValidator(formatName, predicate);
    return this;
  }

  public static SchemaParser newInstance(io.vertx.json.schema.SchemaParser arg) {
    return arg != null ? new SchemaParser(arg) : null;
  }

}
