/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.micrometer;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The metrics service mainly allows to return a snapshot of measured objects.<br/>
 * This service is derived and adapted from <code>MetricsService</code> in the <i>vertx-dropwizard-metrics</i> module.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.micrometer.MetricsService original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.micrometer.MetricsService.class)
public class MetricsService {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MetricsService that = (MetricsService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MetricsService> __TYPE_ARG = new TypeArg<>(    obj -> new MetricsService((io.vertx.micrometer.MetricsService) obj),
    MetricsService::getDelegate
  );

  private final io.vertx.micrometer.MetricsService delegate;
  
  public MetricsService(io.vertx.micrometer.MetricsService delegate) {
    this.delegate = delegate;
  }

  public MetricsService(Object delegate) {
    this.delegate = (io.vertx.micrometer.MetricsService)delegate;
  }

  public io.vertx.micrometer.MetricsService getDelegate() {
    return delegate;
  }


  /**
   * Creates a metric service for a given  object.
   * @param measured the measured object
   * @return the metrics service
   */
  public static io.vertx.reactivex.micrometer.MetricsService create(io.vertx.reactivex.core.metrics.Measured measured) { 
    io.vertx.reactivex.micrometer.MetricsService ret = io.vertx.reactivex.micrometer.MetricsService.newInstance((io.vertx.micrometer.MetricsService)io.vertx.micrometer.MetricsService.create(measured.getDelegate()));
    return ret;
  }

  /**
   * @return the base name of the measured object
   */
  public String getBaseName() { 
    String ret = delegate.getBaseName();
    return ret;
  }

  /**
   * @return the known metrics names by this service
   */
  public Set<String> metricsNames() { 
    Set<String> ret = delegate.metricsNames();
    return ret;
  }

  /**
   * Will return the metrics that correspond with the <code>measured</code> object, null if no metrics is available.<p/>
   * @return the map of metrics where the key is the name of the metric (excluding the base name unless for the Vert.x object) and the value is the json data representing that metric
   */
  public JsonObject getMetricsSnapshot() { 
    JsonObject ret = delegate.getMetricsSnapshot();
    return ret;
  }

  /**
   * Will return the metrics that begins with the <code>baseName</code>, null if no metrics is available.<p/>
   * @param baseName 
   * @return the map of metrics where the key is the name of the metric and the value is the json data representing that metric
   */
  public JsonObject getMetricsSnapshot(String baseName) { 
    JsonObject ret = delegate.getMetricsSnapshot(baseName);
    return ret;
  }

  public static MetricsService newInstance(io.vertx.micrometer.MetricsService arg) {
    return arg != null ? new MetricsService(arg) : null;
  }

}
