/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mqtt.messages;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an MQTT CONNACK message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.messages.MqttConnAckMessage original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.messages.MqttConnAckMessage.class)
public class MqttConnAckMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttConnAckMessage that = (MqttConnAckMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MqttConnAckMessage> __TYPE_ARG = new TypeArg<>(    obj -> new MqttConnAckMessage((io.vertx.mqtt.messages.MqttConnAckMessage) obj),
    MqttConnAckMessage::getDelegate
  );

  private final io.vertx.mqtt.messages.MqttConnAckMessage delegate;
  
  public MqttConnAckMessage(io.vertx.mqtt.messages.MqttConnAckMessage delegate) {
    this.delegate = delegate;
  }

  public MqttConnAckMessage(Object delegate) {
    this.delegate = (io.vertx.mqtt.messages.MqttConnAckMessage)delegate;
  }

  public io.vertx.mqtt.messages.MqttConnAckMessage getDelegate() {
    return delegate;
  }

  /**
   * Create a concrete instance of a Vert.x connack message
   * @param code return code from the connection request
   * @param isSessionPresent is an old session is present
   * @return 
   */
  public static io.vertx.reactivex.mqtt.messages.MqttConnAckMessage create(io.netty.handler.codec.mqtt.MqttConnectReturnCode code, boolean isSessionPresent) { 
    io.vertx.reactivex.mqtt.messages.MqttConnAckMessage ret = io.vertx.reactivex.mqtt.messages.MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)io.vertx.mqtt.messages.MqttConnAckMessage.create(code, isSessionPresent));
    return ret;
  }

  /**
   * @return return code from the connection request
   */
  public io.netty.handler.codec.mqtt.MqttConnectReturnCode code() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.netty.handler.codec.mqtt.MqttConnectReturnCode ret = delegate.code();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return is an old session is present
   */
  public boolean isSessionPresent() { 
    if (cached_1 != null) {
      return cached_1;
    }
    boolean ret = delegate.isSessionPresent();
    cached_1 = ret;
    return ret;
  }

  private io.netty.handler.codec.mqtt.MqttConnectReturnCode cached_0;
  private java.lang.Boolean cached_1;
  public static MqttConnAckMessage newInstance(io.vertx.mqtt.messages.MqttConnAckMessage arg) {
    return arg != null ? new MqttConnAckMessage(arg) : null;
  }

}
