/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.rabbitmq;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represent a message received message received in a rabbitmq-queue.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.RabbitMQMessage original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.rabbitmq.RabbitMQMessage.class)
public class RabbitMQMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RabbitMQMessage that = (RabbitMQMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RabbitMQMessage> __TYPE_ARG = new TypeArg<>(    obj -> new RabbitMQMessage((io.vertx.rabbitmq.RabbitMQMessage) obj),
    RabbitMQMessage::getDelegate
  );

  private final io.vertx.rabbitmq.RabbitMQMessage delegate;
  
  public RabbitMQMessage(io.vertx.rabbitmq.RabbitMQMessage delegate) {
    this.delegate = delegate;
  }

  public RabbitMQMessage(Object delegate) {
    this.delegate = (io.vertx.rabbitmq.RabbitMQMessage)delegate;
  }

  public io.vertx.rabbitmq.RabbitMQMessage getDelegate() {
    return delegate;
  }

  /**
   * @return the message body
   */
  public io.vertx.reactivex.core.buffer.Buffer body() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.buffer.Buffer ret = io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.body());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the <i>consumer tag</i> associated with the consumer
   */
  public String consumerTag() { 
    if (cached_1 != null) {
      return cached_1;
    }
    String ret = delegate.consumerTag();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the message count for messages obtained with {@link io.vertx.reactivex.rabbitmq.RabbitMQClient#basicGet}
   */
  public Integer messageCount() { 
    if (cached_2 != null) {
      return cached_2;
    }
    Integer ret = delegate.messageCount();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return packaging data for the message
   */
  public com.rabbitmq.client.Envelope envelope() { 
    if (cached_3 != null) {
      return cached_3;
    }
    com.rabbitmq.client.Envelope ret = delegate.envelope();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return content header data for the message
   */
  public com.rabbitmq.client.BasicProperties properties() { 
    if (cached_4 != null) {
      return cached_4;
    }
    com.rabbitmq.client.BasicProperties ret = delegate.properties();
    cached_4 = ret;
    return ret;
  }

  private io.vertx.reactivex.core.buffer.Buffer cached_0;
  private String cached_1;
  private Integer cached_2;
  private com.rabbitmq.client.Envelope cached_3;
  private com.rabbitmq.client.BasicProperties cached_4;
  public static RabbitMQMessage newInstance(io.vertx.rabbitmq.RabbitMQMessage arg) {
    return arg != null ? new RabbitMQMessage(arg) : null;
  }

}
