/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <b>Auto generated</b> API Commands to interact with REDIS.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Command original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.Command.class)
public class Command {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Command that = (Command) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Command> __TYPE_ARG = new TypeArg<>(    obj -> new Command((io.vertx.redis.client.Command) obj),
    Command::getDelegate
  );

  private final io.vertx.redis.client.Command delegate;
  
  public Command(io.vertx.redis.client.Command delegate) {
    this.delegate = delegate;
  }

  public Command(Object delegate) {
    this.delegate = (io.vertx.redis.client.Command)delegate;
  }

  public io.vertx.redis.client.Command getDelegate() {
    return delegate;
  }

  /**
   * Creates a Redis Command from METADATA. The metadata comes from the REDIS command "COMMAND"
   * https://redis.io/commands/command
   *
   * Each top-level result contains six nested results. Each nested result is:
   *
   *     command name
   *     command arity specification
   *     nested Array reply of command flags
   *     position of first key in argument list
   *     position of last key in argument list
   *     step count for locating repeating keys
   * @param command command name
   * @param arity arity
   * @param firstKey position of the first key
   * @param lastKey position of the last key
   * @param interval step count for locating repeating keys
   * @param write write flag extracted from the nested Array reply of command flags
   * @param readOnly readOnly flag extracted from the nested Array reply of command flags
   * @param movable movable flag extracted from the nested Array reply of command flags
   * @param pubsub flag extracted from the nested Array reply of command flags
   * @return a command instance
   */
  public static io.vertx.reactivex.redis.client.Command create(String command, int arity, int firstKey, int lastKey, int interval, boolean write, boolean readOnly, boolean movable, boolean pubsub) { 
    io.vertx.reactivex.redis.client.Command ret = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.create(command, arity, firstKey, lastKey, interval, write, readOnly, movable, pubsub));
    return ret;
  }

  /**
   * Generic command generator for extensions.
   * @param command 
   * @return the cachable immutable command instance
   */
  public static io.vertx.reactivex.redis.client.Command create(String command) { 
    io.vertx.reactivex.redis.client.Command ret = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.create(command));
    return ret;
  }

  public int getArity() { 
    int ret = delegate.getArity();
    return ret;
  }

  public boolean isMultiKey() { 
    boolean ret = delegate.isMultiKey();
    return ret;
  }

  public int getFirstKey() { 
    int ret = delegate.getFirstKey();
    return ret;
  }

  public int getLastKey() { 
    int ret = delegate.getLastKey();
    return ret;
  }

  public int getInterval() { 
    int ret = delegate.getInterval();
    return ret;
  }

  public boolean isKeyless() { 
    boolean ret = delegate.isKeyless();
    return ret;
  }

  public boolean isWrite() { 
    boolean ret = delegate.isWrite();
    return ret;
  }

  public boolean isReadOnly() { 
    boolean ret = delegate.isReadOnly();
    return ret;
  }

  public boolean isMovable() { 
    boolean ret = delegate.isMovable();
    return ret;
  }

  public boolean isVoid() { 
    boolean ret = delegate.isVoid();
    return ret;
  }

  public boolean isPubSub() { 
    boolean ret = delegate.isPubSub();
    return ret;
  }

  public byte[] getBytes() { 
    byte[] ret = delegate.getBytes();
    return ret;
  }

  public static final io.vertx.reactivex.redis.client.Command ACL = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ACL);
  public static final io.vertx.reactivex.redis.client.Command APPEND = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.APPEND);
  public static final io.vertx.reactivex.redis.client.Command ASKING = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ASKING);
  public static final io.vertx.reactivex.redis.client.Command AUTH = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.AUTH);
  public static final io.vertx.reactivex.redis.client.Command BGREWRITEAOF = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BGREWRITEAOF);
  public static final io.vertx.reactivex.redis.client.Command BGSAVE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BGSAVE);
  public static final io.vertx.reactivex.redis.client.Command BITCOUNT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITCOUNT);
  public static final io.vertx.reactivex.redis.client.Command BITFIELD = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITFIELD);
  public static final io.vertx.reactivex.redis.client.Command BITFIELD_RO = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITFIELD_RO);
  public static final io.vertx.reactivex.redis.client.Command BITOP = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITOP);
  public static final io.vertx.reactivex.redis.client.Command BITPOS = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BITPOS);
  public static final io.vertx.reactivex.redis.client.Command BLPOP = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BLPOP);
  public static final io.vertx.reactivex.redis.client.Command BRPOP = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BRPOP);
  public static final io.vertx.reactivex.redis.client.Command BRPOPLPUSH = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BRPOPLPUSH);
  public static final io.vertx.reactivex.redis.client.Command BZPOPMAX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BZPOPMAX);
  public static final io.vertx.reactivex.redis.client.Command BZPOPMIN = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.BZPOPMIN);
  public static final io.vertx.reactivex.redis.client.Command CLIENT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CLIENT);
  public static final io.vertx.reactivex.redis.client.Command CLUSTER = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CLUSTER);
  public static final io.vertx.reactivex.redis.client.Command COMMAND = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.COMMAND);
  public static final io.vertx.reactivex.redis.client.Command CONFIG = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.CONFIG);
  public static final io.vertx.reactivex.redis.client.Command DBSIZE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DBSIZE);
  public static final io.vertx.reactivex.redis.client.Command DEBUG = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DEBUG);
  public static final io.vertx.reactivex.redis.client.Command DECR = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DECR);
  public static final io.vertx.reactivex.redis.client.Command DECRBY = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DECRBY);
  public static final io.vertx.reactivex.redis.client.Command DEL = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DEL);
  public static final io.vertx.reactivex.redis.client.Command DISCARD = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DISCARD);
  public static final io.vertx.reactivex.redis.client.Command DUMP = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.DUMP);
  public static final io.vertx.reactivex.redis.client.Command ECHO = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ECHO);
  public static final io.vertx.reactivex.redis.client.Command EVAL = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EVAL);
  public static final io.vertx.reactivex.redis.client.Command EVALSHA = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EVALSHA);
  public static final io.vertx.reactivex.redis.client.Command EXEC = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXEC);
  public static final io.vertx.reactivex.redis.client.Command EXISTS = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXISTS);
  public static final io.vertx.reactivex.redis.client.Command EXPIRE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXPIRE);
  public static final io.vertx.reactivex.redis.client.Command EXPIREAT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.EXPIREAT);
  public static final io.vertx.reactivex.redis.client.Command FLUSHALL = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FLUSHALL);
  public static final io.vertx.reactivex.redis.client.Command FLUSHDB = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.FLUSHDB);
  public static final io.vertx.reactivex.redis.client.Command GEOADD = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOADD);
  public static final io.vertx.reactivex.redis.client.Command GEODIST = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEODIST);
  public static final io.vertx.reactivex.redis.client.Command GEOHASH = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOHASH);
  public static final io.vertx.reactivex.redis.client.Command GEOPOS = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEOPOS);
  public static final io.vertx.reactivex.redis.client.Command GEORADIUS = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEORADIUS);
  public static final io.vertx.reactivex.redis.client.Command GEORADIUS_RO = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEORADIUS_RO);
  public static final io.vertx.reactivex.redis.client.Command GEORADIUSBYMEMBER = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEORADIUSBYMEMBER);
  public static final io.vertx.reactivex.redis.client.Command GEORADIUSBYMEMBER_RO = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GEORADIUSBYMEMBER_RO);
  public static final io.vertx.reactivex.redis.client.Command GET = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GET);
  public static final io.vertx.reactivex.redis.client.Command GETBIT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETBIT);
  public static final io.vertx.reactivex.redis.client.Command GETRANGE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETRANGE);
  public static final io.vertx.reactivex.redis.client.Command GETSET = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.GETSET);
  public static final io.vertx.reactivex.redis.client.Command HDEL = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HDEL);
  public static final io.vertx.reactivex.redis.client.Command HELLO = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HELLO);
  public static final io.vertx.reactivex.redis.client.Command HEXISTS = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HEXISTS);
  public static final io.vertx.reactivex.redis.client.Command HGET = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HGET);
  public static final io.vertx.reactivex.redis.client.Command HGETALL = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HGETALL);
  public static final io.vertx.reactivex.redis.client.Command HINCRBY = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HINCRBY);
  public static final io.vertx.reactivex.redis.client.Command HINCRBYFLOAT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HINCRBYFLOAT);
  public static final io.vertx.reactivex.redis.client.Command HKEYS = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HKEYS);
  public static final io.vertx.reactivex.redis.client.Command HLEN = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HLEN);
  public static final io.vertx.reactivex.redis.client.Command HMGET = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HMGET);
  public static final io.vertx.reactivex.redis.client.Command HMSET = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HMSET);
  public static final io.vertx.reactivex.redis.client.Command HOST = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HOST);
  public static final io.vertx.reactivex.redis.client.Command HSCAN = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HSCAN);
  public static final io.vertx.reactivex.redis.client.Command HSET = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HSET);
  public static final io.vertx.reactivex.redis.client.Command HSETNX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HSETNX);
  public static final io.vertx.reactivex.redis.client.Command HSTRLEN = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HSTRLEN);
  public static final io.vertx.reactivex.redis.client.Command HVALS = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.HVALS);
  public static final io.vertx.reactivex.redis.client.Command INCR = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.INCR);
  public static final io.vertx.reactivex.redis.client.Command INCRBY = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.INCRBY);
  public static final io.vertx.reactivex.redis.client.Command INCRBYFLOAT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.INCRBYFLOAT);
  public static final io.vertx.reactivex.redis.client.Command INFO = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.INFO);
  public static final io.vertx.reactivex.redis.client.Command KEYS = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.KEYS);
  public static final io.vertx.reactivex.redis.client.Command LASTSAVE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LASTSAVE);
  public static final io.vertx.reactivex.redis.client.Command LATENCY = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LATENCY);
  public static final io.vertx.reactivex.redis.client.Command LINDEX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LINDEX);
  public static final io.vertx.reactivex.redis.client.Command LINSERT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LINSERT);
  public static final io.vertx.reactivex.redis.client.Command LLEN = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LLEN);
  public static final io.vertx.reactivex.redis.client.Command LOLWUT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LOLWUT);
  public static final io.vertx.reactivex.redis.client.Command LPOP = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LPOP);
  public static final io.vertx.reactivex.redis.client.Command LPUSH = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LPUSH);
  public static final io.vertx.reactivex.redis.client.Command LPUSHX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LPUSHX);
  public static final io.vertx.reactivex.redis.client.Command LRANGE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LRANGE);
  public static final io.vertx.reactivex.redis.client.Command LREM = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LREM);
  public static final io.vertx.reactivex.redis.client.Command LSET = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LSET);
  public static final io.vertx.reactivex.redis.client.Command LTRIM = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.LTRIM);
  public static final io.vertx.reactivex.redis.client.Command MEMORY = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MEMORY);
  public static final io.vertx.reactivex.redis.client.Command MGET = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MGET);
  public static final io.vertx.reactivex.redis.client.Command MIGRATE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MIGRATE);
  public static final io.vertx.reactivex.redis.client.Command MODULE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MODULE);
  public static final io.vertx.reactivex.redis.client.Command MONITOR = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MONITOR);
  public static final io.vertx.reactivex.redis.client.Command MOVE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MOVE);
  public static final io.vertx.reactivex.redis.client.Command MSET = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MSET);
  public static final io.vertx.reactivex.redis.client.Command MSETNX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MSETNX);
  public static final io.vertx.reactivex.redis.client.Command MULTI = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.MULTI);
  public static final io.vertx.reactivex.redis.client.Command OBJECT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.OBJECT);
  public static final io.vertx.reactivex.redis.client.Command PERSIST = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PERSIST);
  public static final io.vertx.reactivex.redis.client.Command PEXPIRE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PEXPIRE);
  public static final io.vertx.reactivex.redis.client.Command PEXPIREAT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PEXPIREAT);
  public static final io.vertx.reactivex.redis.client.Command PFADD = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFADD);
  public static final io.vertx.reactivex.redis.client.Command PFCOUNT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFCOUNT);
  public static final io.vertx.reactivex.redis.client.Command PFDEBUG = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFDEBUG);
  public static final io.vertx.reactivex.redis.client.Command PFMERGE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFMERGE);
  public static final io.vertx.reactivex.redis.client.Command PFSELFTEST = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PFSELFTEST);
  public static final io.vertx.reactivex.redis.client.Command PING = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PING);
  public static final io.vertx.reactivex.redis.client.Command POST = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.POST);
  public static final io.vertx.reactivex.redis.client.Command PSETEX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PSETEX);
  public static final io.vertx.reactivex.redis.client.Command PSUBSCRIBE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PSUBSCRIBE);
  public static final io.vertx.reactivex.redis.client.Command PSYNC = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PSYNC);
  public static final io.vertx.reactivex.redis.client.Command PTTL = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PTTL);
  public static final io.vertx.reactivex.redis.client.Command PUBLISH = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PUBLISH);
  public static final io.vertx.reactivex.redis.client.Command PUBSUB = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PUBSUB);
  public static final io.vertx.reactivex.redis.client.Command PUNSUBSCRIBE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.PUNSUBSCRIBE);
  public static final io.vertx.reactivex.redis.client.Command RANDOMKEY = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RANDOMKEY);
  public static final io.vertx.reactivex.redis.client.Command READONLY = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.READONLY);
  public static final io.vertx.reactivex.redis.client.Command READWRITE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.READWRITE);
  public static final io.vertx.reactivex.redis.client.Command RENAME = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RENAME);
  public static final io.vertx.reactivex.redis.client.Command RENAMENX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RENAMENX);
  public static final io.vertx.reactivex.redis.client.Command REPLCONF = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.REPLCONF);
  public static final io.vertx.reactivex.redis.client.Command REPLICAOF = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.REPLICAOF);
  public static final io.vertx.reactivex.redis.client.Command RESTORE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RESTORE);
  public static final io.vertx.reactivex.redis.client.Command RESTORE_ASKING = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RESTORE_ASKING);
  public static final io.vertx.reactivex.redis.client.Command ROLE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ROLE);
  public static final io.vertx.reactivex.redis.client.Command RPOP = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RPOP);
  public static final io.vertx.reactivex.redis.client.Command RPOPLPUSH = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RPOPLPUSH);
  public static final io.vertx.reactivex.redis.client.Command RPUSH = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RPUSH);
  public static final io.vertx.reactivex.redis.client.Command RPUSHX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.RPUSHX);
  public static final io.vertx.reactivex.redis.client.Command SADD = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SADD);
  public static final io.vertx.reactivex.redis.client.Command SAVE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SAVE);
  public static final io.vertx.reactivex.redis.client.Command SCAN = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SCAN);
  public static final io.vertx.reactivex.redis.client.Command SCARD = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SCARD);
  public static final io.vertx.reactivex.redis.client.Command SCRIPT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SCRIPT);
  public static final io.vertx.reactivex.redis.client.Command SDIFF = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SDIFF);
  public static final io.vertx.reactivex.redis.client.Command SDIFFSTORE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SDIFFSTORE);
  public static final io.vertx.reactivex.redis.client.Command SELECT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SELECT);
  public static final io.vertx.reactivex.redis.client.Command SET = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SET);
  public static final io.vertx.reactivex.redis.client.Command SETBIT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SETBIT);
  public static final io.vertx.reactivex.redis.client.Command SETEX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SETEX);
  public static final io.vertx.reactivex.redis.client.Command SETNX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SETNX);
  public static final io.vertx.reactivex.redis.client.Command SETRANGE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SETRANGE);
  public static final io.vertx.reactivex.redis.client.Command SHUTDOWN = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SHUTDOWN);
  public static final io.vertx.reactivex.redis.client.Command SINTER = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SINTER);
  public static final io.vertx.reactivex.redis.client.Command SINTERSTORE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SINTERSTORE);
  public static final io.vertx.reactivex.redis.client.Command SISMEMBER = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SISMEMBER);
  public static final io.vertx.reactivex.redis.client.Command SLAVEOF = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SLAVEOF);
  public static final io.vertx.reactivex.redis.client.Command SLOWLOG = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SLOWLOG);
  public static final io.vertx.reactivex.redis.client.Command SMEMBERS = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SMEMBERS);
  public static final io.vertx.reactivex.redis.client.Command SMOVE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SMOVE);
  public static final io.vertx.reactivex.redis.client.Command SORT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SORT);
  public static final io.vertx.reactivex.redis.client.Command SPOP = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SPOP);
  public static final io.vertx.reactivex.redis.client.Command SRANDMEMBER = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SRANDMEMBER);
  public static final io.vertx.reactivex.redis.client.Command SREM = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SREM);
  public static final io.vertx.reactivex.redis.client.Command SSCAN = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SSCAN);
  public static final io.vertx.reactivex.redis.client.Command STRALGO = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.STRALGO);
  public static final io.vertx.reactivex.redis.client.Command STRLEN = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.STRLEN);
  public static final io.vertx.reactivex.redis.client.Command SUBSCRIBE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUBSCRIBE);
  public static final io.vertx.reactivex.redis.client.Command SUBSTR = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUBSTR);
  public static final io.vertx.reactivex.redis.client.Command SUNION = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUNION);
  public static final io.vertx.reactivex.redis.client.Command SUNIONSTORE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SUNIONSTORE);
  public static final io.vertx.reactivex.redis.client.Command SWAPDB = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SWAPDB);
  public static final io.vertx.reactivex.redis.client.Command SYNC = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SYNC);
  public static final io.vertx.reactivex.redis.client.Command TIME = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TIME);
  public static final io.vertx.reactivex.redis.client.Command TOUCH = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TOUCH);
  public static final io.vertx.reactivex.redis.client.Command TTL = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TTL);
  public static final io.vertx.reactivex.redis.client.Command TYPE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.TYPE);
  public static final io.vertx.reactivex.redis.client.Command UNLINK = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.UNLINK);
  public static final io.vertx.reactivex.redis.client.Command UNSUBSCRIBE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.UNSUBSCRIBE);
  public static final io.vertx.reactivex.redis.client.Command UNWATCH = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.UNWATCH);
  public static final io.vertx.reactivex.redis.client.Command WAIT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.WAIT);
  public static final io.vertx.reactivex.redis.client.Command WATCH = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.WATCH);
  public static final io.vertx.reactivex.redis.client.Command XACK = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XACK);
  public static final io.vertx.reactivex.redis.client.Command XADD = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XADD);
  public static final io.vertx.reactivex.redis.client.Command XCLAIM = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XCLAIM);
  public static final io.vertx.reactivex.redis.client.Command XDEL = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XDEL);
  public static final io.vertx.reactivex.redis.client.Command XGROUP = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XGROUP);
  public static final io.vertx.reactivex.redis.client.Command XINFO = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XINFO);
  public static final io.vertx.reactivex.redis.client.Command XLEN = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XLEN);
  public static final io.vertx.reactivex.redis.client.Command XPENDING = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XPENDING);
  public static final io.vertx.reactivex.redis.client.Command XRANGE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XRANGE);
  public static final io.vertx.reactivex.redis.client.Command XREAD = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XREAD);
  public static final io.vertx.reactivex.redis.client.Command XREADGROUP = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XREADGROUP);
  public static final io.vertx.reactivex.redis.client.Command XREVRANGE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XREVRANGE);
  public static final io.vertx.reactivex.redis.client.Command XSETID = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XSETID);
  public static final io.vertx.reactivex.redis.client.Command XTRIM = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.XTRIM);
  public static final io.vertx.reactivex.redis.client.Command ZADD = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZADD);
  public static final io.vertx.reactivex.redis.client.Command ZCARD = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZCARD);
  public static final io.vertx.reactivex.redis.client.Command ZCOUNT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZCOUNT);
  public static final io.vertx.reactivex.redis.client.Command ZINCRBY = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZINCRBY);
  public static final io.vertx.reactivex.redis.client.Command ZINTERSTORE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZINTERSTORE);
  public static final io.vertx.reactivex.redis.client.Command ZLEXCOUNT = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZLEXCOUNT);
  public static final io.vertx.reactivex.redis.client.Command ZPOPMAX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZPOPMAX);
  public static final io.vertx.reactivex.redis.client.Command ZPOPMIN = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZPOPMIN);
  public static final io.vertx.reactivex.redis.client.Command ZRANGE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANGE);
  public static final io.vertx.reactivex.redis.client.Command ZRANGEBYLEX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANGEBYLEX);
  public static final io.vertx.reactivex.redis.client.Command ZRANGEBYSCORE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANGEBYSCORE);
  public static final io.vertx.reactivex.redis.client.Command ZRANK = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZRANK);
  public static final io.vertx.reactivex.redis.client.Command ZREM = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREM);
  public static final io.vertx.reactivex.redis.client.Command ZREMRANGEBYLEX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREMRANGEBYLEX);
  public static final io.vertx.reactivex.redis.client.Command ZREMRANGEBYRANK = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREMRANGEBYRANK);
  public static final io.vertx.reactivex.redis.client.Command ZREMRANGEBYSCORE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREMRANGEBYSCORE);
  public static final io.vertx.reactivex.redis.client.Command ZREVRANGE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREVRANGE);
  public static final io.vertx.reactivex.redis.client.Command ZREVRANGEBYLEX = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREVRANGEBYLEX);
  public static final io.vertx.reactivex.redis.client.Command ZREVRANGEBYSCORE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREVRANGEBYSCORE);
  public static final io.vertx.reactivex.redis.client.Command ZREVRANK = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZREVRANK);
  public static final io.vertx.reactivex.redis.client.Command ZSCAN = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZSCAN);
  public static final io.vertx.reactivex.redis.client.Command ZSCORE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZSCORE);
  public static final io.vertx.reactivex.redis.client.Command ZUNIONSTORE = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.ZUNIONSTORE);
  public static final io.vertx.reactivex.redis.client.Command SENTINEL = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)io.vertx.redis.client.Command.SENTINEL);
  public static Command newInstance(io.vertx.redis.client.Command arg) {
    return arg != null ? new Command(arg) : null;
  }

}
