/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.servicediscovery.types;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *  for HTTP endpoint (REST api).
 * Consumers receive a HTTP client configured with the host and port of the endpoint.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.HttpEndpoint original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.servicediscovery.types.HttpEndpoint.class)
public class HttpEndpoint {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpEndpoint that = (HttpEndpoint) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpEndpoint> __TYPE_ARG = new TypeArg<>(    obj -> new HttpEndpoint((io.vertx.servicediscovery.types.HttpEndpoint) obj),
    HttpEndpoint::getDelegate
  );

  private final io.vertx.servicediscovery.types.HttpEndpoint delegate;
  
  public HttpEndpoint(io.vertx.servicediscovery.types.HttpEndpoint delegate) {
    this.delegate = delegate;
  }

  public HttpEndpoint(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.HttpEndpoint)delegate;
  }

  public io.vertx.servicediscovery.types.HttpEndpoint getDelegate() {
    return delegate;
  }

  /**
   * Convenient method to create a record for a HTTP endpoint.
   * @param name the service name
   * @param host the host (IP or DNS name), it must be the _public_ IP / name
   * @param port the port, it must be the _public_ port
   * @param root the path of the service, "/" if not set
   * @param metadata additional metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, String host, int port, String root, JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.HttpEndpoint.createRecord(name, host, port, root, metadata);
    return ret;
  }

  /**
   * Same as {@link io.vertx.reactivex.servicediscovery.types.HttpEndpoint#createRecord} but let you configure whether or not the
   * service is using <code>https</code>.
   * @param name the service name
   * @param ssl whether or not the service is using HTTPS
   * @param host the host (IP or DNS name), it must be the _public_ IP / name
   * @param port the port, it must be the _public_ port
   * @param root the path of the service, "/" if not set
   * @param metadata additional metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, boolean ssl, String host, int port, String root, JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.HttpEndpoint.createRecord(name, ssl, host, port, root, metadata);
    return ret;
  }

  /**
   * Same as {@link io.vertx.reactivex.servicediscovery.types.HttpEndpoint#createRecord} but without metadata.
   * @param name the service name
   * @param host the host, must be public
   * @param port the port
   * @param root the root, if not set "/" is used
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, String host, int port, String root) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.HttpEndpoint.createRecord(name, host, port, root);
    return ret;
  }

  /**
   * Same as {@link io.vertx.reactivex.servicediscovery.types.HttpEndpoint#createRecord} but without metadata, using the port 80
   * and using "/" as root.
   * @param name the name
   * @param host the host
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, String host) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.HttpEndpoint.createRecord(name, host);
    return ret;
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param resultHandler The result handler
   */
  public static void getClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, Handler<AsyncResult<io.vertx.reactivex.core.http.HttpClient>> resultHandler) { 
    io.vertx.servicediscovery.types.HttpEndpoint.getClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.core.http.HttpClient>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.http.HttpClient.newInstance((io.vertx.core.http.HttpClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   */
  public static void getClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter) {
    getClient(discovery, filter, ar -> { });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.core.http.HttpClient> rxGetClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return AsyncResultSingle.toSingle($handler -> {
      getClient(discovery, filter, $handler);
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param resultHandler The result handler
   */
  public static void getWebClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, Handler<AsyncResult<io.vertx.reactivex.ext.web.client.WebClient>> resultHandler) { 
    io.vertx.servicediscovery.types.HttpEndpoint.getWebClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.ext.web.client.WebClient>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.WebClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   */
  public static void getWebClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter) {
    getWebClient(discovery, filter, ar -> { });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.web.client.WebClient> rxGetWebClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return AsyncResultSingle.toSingle($handler -> {
      getWebClient(discovery, filter, $handler);
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param conf the configuration of the client
   * @param resultHandler The result handler
   */
  public static void getClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject conf, Handler<AsyncResult<io.vertx.reactivex.core.http.HttpClient>> resultHandler) { 
    io.vertx.servicediscovery.types.HttpEndpoint.getClient(discovery.getDelegate(), filter, conf, new Handler<AsyncResult<io.vertx.core.http.HttpClient>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.http.HttpClient.newInstance((io.vertx.core.http.HttpClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param conf the configuration of the client
   */
  public static void getClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject conf) {
    getClient(discovery, filter, conf, ar -> { });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param conf the configuration of the client
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.core.http.HttpClient> rxGetClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject conf) { 
    return AsyncResultSingle.toSingle($handler -> {
      getClient(discovery, filter, conf, $handler);
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param conf the configuration of the client
   * @param resultHandler The result handler
   */
  public static void getWebClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject conf, Handler<AsyncResult<io.vertx.reactivex.ext.web.client.WebClient>> resultHandler) { 
    io.vertx.servicediscovery.types.HttpEndpoint.getWebClient(discovery.getDelegate(), filter, conf, new Handler<AsyncResult<io.vertx.ext.web.client.WebClient>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.WebClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param conf the configuration of the client
   */
  public static void getWebClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject conf) {
    getWebClient(discovery, filter, conf, ar -> { });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param conf the configuration of the client
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.web.client.WebClient> rxGetWebClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject conf) { 
    return AsyncResultSingle.toSingle($handler -> {
      getWebClient(discovery, filter, conf, $handler);
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param resultHandler The result handler
   */
  public static void getClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, Handler<AsyncResult<io.vertx.reactivex.core.http.HttpClient>> resultHandler) { 
    io.vertx.servicediscovery.types.HttpEndpoint.getClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.core.http.HttpClient>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.http.HttpClient.newInstance((io.vertx.core.http.HttpClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter
   */
  public static void getClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) {
    getClient(discovery, filter, ar -> { });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.core.http.HttpClient> rxGetClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return AsyncResultSingle.toSingle($handler -> {
      getClient(discovery, filter, $handler);
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param resultHandler The result handler
   */
  public static void getWebClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, Handler<AsyncResult<io.vertx.reactivex.ext.web.client.WebClient>> resultHandler) { 
    io.vertx.servicediscovery.types.HttpEndpoint.getWebClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.ext.web.client.WebClient>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.WebClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter
   */
  public static void getWebClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) {
    getWebClient(discovery, filter, ar -> { });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.web.client.WebClient> rxGetWebClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return AsyncResultSingle.toSingle($handler -> {
      getWebClient(discovery, filter, $handler);
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param conf the configuration of the client
   * @param resultHandler The result handler
   */
  public static void getClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject conf, Handler<AsyncResult<io.vertx.reactivex.core.http.HttpClient>> resultHandler) { 
    io.vertx.servicediscovery.types.HttpEndpoint.getClient(discovery.getDelegate(), filter, conf, new Handler<AsyncResult<io.vertx.core.http.HttpClient>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.http.HttpClient.newInstance((io.vertx.core.http.HttpClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param conf the configuration of the client
   */
  public static void getClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject conf) {
    getClient(discovery, filter, conf, ar -> { });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param conf the configuration of the client
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.core.http.HttpClient> rxGetClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject conf) { 
    return AsyncResultSingle.toSingle($handler -> {
      getClient(discovery, filter, conf, $handler);
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param conf the configuration of the client
   * @param resultHandler The result handler
   */
  public static void getWebClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject conf, Handler<AsyncResult<io.vertx.reactivex.ext.web.client.WebClient>> resultHandler) { 
    io.vertx.servicediscovery.types.HttpEndpoint.getWebClient(discovery.getDelegate(), filter, conf, new Handler<AsyncResult<io.vertx.ext.web.client.WebClient>>() {
      public void handle(AsyncResult<io.vertx.ext.web.client.WebClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param conf the configuration of the client
   */
  public static void getWebClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject conf) {
    getWebClient(discovery, filter, conf, ar -> { });
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param conf the configuration of the client
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.web.client.WebClient> rxGetWebClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject conf) { 
    return AsyncResultSingle.toSingle($handler -> {
      getWebClient(discovery, filter, conf, $handler);
    });
  }

  /**
   * Unknown type.
   */
  public static final String UNKNOWN = io.vertx.servicediscovery.types.HttpEndpoint.UNKNOWN;
  public static final String TYPE = io.vertx.servicediscovery.types.HttpEndpoint.TYPE;
  public static HttpEndpoint newInstance(io.vertx.servicediscovery.types.HttpEndpoint arg) {
    return arg != null ? new HttpEndpoint(arg) : null;
  }

}
