/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient.templates;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Map an arbitrary <code>T</code> object to a .
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.templates.TupleMapper original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.templates.TupleMapper.class)
public class TupleMapper<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TupleMapper that = (TupleMapper) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TupleMapper> __TYPE_ARG = new TypeArg<>(    obj -> new TupleMapper((io.vertx.sqlclient.templates.TupleMapper) obj),
    TupleMapper::getDelegate
  );

  private final io.vertx.sqlclient.templates.TupleMapper<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public TupleMapper(io.vertx.sqlclient.templates.TupleMapper delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public TupleMapper(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.sqlclient.templates.TupleMapper)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.sqlclient.templates.TupleMapper getDelegate() {
    return delegate;
  }


  /**
   * Create a mapper that associates a parameters object to a map of named parameters to
   * their respective value.
   * @param fn the function turning a parameters object into a map
   * @return the mapper
   */
  public static <T> io.vertx.reactivex.sqlclient.templates.TupleMapper<T> mapper(Function<T, java.util.Map<String, java.lang.Object>> fn) { 
    io.vertx.reactivex.sqlclient.templates.TupleMapper<T> ret = io.vertx.reactivex.sqlclient.templates.TupleMapper.newInstance((io.vertx.sqlclient.templates.TupleMapper)io.vertx.sqlclient.templates.TupleMapper.mapper(fn), TypeArg.unknown());
    return ret;
  }

  /**
   * Map a  to a .
   * @return 
   */
  public static io.vertx.reactivex.sqlclient.templates.TupleMapper<JsonObject> jsonObject() { 
    io.vertx.reactivex.sqlclient.templates.TupleMapper<JsonObject> ret = io.vertx.reactivex.sqlclient.templates.TupleMapper.newInstance((io.vertx.sqlclient.templates.TupleMapper)io.vertx.sqlclient.templates.TupleMapper.jsonObject(), TypeArg.unknown());
    return ret;
  }

  /**
   * The internal mapper contract that builds a tuple.
   * @param mapping associates an index to template parameter name
   * @param size the tuple size
   * @param params the parameters object
   * @return the tuple
   */
  public io.vertx.reactivex.sqlclient.Tuple map(Function<Integer, String> mapping, int size, T params) { 
    io.vertx.reactivex.sqlclient.Tuple ret = io.vertx.reactivex.sqlclient.Tuple.newInstance((io.vertx.sqlclient.Tuple)delegate.map(mapping, size, __typeArg_0.<T>unwrap(params)));
    return ret;
  }

  public static <T> TupleMapper<T> newInstance(io.vertx.sqlclient.templates.TupleMapper arg) {
    return arg != null ? new TupleMapper<T>(arg) : null;
  }

  public static <T> TupleMapper<T> newInstance(io.vertx.sqlclient.templates.TupleMapper arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new TupleMapper<T>(arg, __typeArg_T) : null;
  }

}
