/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.cassandra;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * It is like {@link com.datastax.oss.driver.api.core.cql.AsyncResultSet}, but adapted for Vert.x.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.ResultSet original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.cassandra.ResultSet.class)
public class ResultSet {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResultSet that = (ResultSet) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ResultSet> __TYPE_ARG = new TypeArg<>(    obj -> new ResultSet((io.vertx.cassandra.ResultSet) obj),
    ResultSet::getDelegate
  );

  private final io.vertx.cassandra.ResultSet delegate;
  
  public ResultSet(io.vertx.cassandra.ResultSet delegate) {
    this.delegate = delegate;
  }

  public ResultSet(Object delegate) {
    this.delegate = (io.vertx.cassandra.ResultSet)delegate;
  }

  public io.vertx.cassandra.ResultSet getDelegate() {
    return delegate;
  }


  /**
   * @return 
   */
  public int remaining() { 
    int ret = delegate.remaining();
    return ret;
  }

  /**
   * @return 
   */
  public boolean hasMorePages() { 
    boolean ret = delegate.hasMorePages();
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.ResultSet#fetchNextPage} but with a direct callback.
   * @param handler 
   */
  public void fetchNextPage(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.cassandra.ResultSet>> handler) { 
    delegate.fetchNextPage(new Handler<AsyncResult<io.vertx.cassandra.ResultSet>>() {
      public void handle(AsyncResult<io.vertx.cassandra.ResultSet> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.ResultSet#fetchNextPage} but with a direct callback.
   */
  public void fetchNextPage() {
    fetchNextPage(ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.ResultSet#fetchNextPage} but with a direct callback.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.cassandra.ResultSet> rxFetchNextPage() { 
    return AsyncResultSingle.toSingle($handler -> {
      fetchNextPage($handler);
    });
  }

  /**
   * @return 
   */
  public boolean wasApplied() { 
    boolean ret = delegate.wasApplied();
    return ret;
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#fetchNextPage} or .
   * This may lead to unexpected result.
   * @param handler handler called when all the rows is fetched
   * @return 
   */
  public io.vertx.reactivex.cassandra.ResultSet all(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<com.datastax.oss.driver.api.core.cql.Row>>> handler) { 
    delegate.all(handler);
    return this;
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#fetchNextPage} or .
   * This may lead to unexpected result.
   * @return 
   */
  public io.vertx.reactivex.cassandra.ResultSet all() {
    return 
all(ar -> { });
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#fetchNextPage} or .
   * This may lead to unexpected result.
   * @return 
   */
  public io.reactivex.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> rxAll() { 
    return AsyncResultSingle.toSingle($handler -> {
      all($handler);
    });
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ColumnDefinitions getColumnDefinitions() { 
    com.datastax.oss.driver.api.core.cql.ColumnDefinitions ret = delegate.getColumnDefinitions();
    return ret;
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ExecutionInfo getExecutionInfo() { 
    com.datastax.oss.driver.api.core.cql.ExecutionInfo ret = delegate.getExecutionInfo();
    return ret;
  }

  /**
   * @return 
   */
  public java.lang.Iterable<com.datastax.oss.driver.api.core.cql.Row> currentPage() { 
    java.lang.Iterable<com.datastax.oss.driver.api.core.cql.Row> ret = delegate.currentPage();
    return ret;
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.Row one() { 
    com.datastax.oss.driver.api.core.cql.Row ret = delegate.one();
    return ret;
  }

  public static ResultSet newInstance(io.vertx.cassandra.ResultSet arg) {
    return arg != null ? new ResultSet(arg) : null;
  }

}
