/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.circuitbreaker;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Vert.x web handler to expose the circuit breaker to the Hystrix dasbboard. The handler listens to the circuit
 * breaker notifications sent on the event bus.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.circuitbreaker.HystrixMetricHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.circuitbreaker.HystrixMetricHandler.class)
public class HystrixMetricHandler implements Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HystrixMetricHandler that = (HystrixMetricHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HystrixMetricHandler> __TYPE_ARG = new TypeArg<>(    obj -> new HystrixMetricHandler((io.vertx.circuitbreaker.HystrixMetricHandler) obj),
    HystrixMetricHandler::getDelegate
  );

  private final io.vertx.circuitbreaker.HystrixMetricHandler delegate;
  
  public HystrixMetricHandler(io.vertx.circuitbreaker.HystrixMetricHandler delegate) {
    this.delegate = delegate;
  }

  public HystrixMetricHandler(Object delegate) {
    this.delegate = (io.vertx.circuitbreaker.HystrixMetricHandler)delegate;
  }

  public io.vertx.circuitbreaker.HystrixMetricHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Creates the handler, using the default notification address.
   * @param vertx the Vert.x instance
   * @return the handler
   */
  public static io.vertx.reactivex.circuitbreaker.HystrixMetricHandler create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.circuitbreaker.HystrixMetricHandler ret = io.vertx.reactivex.circuitbreaker.HystrixMetricHandler.newInstance((io.vertx.circuitbreaker.HystrixMetricHandler)io.vertx.circuitbreaker.HystrixMetricHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Creates the handler.
   * @param vertx the Vert.x instance
   * @param address the address to listen on the event bus
   * @return the handler
   */
  public static io.vertx.reactivex.circuitbreaker.HystrixMetricHandler create(io.vertx.reactivex.core.Vertx vertx, java.lang.String address) { 
    io.vertx.reactivex.circuitbreaker.HystrixMetricHandler ret = io.vertx.reactivex.circuitbreaker.HystrixMetricHandler.newInstance((io.vertx.circuitbreaker.HystrixMetricHandler)io.vertx.circuitbreaker.HystrixMetricHandler.create(vertx.getDelegate(), address));
    return ret;
  }

  public static HystrixMetricHandler newInstance(io.vertx.circuitbreaker.HystrixMetricHandler arg) {
    return arg != null ? new HystrixMetricHandler(arg) : null;
  }

}
