/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.net;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a TCP server
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.NetServer.class)
public class NetServer implements io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetServer that = (NetServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<NetServer> __TYPE_ARG = new TypeArg<>(    obj -> new NetServer((io.vertx.core.net.NetServer) obj),
    NetServer::getDelegate
  );

  private final io.vertx.core.net.NetServer delegate;
  
  public NetServer(io.vertx.core.net.NetServer delegate) {
    this.delegate = delegate;
  }

  public NetServer(Object delegate) {
    this.delegate = (io.vertx.core.net.NetServer)delegate;
  }

  public io.vertx.core.net.NetServer getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.net.NetSocket> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.net.NetSocket>(o1 -> io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return the connect stream for this server. The server can only have at most one handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.reactivex.core.net.NetSocket} and passes it to the
   * connect stream .
   * @return the connect stream
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.net.NetSocket> connectStream() { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.net.NetSocket> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.connectStream(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Supply a connect handler for this server. The server can only have at most one connect handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.reactivex.core.net.NetSocket} and passes it to the
   * connect handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer connectHandler(io.vertx.core.Handler<io.vertx.reactivex.core.net.NetSocket> handler) { 
    io.vertx.reactivex.core.net.NetServer ret = io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)delegate.connectHandler(new Handler<io.vertx.core.net.NetSocket>() {
      public void handle(io.vertx.core.net.NetSocket event) {
        handler.handle(io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event));
      }
    }));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.core.net.NetServer>> listenHandler) { 
    delegate.listen(new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen() {
    return 
listen(ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetServer> rxListen() { 
    return AsyncResultSingle.toSingle($handler -> {
      listen($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(int port, java.lang.String host, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(int port, java.lang.String host) {
    return 
listen(port, host, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetServer> rxListen(int port, java.lang.String host) { 
    return AsyncResultSingle.toSingle($handler -> {
      listen(port, host, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(int port, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(int port) {
    return 
listen(port, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetServer> rxListen(int port) { 
    return AsyncResultSingle.toSingle($handler -> {
      listen(port, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(io.vertx.reactivex.core.net.SocketAddress localAddress, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.core.net.NetServer>> listenHandler) { 
    delegate.listen(localAddress.getDelegate(), new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer listen(io.vertx.reactivex.core.net.SocketAddress localAddress) {
    return 
listen(localAddress, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetServer> rxListen(io.vertx.reactivex.core.net.SocketAddress localAddress) { 
    return AsyncResultSingle.toSingle($handler -> {
      listen(localAddress, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @param completionHandler the handler
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   */
  public void close() {
    close(ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close($handler);
    });
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  public static NetServer newInstance(io.vertx.core.net.NetServer arg) {
    return arg != null ? new NetServer(arg) : null;
  }

}
