/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Chain several authentication providers as if they were one. This is useful for cases where one want to authenticate across
 * several providers, for example, database and fallback to passwd file.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.ChainAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.ChainAuth.class)
public class ChainAuth extends io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChainAuth that = (ChainAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ChainAuth> __TYPE_ARG = new TypeArg<>(    obj -> new ChainAuth((io.vertx.ext.auth.ChainAuth) obj),
    ChainAuth::getDelegate
  );

  private final io.vertx.ext.auth.ChainAuth delegate;
  
  public ChainAuth(io.vertx.ext.auth.ChainAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public ChainAuth(Object delegate) {
    super((io.vertx.ext.auth.ChainAuth)delegate);
    this.delegate = (io.vertx.ext.auth.ChainAuth)delegate;
  }

  public io.vertx.ext.auth.ChainAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a Chainable Auth Provider auth provider
   * @return the auth provider
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.auth.ChainAuth create() { 
    io.vertx.reactivex.ext.auth.ChainAuth ret = io.vertx.reactivex.ext.auth.ChainAuth.newInstance((io.vertx.ext.auth.ChainAuth)io.vertx.ext.auth.ChainAuth.create());
    return ret;
  }

  /**
   * Create a Chainable Auth Provider auth provider that will resolve if all auth providers are successful.
   * @return the auth provider
   */
  public static io.vertx.reactivex.ext.auth.ChainAuth all() { 
    io.vertx.reactivex.ext.auth.ChainAuth ret = io.vertx.reactivex.ext.auth.ChainAuth.newInstance((io.vertx.ext.auth.ChainAuth)io.vertx.ext.auth.ChainAuth.all());
    return ret;
  }

  /**
   * Create a Chainable Auth Provider auth provider that will resolve on the first success.
   * @return the auth provider
   */
  public static io.vertx.reactivex.ext.auth.ChainAuth any() { 
    io.vertx.reactivex.ext.auth.ChainAuth ret = io.vertx.reactivex.ext.auth.ChainAuth.newInstance((io.vertx.ext.auth.ChainAuth)io.vertx.ext.auth.ChainAuth.any());
    return ret;
  }

  /**
   * Appends a auth provider to the chain.
   * @param other auth provider
   * @return self
   */
  public io.vertx.reactivex.ext.auth.ChainAuth add(io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider other) { 
    delegate.add(other.getDelegate());
    return this;
  }

  public static ChainAuth newInstance(io.vertx.ext.auth.ChainAuth arg) {
    return arg != null ? new ChainAuth(arg) : null;
  }

}
