/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.mongo;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An extension of AuthProvider which is using  as store
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.mongo.MongoAuthentication original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.mongo.MongoAuthentication.class)
public class MongoAuthentication extends io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoAuthentication that = (MongoAuthentication) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoAuthentication> __TYPE_ARG = new TypeArg<>(    obj -> new MongoAuthentication((io.vertx.ext.auth.mongo.MongoAuthentication) obj),
    MongoAuthentication::getDelegate
  );

  private final io.vertx.ext.auth.mongo.MongoAuthentication delegate;
  
  public MongoAuthentication(io.vertx.ext.auth.mongo.MongoAuthentication delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MongoAuthentication(Object delegate) {
    super((io.vertx.ext.auth.mongo.MongoAuthentication)delegate);
    this.delegate = (io.vertx.ext.auth.mongo.MongoAuthentication)delegate;
  }

  public io.vertx.ext.auth.mongo.MongoAuthentication getDelegate() {
    return delegate;
  }

  /**
   * Creates an instance of MongoAuth by using the given  and configuration object.
   * @param mongoClient an instance of  to be used for data storage and retrival
   * @param options the configuration object for the current instance.
   * @return the created instance of {@link io.vertx.reactivex.ext.auth.mongo.MongoAuthentication}
   */
  public static io.vertx.reactivex.ext.auth.mongo.MongoAuthentication create(io.vertx.reactivex.ext.mongo.MongoClient mongoClient, io.vertx.ext.auth.mongo.MongoAuthenticationOptions options) { 
    io.vertx.reactivex.ext.auth.mongo.MongoAuthentication ret = io.vertx.reactivex.ext.auth.mongo.MongoAuthentication.newInstance((io.vertx.ext.auth.mongo.MongoAuthentication)io.vertx.ext.auth.mongo.MongoAuthentication.create(mongoClient.getDelegate(), options));
    return ret;
  }

  public static io.vertx.reactivex.ext.auth.mongo.MongoAuthentication create(io.vertx.reactivex.ext.mongo.MongoClient mongoClient, io.vertx.reactivex.ext.auth.mongo.HashStrategy hashStrategy, io.vertx.ext.auth.mongo.MongoAuthenticationOptions options) { 
    io.vertx.reactivex.ext.auth.mongo.MongoAuthentication ret = io.vertx.reactivex.ext.auth.mongo.MongoAuthentication.newInstance((io.vertx.ext.auth.mongo.MongoAuthentication)io.vertx.ext.auth.mongo.MongoAuthentication.create(mongoClient.getDelegate(), hashStrategy.getDelegate(), options));
    return ret;
  }

  /**
   * Hashes a password to be stored.
   *
   * See: {@link io.vertx.reactivex.ext.auth.HashingStrategy#hash}
   * @param id 
   * @param params 
   * @param salt 
   * @param password 
   * @return 
   */
  public java.lang.String hash(java.lang.String id, java.util.Map<java.lang.String,java.lang.String> params, java.lang.String salt, java.lang.String password) { 
    java.lang.String ret = delegate.hash(id, params, salt, password);
    return ret;
  }

  /**
   * Hashes a password to be stored.
   *
   * See: {@link io.vertx.reactivex.ext.auth.HashingStrategy#hash}
   * @param id 
   * @param salt 
   * @param password 
   * @return 
   */
  public java.lang.String hash(java.lang.String id, java.lang.String salt, java.lang.String password) { 
    java.lang.String ret = delegate.hash(id, salt, password);
    return ret;
  }

  /**
   * The default name of the collection to be used
   */
  public static final java.lang.String DEFAULT_COLLECTION_NAME = io.vertx.ext.auth.mongo.MongoAuthentication.DEFAULT_COLLECTION_NAME;
  /**
   * The default name of the property for the username, like it is stored in mongodb
   */
  public static final java.lang.String DEFAULT_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuthentication.DEFAULT_USERNAME_FIELD;
  /**
   * The default name of the property for the password, like it is stored in mongodb
   */
  public static final java.lang.String DEFAULT_PASSWORD_FIELD = io.vertx.ext.auth.mongo.MongoAuthentication.DEFAULT_PASSWORD_FIELD;
  /**
   * The default name of the property for the username, like it is transported in credentials by method
   * {@link io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider#authenticate}
   */
  public static final java.lang.String DEFAULT_CREDENTIAL_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuthentication.DEFAULT_CREDENTIAL_USERNAME_FIELD;
  /**
   * The default name of the property for the password, like it is transported in credentials by method
   * {@link io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider#authenticate}
   */
  public static final java.lang.String DEFAULT_CREDENTIAL_PASSWORD_FIELD = io.vertx.ext.auth.mongo.MongoAuthentication.DEFAULT_CREDENTIAL_PASSWORD_FIELD;
  /**
   * The default name of the property for the salt field
   */
  public static final java.lang.String DEFAULT_SALT_FIELD = io.vertx.ext.auth.mongo.MongoAuthentication.DEFAULT_SALT_FIELD;
  public static MongoAuthentication newInstance(io.vertx.ext.auth.mongo.MongoAuthentication arg) {
    return arg != null ? new MongoAuthentication(arg) : null;
  }

}
