/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.graphql;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler for GraphQL requests sent over Apollo's <code>subscriptions-transport-ws</code> transport.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.ApolloWSHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.ApolloWSHandler.class)
public class ApolloWSHandler implements Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApolloWSHandler that = (ApolloWSHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ApolloWSHandler> __TYPE_ARG = new TypeArg<>(    obj -> new ApolloWSHandler((io.vertx.ext.web.handler.graphql.ApolloWSHandler) obj),
    ApolloWSHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.ApolloWSHandler delegate;
  
  public ApolloWSHandler(io.vertx.ext.web.handler.graphql.ApolloWSHandler delegate) {
    this.delegate = delegate;
  }

  public ApolloWSHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.ApolloWSHandler)delegate;
  }

  public io.vertx.ext.web.handler.graphql.ApolloWSHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Customize the connection .
   * This handler will be called at the beginning of each websocket connection.
   * @param connectionHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler connectionHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.ServerWebSocket> connectionHandler) { 
    delegate.connectionHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        connectionHandler.handle(io.vertx.reactivex.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event));
      }
    });
    return this;
  }

  /**
   * Customize the connection init .
   * This handler will be called when the  message is received.
   * @param connectionInitHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler connectionInitHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.handler.graphql.ApolloWSConnectionInitEvent> connectionInitHandler) { 
    delegate.connectionInitHandler(new Handler<io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent>() {
      public void handle(io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent event) {
        connectionInitHandler.handle(io.vertx.reactivex.ext.web.handler.graphql.ApolloWSConnectionInitEvent.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent)event));
      }
    });
    return this;
  }

  /**
   * Customize the message .
   * This handler will be called for each {@link io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage} received.
   * @param messageHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler messageHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage> messageHandler) { 
    delegate.messageHandler(new Handler<io.vertx.ext.web.handler.graphql.ApolloWSMessage>() {
      public void handle(io.vertx.ext.web.handler.graphql.ApolloWSMessage event) {
        messageHandler.handle(io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSMessage)event));
      }
    });
    return this;
  }

  /**
   * Customize the end .
   * This handler will be called at the end of each websocket connection.
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler endHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.ServerWebSocket> endHandler) { 
    delegate.endHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        endHandler.handle(io.vertx.reactivex.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event));
      }
    });
    return this;
  }

  /**
   * Customize the query context object.
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler queryContext(java.util.function.Function<io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage,java.lang.Object> factory) { 
    delegate.queryContext(new Function<io.vertx.ext.web.handler.graphql.ApolloWSMessage,java.lang.Object>() {
      public java.lang.Object apply(io.vertx.ext.web.handler.graphql.ApolloWSMessage arg) {
        java.lang.Object ret = factory.apply(io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSMessage)arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler} that will use the provided <code>graphQL</code> object to execute requests.
   * <p>
   * The handler will be configured with the default {@link io.vertx.ext.web.handler.graphql.ApolloWSOptions}.
   * @param graphQL 
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler create(graphql.GraphQL graphQL) { 
    io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler ret = io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSHandler)io.vertx.ext.web.handler.graphql.ApolloWSHandler.create(graphQL));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler} that will use the provided <code>graphQL</code> object to execute requests.
   * <p>
   * The handler will be configured with the given <code>options</code>.
   * @param graphQL 
   * @param options options for configuring the {@link io.vertx.ext.web.handler.graphql.ApolloWSOptions}
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler create(graphql.GraphQL graphQL, io.vertx.ext.web.handler.graphql.ApolloWSOptions options) { 
    io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler ret = io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSHandler)io.vertx.ext.web.handler.graphql.ApolloWSHandler.create(graphQL, options));
    return ret;
  }

  /**
   * Customize the .
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler dataLoaderRegistry(java.util.function.Function<io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage,org.dataloader.DataLoaderRegistry> factory) { 
    delegate.dataLoaderRegistry(new Function<io.vertx.ext.web.handler.graphql.ApolloWSMessage,org.dataloader.DataLoaderRegistry>() {
      public org.dataloader.DataLoaderRegistry apply(io.vertx.ext.web.handler.graphql.ApolloWSMessage arg) {
        org.dataloader.DataLoaderRegistry ret = factory.apply(io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSMessage)arg));
        return ret;
      }
    });
    return this;
  }

  /**
   * Customize the  passed to the GraphQL execution engine.
   * The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
   * @param factory 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.ApolloWSHandler locale(java.util.function.Function<io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage,java.util.Locale> factory) { 
    delegate.locale(new Function<io.vertx.ext.web.handler.graphql.ApolloWSMessage,java.util.Locale>() {
      public java.util.Locale apply(io.vertx.ext.web.handler.graphql.ApolloWSMessage arg) {
        java.util.Locale ret = factory.apply(io.vertx.reactivex.ext.web.handler.graphql.ApolloWSMessage.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSMessage)arg));
        return ret;
      }
    });
    return this;
  }

  public static ApolloWSHandler newInstance(io.vertx.ext.web.handler.graphql.ApolloWSHandler arg) {
    return arg != null ? new ApolloWSHandler(arg) : null;
  }

}
