/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <b>Auto generated</b> Redis API client wrapper.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisAPI original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.RedisAPI.class)
public class RedisAPI {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisAPI that = (RedisAPI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisAPI> __TYPE_ARG = new TypeArg<>(    obj -> new RedisAPI((io.vertx.redis.client.RedisAPI) obj),
    RedisAPI::getDelegate
  );

  private final io.vertx.redis.client.RedisAPI delegate;
  
  public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
    this.delegate = delegate;
  }

  public RedisAPI(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
  }

  public io.vertx.redis.client.RedisAPI getDelegate() {
    return delegate;
  }

  public void close() { 
    delegate.close();
  }

  /**
   * Redis command <a href="https://redis.io/commands/acl">acl</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI acl(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.acl(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/acl">acl</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI acl(java.util.List<java.lang.String> args) {
    return 
acl(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/acl">acl</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxAcl(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      acl(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI append(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.append(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI append(java.lang.String arg0, java.lang.String arg1) {
    return 
append(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxAppend(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      append(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI asking(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.asking(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI asking() {
    return 
asking(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxAsking() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      asking($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI auth(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.auth(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI auth(java.util.List<java.lang.String> args) {
    return 
auth(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxAuth(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      auth(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bgrewriteaof(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bgrewriteaof(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bgrewriteaof() {
    return 
bgrewriteaof(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBgrewriteaof() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bgrewriteaof($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bgsave(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bgsave(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bgsave(java.util.List<java.lang.String> args) {
    return 
bgsave(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBgsave(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bgsave(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitcount(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitcount(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitcount(java.util.List<java.lang.String> args) {
    return 
bitcount(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBitcount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bitcount(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitfield(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitfield(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitfield(java.util.List<java.lang.String> args) {
    return 
bitfield(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBitfield(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bitfield(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield_ro">bitfieldRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitfieldRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitfieldRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield_ro">bitfieldRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitfieldRo(java.util.List<java.lang.String> args) {
    return 
bitfieldRo(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield_ro">bitfieldRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBitfieldRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bitfieldRo(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitop(java.util.List<java.lang.String> args) {
    return 
bitop(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBitop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bitop(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitpos(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bitpos(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bitpos(java.util.List<java.lang.String> args) {
    return 
bitpos(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBitpos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bitpos(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI blpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.blpop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI blpop(java.util.List<java.lang.String> args) {
    return 
blpop(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBlpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      blpop(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI brpop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.brpop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI brpop(java.util.List<java.lang.String> args) {
    return 
brpop(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBrpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      brpop(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI brpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.brpoplpush(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI brpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
brpoplpush(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBrpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      brpoplpush(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bzpopmax(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bzpopmax(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bzpopmax(java.util.List<java.lang.String> args) {
    return 
bzpopmax(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBzpopmax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bzpopmax(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bzpopmin(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.bzpopmin(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI bzpopmin(java.util.List<java.lang.String> args) {
    return 
bzpopmin(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxBzpopmin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      bzpopmin(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI client(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.client(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI client(java.util.List<java.lang.String> args) {
    return 
client(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxClient(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      client(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cluster(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.cluster(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI cluster(java.util.List<java.lang.String> args) {
    return 
cluster(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      cluster(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI command(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.command(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI command(java.util.List<java.lang.String> args) {
    return 
command(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxCommand(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      command(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI config(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.config(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI config(java.util.List<java.lang.String> args) {
    return 
config(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      config(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI dbsize(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.dbsize(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI dbsize() {
    return 
dbsize(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDbsize() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      dbsize($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI debug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.debug(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI debug(java.util.List<java.lang.String> args) {
    return 
debug(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      debug(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI decr(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.decr(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI decr(java.lang.String arg0) {
    return 
decr(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDecr(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      decr(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI decrby(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.decrby(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI decrby(java.lang.String arg0, java.lang.String arg1) {
    return 
decrby(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDecrby(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      decrby(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI del(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.del(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI del(java.util.List<java.lang.String> args) {
    return 
del(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      del(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI discard(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.discard(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI discard() {
    return 
discard(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDiscard() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      discard($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI dump(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.dump(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI dump(java.lang.String arg0) {
    return 
dump(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxDump(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      dump(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI echo(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.echo(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI echo(java.lang.String arg0) {
    return 
echo(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxEcho(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      echo(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI eval(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.eval(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI eval(java.util.List<java.lang.String> args) {
    return 
eval(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxEval(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      eval(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI evalsha(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.evalsha(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI evalsha(java.util.List<java.lang.String> args) {
    return 
evalsha(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxEvalsha(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      evalsha(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI exec(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.exec(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI exec() {
    return 
exec(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxExec() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      exec($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI exists(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.exists(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI exists(java.util.List<java.lang.String> args) {
    return 
exists(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      exists(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI expire(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.expire(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI expire(java.lang.String arg0, java.lang.String arg1) {
    return 
expire(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxExpire(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      expire(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI expireat(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.expireat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI expireat(java.lang.String arg0, java.lang.String arg1) {
    return 
expireat(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxExpireat(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      expireat(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI flushall(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.flushall(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI flushall(java.util.List<java.lang.String> args) {
    return 
flushall(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFlushall(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      flushall(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI flushdb(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.flushdb(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI flushdb(java.util.List<java.lang.String> args) {
    return 
flushdb(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxFlushdb(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      flushdb(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geoadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geoadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geoadd(java.util.List<java.lang.String> args) {
    return 
geoadd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeoadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      geoadd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geodist(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geodist(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geodist(java.util.List<java.lang.String> args) {
    return 
geodist(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeodist(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      geodist(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geohash(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geohash(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geohash(java.util.List<java.lang.String> args) {
    return 
geohash(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeohash(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      geohash(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geopos(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.geopos(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI geopos(java.util.List<java.lang.String> args) {
    return 
geopos(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeopos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      geopos(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadius(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.georadius(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadius(java.util.List<java.lang.String> args) {
    return 
georadius(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeoradius(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      georadius(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.georadiusRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusRo(java.util.List<java.lang.String> args) {
    return 
georadiusRo(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeoradiusRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      georadiusRo(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusbymember(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.georadiusbymember(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusbymember(java.util.List<java.lang.String> args) {
    return 
georadiusbymember(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeoradiusbymember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      georadiusbymember(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusbymemberRo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.georadiusbymemberRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI georadiusbymemberRo(java.util.List<java.lang.String> args) {
    return 
georadiusbymemberRo(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGeoradiusbymemberRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      georadiusbymemberRo(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI get(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.get(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI get(java.lang.String arg0) {
    return 
get(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGet(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      get(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getbit(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.getbit(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getbit(java.lang.String arg0, java.lang.String arg1) {
    return 
getbit(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGetbit(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      getbit(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.getrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
getrange(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      getrange(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getset(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.getset(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI getset(java.lang.String arg0, java.lang.String arg1) {
    return 
getset(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxGetset(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      getset(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hdel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hdel(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hdel(java.util.List<java.lang.String> args) {
    return 
hdel(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hdel(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hello">hello</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hello(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hello(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hello">hello</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hello(java.util.List<java.lang.String> args) {
    return 
hello(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hello">hello</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHello(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hello(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hexists(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hexists(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hexists(java.lang.String arg0, java.lang.String arg1) {
    return 
hexists(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHexists(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hexists(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hget(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hget(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hget(java.lang.String arg0, java.lang.String arg1) {
    return 
hget(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHget(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hget(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hgetall(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hgetall(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hgetall(java.lang.String arg0) {
    return 
hgetall(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHgetall(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hgetall(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hincrby(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
hincrby(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hincrby(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hincrbyfloat(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
hincrbyfloat(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hincrbyfloat(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hkeys(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hkeys(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hkeys(java.lang.String arg0) {
    return 
hkeys(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHkeys(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hkeys(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hlen(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hlen(java.lang.String arg0) {
    return 
hlen(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hlen(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hmget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hmget(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hmget(java.util.List<java.lang.String> args) {
    return 
hmget(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHmget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hmget(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hmset(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hmset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hmset(java.util.List<java.lang.String> args) {
    return 
hmset(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHmset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hmset(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/host:">host</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI host(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.host(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/host:">host</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI host(java.util.List<java.lang.String> args) {
    return 
host(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/host:">host</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHost(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      host(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hscan(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hscan(java.util.List<java.lang.String> args) {
    return 
hscan(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hscan(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hset(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hset(java.util.List<java.lang.String> args) {
    return 
hset(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hset(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hsetnx(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
hsetnx(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hsetnx(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hstrlen(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hstrlen(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hstrlen(java.lang.String arg0, java.lang.String arg1) {
    return 
hstrlen(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHstrlen(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hstrlen(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hvals(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.hvals(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI hvals(java.lang.String arg0) {
    return 
hvals(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxHvals(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      hvals(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incr(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.incr(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incr(java.lang.String arg0) {
    return 
incr(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxIncr(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      incr(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incrby(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.incrby(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incrby(java.lang.String arg0, java.lang.String arg1) {
    return 
incrby(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxIncrby(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      incrby(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incrbyfloat(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.incrbyfloat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI incrbyfloat(java.lang.String arg0, java.lang.String arg1) {
    return 
incrbyfloat(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxIncrbyfloat(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      incrbyfloat(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI info(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.info(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI info(java.util.List<java.lang.String> args) {
    return 
info(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      info(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI keys(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.keys(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI keys(java.lang.String arg0) {
    return 
keys(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxKeys(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      keys(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lastsave(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lastsave(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lastsave() {
    return 
lastsave(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLastsave() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lastsave($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI latency(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.latency(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI latency(java.util.List<java.lang.String> args) {
    return 
latency(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLatency(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      latency(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lindex(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lindex(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lindex(java.lang.String arg0, java.lang.String arg1) {
    return 
lindex(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLindex(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lindex(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI linsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.linsert(arg0, arg1, arg2, arg3, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI linsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) {
    return 
linsert(arg0, arg1, arg2, arg3, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLinsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      linsert(arg0, arg1, arg2, arg3, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI llen(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.llen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI llen(java.lang.String arg0) {
    return 
llen(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      llen(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lolwut(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lolwut(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lolwut(java.util.List<java.lang.String> args) {
    return 
lolwut(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLolwut(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lolwut(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpop(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lpop(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpop(java.lang.String arg0) {
    return 
lpop(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLpop(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lpop(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpush(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lpush(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpush(java.util.List<java.lang.String> args) {
    return 
lpush(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLpush(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lpush(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpushx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lpushx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lpushx(java.util.List<java.lang.String> args) {
    return 
lpushx(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLpushx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lpushx(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
lrange(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lrange(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lrem(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
lrem(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lrem(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.lset(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI lset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
lset(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      lset(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ltrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ltrim(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ltrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
ltrim(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxLtrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ltrim(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI memory(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.memory(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI memory(java.util.List<java.lang.String> args) {
    return 
memory(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMemory(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      memory(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI mget(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.mget(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI mget(java.util.List<java.lang.String> args) {
    return 
mget(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      mget(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI migrate(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.migrate(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI migrate(java.util.List<java.lang.String> args) {
    return 
migrate(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMigrate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      migrate(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI module(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.module(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI module(java.util.List<java.lang.String> args) {
    return 
module(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxModule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      module(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI monitor(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.monitor(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI monitor() {
    return 
monitor(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMonitor() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      monitor($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI move(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.move(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI move(java.lang.String arg0, java.lang.String arg1) {
    return 
move(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMove(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      move(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI mset(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.mset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI mset(java.util.List<java.lang.String> args) {
    return 
mset(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      mset(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI msetnx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.msetnx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI msetnx(java.util.List<java.lang.String> args) {
    return 
msetnx(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMsetnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      msetnx(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI multi(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.multi(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI multi() {
    return 
multi(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxMulti() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      multi($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI object(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.object(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI object(java.util.List<java.lang.String> args) {
    return 
object(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxObject(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      object(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI persist(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.persist(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI persist(java.lang.String arg0) {
    return 
persist(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPersist(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      persist(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pexpire(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pexpire(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pexpire(java.lang.String arg0, java.lang.String arg1) {
    return 
pexpire(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPexpire(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pexpire(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pexpireat(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pexpireat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pexpireat(java.lang.String arg0, java.lang.String arg1) {
    return 
pexpireat(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPexpireat(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pexpireat(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfadd(java.util.List<java.lang.String> args) {
    return 
pfadd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPfadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pfadd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfcount(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfcount(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfcount(java.util.List<java.lang.String> args) {
    return 
pfcount(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPfcount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pfcount(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfdebug(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfdebug(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfdebug(java.util.List<java.lang.String> args) {
    return 
pfdebug(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPfdebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pfdebug(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfmerge(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfmerge(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfmerge(java.util.List<java.lang.String> args) {
    return 
pfmerge(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPfmerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pfmerge(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfselftest(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pfselftest(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pfselftest() {
    return 
pfselftest(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPfselftest() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pfselftest($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ping(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ping(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ping(java.util.List<java.lang.String> args) {
    return 
ping(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPing(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ping(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/post">post</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI post(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.post(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/post">post</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI post(java.util.List<java.lang.String> args) {
    return 
post(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/post">post</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPost(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      post(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.psetex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
psetex(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPsetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      psetex(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.psubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psubscribe(java.util.List<java.lang.String> args) {
    return 
psubscribe(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      psubscribe(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psync(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.psync(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI psync(java.lang.String arg0, java.lang.String arg1) {
    return 
psync(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPsync(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      psync(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pttl(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pttl(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pttl(java.lang.String arg0) {
    return 
pttl(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPttl(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pttl(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI publish(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.publish(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI publish(java.lang.String arg0, java.lang.String arg1) {
    return 
publish(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPublish(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      publish(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pubsub(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.pubsub(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI pubsub(java.util.List<java.lang.String> args) {
    return 
pubsub(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPubsub(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      pubsub(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI punsubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.punsubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI punsubscribe(java.util.List<java.lang.String> args) {
    return 
punsubscribe(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxPunsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      punsubscribe(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI randomkey(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.randomkey(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI randomkey() {
    return 
randomkey(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRandomkey() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      randomkey($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI readonly(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.readonly(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI readonly() {
    return 
readonly(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxReadonly() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      readonly($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI readwrite(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.readwrite(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI readwrite() {
    return 
readwrite(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxReadwrite() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      readwrite($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rename(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rename(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rename(java.lang.String arg0, java.lang.String arg1) {
    return 
rename(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRename(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      rename(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI renamenx(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.renamenx(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI renamenx(java.lang.String arg0, java.lang.String arg1) {
    return 
renamenx(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRenamenx(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      renamenx(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI replconf(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.replconf(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI replconf(java.util.List<java.lang.String> args) {
    return 
replconf(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxReplconf(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      replconf(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI replicaof(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.replicaof(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI replicaof(java.lang.String arg0, java.lang.String arg1) {
    return 
replicaof(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxReplicaof(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      replicaof(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI restore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.restore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI restore(java.util.List<java.lang.String> args) {
    return 
restore(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRestore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      restore(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI restoreAsking(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.restoreAsking(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI restoreAsking(java.util.List<java.lang.String> args) {
    return 
restoreAsking(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRestoreAsking(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      restoreAsking(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI role(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.role(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI role() {
    return 
role(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRole() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      role($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpop(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rpop(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpop(java.lang.String arg0) {
    return 
rpop(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRpop(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      rpop(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpoplpush(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rpoplpush(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpoplpush(java.lang.String arg0, java.lang.String arg1) {
    return 
rpoplpush(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRpoplpush(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      rpoplpush(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpush(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rpush(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpush(java.util.List<java.lang.String> args) {
    return 
rpush(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRpush(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      rpush(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpushx(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.rpushx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI rpushx(java.util.List<java.lang.String> args) {
    return 
rpushx(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxRpushx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      rpushx(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sadd(java.util.List<java.lang.String> args) {
    return 
sadd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sadd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI save(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.save(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI save() {
    return 
save(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSave() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      save($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI scan(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.scan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI scan(java.util.List<java.lang.String> args) {
    return 
scan(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxScan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      scan(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI scard(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.scard(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI scard(java.lang.String arg0) {
    return 
scard(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxScard(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      scard(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI script(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.script(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI script(java.util.List<java.lang.String> args) {
    return 
script(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxScript(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      script(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sdiff(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sdiff(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sdiff(java.util.List<java.lang.String> args) {
    return 
sdiff(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSdiff(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sdiff(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sdiffstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sdiffstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sdiffstore(java.util.List<java.lang.String> args) {
    return 
sdiffstore(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSdiffstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sdiffstore(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI select(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.select(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI select(java.lang.String arg0) {
    return 
select(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSelect(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      select(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI set(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.set(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI set(java.util.List<java.lang.String> args) {
    return 
set(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      set(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.setbit(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
setbit(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSetbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      setbit(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.setex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
setex(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      setex(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setnx(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.setnx(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setnx(java.lang.String arg0, java.lang.String arg1) {
    return 
setnx(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSetnx(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      setnx(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.setrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI setrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
setrange(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      setrange(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI shutdown(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.shutdown(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI shutdown(java.util.List<java.lang.String> args) {
    return 
shutdown(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxShutdown(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      shutdown(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sinter(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sinter(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sinter(java.util.List<java.lang.String> args) {
    return 
sinter(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSinter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sinter(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sinterstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sinterstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sinterstore(java.util.List<java.lang.String> args) {
    return 
sinterstore(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSinterstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sinterstore(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sismember(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sismember(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sismember(java.lang.String arg0, java.lang.String arg1) {
    return 
sismember(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSismember(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sismember(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI slaveof(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.slaveof(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI slaveof(java.lang.String arg0, java.lang.String arg1) {
    return 
slaveof(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSlaveof(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      slaveof(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI slowlog(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.slowlog(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI slowlog(java.util.List<java.lang.String> args) {
    return 
slowlog(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSlowlog(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      slowlog(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI smembers(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.smembers(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI smembers(java.lang.String arg0) {
    return 
smembers(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSmembers(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      smembers(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI smove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.smove(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI smove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
smove(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      smove(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sort(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sort(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sort(java.util.List<java.lang.String> args) {
    return 
sort(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSort(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sort(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI spop(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.spop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI spop(java.util.List<java.lang.String> args) {
    return 
spop(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      spop(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI srandmember(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.srandmember(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI srandmember(java.util.List<java.lang.String> args) {
    return 
srandmember(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSrandmember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      srandmember(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI srem(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.srem(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI srem(java.util.List<java.lang.String> args) {
    return 
srem(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSrem(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      srem(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sscan(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sscan(java.util.List<java.lang.String> args) {
    return 
sscan(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sscan(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/stralgo">stralgo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI stralgo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.stralgo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/stralgo">stralgo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI stralgo(java.util.List<java.lang.String> args) {
    return 
stralgo(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/stralgo">stralgo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxStralgo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      stralgo(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI strlen(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.strlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI strlen(java.lang.String arg0) {
    return 
strlen(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxStrlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      strlen(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI subscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.subscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI subscribe(java.util.List<java.lang.String> args) {
    return 
subscribe(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      subscribe(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI substr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.substr(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI substr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
substr(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSubstr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      substr(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sunion(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sunion(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sunion(java.util.List<java.lang.String> args) {
    return 
sunion(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSunion(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sunion(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sunionstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sunionstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sunionstore(java.util.List<java.lang.String> args) {
    return 
sunionstore(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSunionstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sunionstore(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI swapdb(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.swapdb(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI swapdb(java.lang.String arg0, java.lang.String arg1) {
    return 
swapdb(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSwapdb(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      swapdb(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sync(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.sync(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI sync() {
    return 
sync(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxSync() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      sync($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI time(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.time(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI time() {
    return 
time(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTime() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      time($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI touch(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.touch(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI touch(java.util.List<java.lang.String> args) {
    return 
touch(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTouch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      touch(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ttl(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.ttl(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI ttl(java.lang.String arg0) {
    return 
ttl(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxTtl(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      ttl(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI type(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.type(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI type(java.lang.String arg0) {
    return 
type(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxType(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      type(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unlink(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.unlink(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unlink(java.util.List<java.lang.String> args) {
    return 
unlink(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxUnlink(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      unlink(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unsubscribe(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.unsubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unsubscribe(java.util.List<java.lang.String> args) {
    return 
unsubscribe(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxUnsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      unsubscribe(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unwatch(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.unwatch(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI unwatch() {
    return 
unwatch(ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxUnwatch() { 
    return AsyncResultMaybe.toMaybe($handler -> {
      unwatch($handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI wait(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.wait(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI wait(java.lang.String arg0, java.lang.String arg1) {
    return 
wait(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxWait(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      wait(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI watch(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.watch(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI watch(java.util.List<java.lang.String> args) {
    return 
watch(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxWatch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      watch(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xack(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xack(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xack(java.util.List<java.lang.String> args) {
    return 
xack(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXack(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xack(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xadd(java.util.List<java.lang.String> args) {
    return 
xadd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xadd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xclaim(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xclaim(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xclaim(java.util.List<java.lang.String> args) {
    return 
xclaim(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXclaim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xclaim(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xdel(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xdel(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xdel(java.util.List<java.lang.String> args) {
    return 
xdel(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xdel(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xgroup(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xgroup(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xgroup(java.util.List<java.lang.String> args) {
    return 
xgroup(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXgroup(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xgroup(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xinfo(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xinfo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xinfo(java.util.List<java.lang.String> args) {
    return 
xinfo(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXinfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xinfo(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xlen(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xlen(java.lang.String arg0) {
    return 
xlen(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xlen(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xpending(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xpending(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xpending(java.util.List<java.lang.String> args) {
    return 
xpending(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXpending(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xpending(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xrange(java.util.List<java.lang.String> args) {
    return 
xrange(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xrange(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xread(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xread(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xread(java.util.List<java.lang.String> args) {
    return 
xread(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXread(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xread(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xreadgroup(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xreadgroup(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xreadgroup(java.util.List<java.lang.String> args) {
    return 
xreadgroup(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXreadgroup(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xreadgroup(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xrevrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xrevrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xrevrange(java.util.List<java.lang.String> args) {
    return 
xrevrange(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xrevrange(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xsetid(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xsetid(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xsetid(java.lang.String arg0, java.lang.String arg1) {
    return 
xsetid(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXsetid(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xsetid(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xtrim(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.xtrim(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI xtrim(java.util.List<java.lang.String> args) {
    return 
xtrim(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxXtrim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      xtrim(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zadd(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zadd(java.util.List<java.lang.String> args) {
    return 
zadd(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zadd(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zcard(java.lang.String arg0, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zcard(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zcard(java.lang.String arg0) {
    return 
zcard(arg0, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZcard(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zcard(arg0, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zcount(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zcount(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zcount(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zincrby(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zincrby(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zincrby(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zinterstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zinterstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zinterstore(java.util.List<java.lang.String> args) {
    return 
zinterstore(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZinterstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zinterstore(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zlexcount(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zlexcount(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zlexcount(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zpopmax(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zpopmax(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zpopmax(java.util.List<java.lang.String> args) {
    return 
zpopmax(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZpopmax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zpopmax(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zpopmin(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zpopmin(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zpopmin(java.util.List<java.lang.String> args) {
    return 
zpopmin(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZpopmin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zpopmin(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrange(java.util.List<java.lang.String> args) {
    return 
zrange(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrange(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrangebylex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrangebylex(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrangebylex(java.util.List<java.lang.String> args) {
    return 
zrangebylex(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrangebylex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrangebylex(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrangebyscore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrangebyscore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrangebyscore(java.util.List<java.lang.String> args) {
    return 
zrangebyscore(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrangebyscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrangebyscore(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrank(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrank(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrank(java.lang.String arg0, java.lang.String arg1) {
    return 
zrank(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrank(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrank(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrem(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrem(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrem(java.util.List<java.lang.String> args) {
    return 
zrem(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrem(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrem(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zremrangebylex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zremrangebylex(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zremrangebylex(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zremrangebyrank(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zremrangebyrank(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zremrangebyrank(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zremrangebyscore(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) {
    return 
zremrangebyscore(arg0, arg1, arg2, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zremrangebyscore(arg0, arg1, arg2, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrange(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrevrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrange(java.util.List<java.lang.String> args) {
    return 
zrevrange(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrevrange(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrangebylex(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrevrangebylex(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrangebylex(java.util.List<java.lang.String> args) {
    return 
zrevrangebylex(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrevrangebylex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrevrangebylex(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrangebyscore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrevrangebyscore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrangebyscore(java.util.List<java.lang.String> args) {
    return 
zrevrangebyscore(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrevrangebyscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrevrangebyscore(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrank(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zrevrank(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zrevrank(java.lang.String arg0, java.lang.String arg1) {
    return 
zrevrank(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZrevrank(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zrevrank(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zscan(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zscan(java.util.List<java.lang.String> args) {
    return 
zscan(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zscan(args, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zscore(java.lang.String arg0, java.lang.String arg1, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zscore(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zscore(java.lang.String arg0, java.lang.String arg1) {
    return 
zscore(arg0, arg1, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZscore(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zscore(arg0, arg1, $handler);
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @param handler 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zunionstore(java.util.List<java.lang.String> args, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.redis.client.Response>> handler) { 
    delegate.zunionstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.vertx.reactivex.redis.client.RedisAPI zunionstore(java.util.List<java.lang.String> args) {
    return 
zunionstore(args, ar -> { });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.Maybe<io.vertx.reactivex.redis.client.Response> rxZunionstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      zunionstore(args, $handler);
    });
  }

  public static io.vertx.reactivex.redis.client.RedisAPI api(io.vertx.reactivex.redis.client.Redis client) { 
    io.vertx.reactivex.redis.client.RedisAPI ret = io.vertx.reactivex.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(client.getDelegate()));
    return ret;
  }

  public static io.vertx.reactivex.redis.client.RedisAPI api(io.vertx.reactivex.redis.client.RedisConnection connection) { 
    io.vertx.reactivex.redis.client.RedisAPI ret = io.vertx.reactivex.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(connection.getDelegate()));
    return ret;
  }

  public static RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
    return arg != null ? new RedisAPI(arg) : null;
  }

}
