/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.redis.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Builder for REDIS requests that will be encoded according to the RESP protocol was introduced in Redis 1.2.
 * Which became the standard way for talking with the Redis server in Redis 2.0.
 *
 * Redis <a href="https://redis.io/topics/protocol">protocol documentation</a> states:
 *
 * <blockquote>
 *     Clients send commands to a Redis server as a RESP Array of Bulk Strings.
 * </blockquote>
 *
 * So all non String/Bulk types will be encoded to Bulk for convenience.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.Request original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.Request.class)
public class Request {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Request that = (Request) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Request> __TYPE_ARG = new TypeArg<>(    obj -> new Request((io.vertx.redis.client.Request) obj),
    Request::getDelegate
  );

  private final io.vertx.redis.client.Request delegate;
  
  public Request(io.vertx.redis.client.Request delegate) {
    this.delegate = delegate;
  }

  public Request(Object delegate) {
    this.delegate = (io.vertx.redis.client.Request)delegate;
  }

  public io.vertx.redis.client.Request getDelegate() {
    return delegate;
  }

  public static io.vertx.reactivex.redis.client.Request cmd(io.vertx.reactivex.redis.client.Command command) { 
    io.vertx.reactivex.redis.client.Request ret = io.vertx.reactivex.redis.client.Request.newInstance((io.vertx.redis.client.Request)io.vertx.redis.client.Request.cmd(command.getDelegate()));
    return ret;
  }

  /**
   * Adds a String argument using UTF8 character encoding
   * @param arg 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(java.lang.String arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * Adds a String using a specific character encoding argument
   * @param arg 
   * @param enc 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(java.lang.String arg, java.lang.String enc) { 
    delegate.arg(arg, enc);
    return this;
  }

  /**
   * Adds a String key argument
   * @param arg 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(io.vertx.reactivex.core.buffer.Buffer arg) { 
    delegate.arg(arg.getDelegate());
    return this;
  }

  /**
   * Adds a long encoded to string
   * @param arg 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(long arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * Adds a boolean encoded to string
   * @param arg 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(boolean arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * Adds a JsonObject argument, the encoding will serialize the json as key0, value0, key1, value1, ... keyN, valueN.
   * This is a non-optimized serialization and will just use the string encoding of the values for non buffers.
   *
   * All <code>null</code> values will follow the encoding rules of {@link io.vertx.reactivex.redis.client.Request#nullArg}.
   * @param arg 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(io.vertx.core.json.JsonObject arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * Adds a JsonArray argument, the encoding will serialize the json as value0, value1, ... valueN.
   * This is a non-optimized serialization and will just use the string encoding of the values for non buffers.
   *
   * All <code>null</code> values will follow the encoding rules of {@link io.vertx.reactivex.redis.client.Request#nullArg}.
   * @param arg 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(io.vertx.core.json.JsonArray arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * @return self
   */
  @Deprecated()
  public io.vertx.reactivex.redis.client.Request nullArg() { 
    delegate.nullArg();
    return this;
  }

  /**
   * Get the Command that is to be used by this request.
   * @return the command.
   */
  public io.vertx.reactivex.redis.client.Command command() { 
    io.vertx.reactivex.redis.client.Command ret = io.vertx.reactivex.redis.client.Command.newInstance((io.vertx.redis.client.Command)delegate.command());
    return ret;
  }

  /**
   * Adds a byte array
   * @param arg 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(byte[] arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * Adds a int encoded to string
   * @param arg 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(int arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * Adds a short encoded to string
   * @param arg 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(short arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * Adds a byte encoded to string
   * @param arg 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(byte arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * Adds a float encoded to string
   * @param arg 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(float arg) { 
    delegate.arg(arg);
    return this;
  }

  /**
   * Adds a double encoded to string
   * @param arg 
   * @return self
   */
  public io.vertx.reactivex.redis.client.Request arg(double arg) { 
    delegate.arg(arg);
    return this;
  }

  public static Request newInstance(io.vertx.redis.client.Request arg) {
    return arg != null ? new Request(arg) : null;
  }

}
