/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An interface that represents the execution result of an operation on the database server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.SqlResult original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.SqlResult.class)
public class SqlResult<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlResult that = (SqlResult) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SqlResult> __TYPE_ARG = new TypeArg<>(    obj -> new SqlResult((io.vertx.sqlclient.SqlResult) obj),
    SqlResult::getDelegate
  );

  private final io.vertx.sqlclient.SqlResult<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public SqlResult(io.vertx.sqlclient.SqlResult delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public SqlResult(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.sqlclient.SqlResult)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.sqlclient.SqlResult getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.sqlclient.desc.ColumnDescriptor> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.sqlclient.desc.ColumnDescriptor>(o1 -> io.vertx.reactivex.sqlclient.desc.ColumnDescriptor.newInstance((io.vertx.sqlclient.desc.ColumnDescriptor)o1), o1 -> o1.getDelegate());

  /**
   * Get the number of the affected rows in the operation to this SqlResult.
   * @return the count of affected rows.
   */
  public int rowCount() { 
    int ret = delegate.rowCount();
    return ret;
  }

  /**
   * Get the names of columns in the SqlResult.
   * @return the list of names of columns.
   */
  public java.util.List<java.lang.String> columnsNames() { 
    java.util.List<java.lang.String> ret = delegate.columnsNames();
    return ret;
  }

  /**
   * Get the column descriptors in the SqlResult.
   * @return the list of column descriptors
   */
  public java.util.List<io.vertx.reactivex.sqlclient.desc.ColumnDescriptor> columnDescriptors() { 
    java.util.List<io.vertx.reactivex.sqlclient.desc.ColumnDescriptor> ret = delegate.columnDescriptors().stream().map(elt -> io.vertx.reactivex.sqlclient.desc.ColumnDescriptor.newInstance((io.vertx.sqlclient.desc.ColumnDescriptor)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * Get the number of rows retrieved in the SqlResult.
   * @return the count of rows.
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  /**
   * Get the specific property with the specified {@link io.vertx.reactivex.sqlclient.PropertyKind}.
   * @param propertyKind the unique object which is used to indicate which property of the execution result to fetch
   * @return the value of the property
   */
  public <V> V property(io.vertx.reactivex.sqlclient.PropertyKind<V> propertyKind) { 
    V ret = (V)propertyKind.__typeArg_0.wrap(delegate.property(propertyKind.getDelegate()));
    return ret;
  }

  /**
   * Get the execution result value, the execution result type may vary such as a {@link io.vertx.reactivex.sqlclient.RowSet rowSet} or even a {@link java.lang.String}.
   * @return the result value
   */
  public T value() { 
    T ret = (T)__typeArg_0.wrap(delegate.value());
    return ret;
  }

  /**
   * Return the next available result or <code>null</code>, e.g for a simple query that executed multiple queries or for
   * a batch result.
   * @return the next available result or <code>null</code> if none is available
   */
  public io.vertx.reactivex.sqlclient.SqlResult<T> next() { 
    io.vertx.reactivex.sqlclient.SqlResult<T> ret = io.vertx.reactivex.sqlclient.SqlResult.newInstance((io.vertx.sqlclient.SqlResult)delegate.next(), __typeArg_0);
    return ret;
  }

  public static <T> SqlResult<T> newInstance(io.vertx.sqlclient.SqlResult arg) {
    return arg != null ? new SqlResult<T>(arg) : null;
  }

  public static <T> SqlResult<T> newInstance(io.vertx.sqlclient.SqlResult arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new SqlResult<T>(arg, __typeArg_T) : null;
  }

}
