/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient.desc;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.sqlclient.desc.ColumnDescriptor.class)
public class ColumnDescriptor {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ColumnDescriptor that = (ColumnDescriptor) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ColumnDescriptor> __TYPE_ARG = new TypeArg<>(    obj -> new ColumnDescriptor((io.vertx.sqlclient.desc.ColumnDescriptor) obj),
    ColumnDescriptor::getDelegate
  );

  private final io.vertx.sqlclient.desc.ColumnDescriptor delegate;
  
  public ColumnDescriptor(io.vertx.sqlclient.desc.ColumnDescriptor delegate) {
    this.delegate = delegate;
  }

  public ColumnDescriptor(Object delegate) {
    this.delegate = (io.vertx.sqlclient.desc.ColumnDescriptor)delegate;
  }

  public io.vertx.sqlclient.desc.ColumnDescriptor getDelegate() {
    return delegate;
  }

  /**
   * @return the column name
   */
  public java.lang.String name() { 
    java.lang.String ret = delegate.name();
    return ret;
  }

  /**
   * @return whether the column is an array
   */
  public boolean isArray() { 
    boolean ret = delegate.isArray();
    return ret;
  }

  /**
   * @return the most appropriate <code>JDBCType</code>
   */
  public java.sql.JDBCType jdbcType() { 
    java.sql.JDBCType ret = delegate.jdbcType();
    return ret;
  }

  public static ColumnDescriptor newInstance(io.vertx.sqlclient.desc.ColumnDescriptor arg) {
    return arg != null ? new ColumnDescriptor(arg) : null;
  }

}
