/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient.spi;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Contains static metadata about the backend database server
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.spi.DatabaseMetadata original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.spi.DatabaseMetadata.class)
public class DatabaseMetadata {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DatabaseMetadata that = (DatabaseMetadata) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DatabaseMetadata> __TYPE_ARG = new TypeArg<>(    obj -> new DatabaseMetadata((io.vertx.sqlclient.spi.DatabaseMetadata) obj),
    DatabaseMetadata::getDelegate
  );

  private final io.vertx.sqlclient.spi.DatabaseMetadata delegate;
  
  public DatabaseMetadata(io.vertx.sqlclient.spi.DatabaseMetadata delegate) {
    this.delegate = delegate;
  }

  public DatabaseMetadata(Object delegate) {
    this.delegate = (io.vertx.sqlclient.spi.DatabaseMetadata)delegate;
  }

  public io.vertx.sqlclient.spi.DatabaseMetadata getDelegate() {
    return delegate;
  }

  /**
   * @return The product name of the backend database server
   */
  public java.lang.String productName() { 
    java.lang.String ret = delegate.productName();
    return ret;
  }

  /**
   * @return The full version string for the backend database server. This may be useful for for parsing more subtle aspects of the version string. For simple information like database major and minor version, use {@link io.vertx.reactivex.sqlclient.spi.DatabaseMetadata#majorVersion} and {@link io.vertx.reactivex.sqlclient.spi.DatabaseMetadata#minorVersion} instead.
   */
  public java.lang.String fullVersion() { 
    java.lang.String ret = delegate.fullVersion();
    return ret;
  }

  /**
   * @return The major version of the backend database server
   */
  public int majorVersion() { 
    int ret = delegate.majorVersion();
    return ret;
  }

  /**
   * @return The minor version of the backend database server
   */
  public int minorVersion() { 
    int ret = delegate.minorVersion();
    return ret;
  }

  public static DatabaseMetadata newInstance(io.vertx.sqlclient.spi.DatabaseMetadata arg) {
    return arg != null ? new DatabaseMetadata(arg) : null;
  }

}
