/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.amqp;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.proton.ProtonConnection;
import io.vertx.reactivex.amqp.AmqpReceiver;
import io.vertx.reactivex.amqp.AmqpSender;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.amqp.AmqpConnection.class)
public class AmqpConnection {
    public static final TypeArg<AmqpConnection> __TYPE_ARG = new TypeArg(obj -> new AmqpConnection((io.vertx.amqp.AmqpConnection)obj), AmqpConnection::getDelegate);
    private final io.vertx.amqp.AmqpConnection delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpConnection that = (AmqpConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpConnection(io.vertx.amqp.AmqpConnection delegate) {
        this.delegate = delegate;
    }

    public AmqpConnection(Object delegate) {
        this.delegate = (io.vertx.amqp.AmqpConnection)delegate;
    }

    public io.vertx.amqp.AmqpConnection getDelegate() {
        return this.delegate;
    }

    public AmqpConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AmqpConnection close(Handler<AsyncResult<Void>> done) {
        this.delegate.close(done);
        return this;
    }

    public AmqpConnection close() {
        return this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    public AmqpConnection createReceiver(String address, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpConnection createReceiver(String address) {
        return this.createReceiver(address, (Handler<AsyncResult<AmqpReceiver>>)((Handler)ar -> {}));
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address) {
        return AsyncResultSingle.toSingle($handler -> this.createReceiver(address, (Handler<AsyncResult<AmqpReceiver>>)$handler));
    }

    public AmqpConnection createReceiver(String address, AmqpReceiverOptions receiverOptions, final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createReceiver(address, receiverOptions, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpConnection createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return this.createReceiver(address, receiverOptions, (Handler<AsyncResult<AmqpReceiver>>)((Handler)ar -> {}));
    }

    public Single<AmqpReceiver> rxCreateReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return AsyncResultSingle.toSingle($handler -> this.createReceiver(address, receiverOptions, (Handler<AsyncResult<AmqpReceiver>>)$handler));
    }

    public AmqpConnection createDynamicReceiver(final Handler<AsyncResult<AmqpReceiver>> completionHandler) {
        this.delegate.createDynamicReceiver((Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpConnection createDynamicReceiver() {
        return this.createDynamicReceiver((Handler<AsyncResult<AmqpReceiver>>)((Handler)ar -> {}));
    }

    public Single<AmqpReceiver> rxCreateDynamicReceiver() {
        return AsyncResultSingle.toSingle($handler -> this.createDynamicReceiver((Handler<AsyncResult<AmqpReceiver>>)$handler));
    }

    public AmqpConnection createSender(String address, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpConnection createSender(String address) {
        return this.createSender(address, (Handler<AsyncResult<AmqpSender>>)((Handler)ar -> {}));
    }

    public Single<AmqpSender> rxCreateSender(String address) {
        return AsyncResultSingle.toSingle($handler -> this.createSender(address, (Handler<AsyncResult<AmqpSender>>)$handler));
    }

    public AmqpConnection createSender(String address, AmqpSenderOptions options, final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createSender(address, options, (Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpConnection createSender(String address, AmqpSenderOptions options) {
        return this.createSender(address, options, (Handler<AsyncResult<AmqpSender>>)((Handler)ar -> {}));
    }

    public Single<AmqpSender> rxCreateSender(String address, AmqpSenderOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.createSender(address, options, (Handler<AsyncResult<AmqpSender>>)$handler));
    }

    public AmqpConnection createAnonymousSender(final Handler<AsyncResult<AmqpSender>> completionHandler) {
        this.delegate.createAnonymousSender((Handler)new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>(){

            public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public AmqpConnection createAnonymousSender() {
        return this.createAnonymousSender((Handler<AsyncResult<AmqpSender>>)((Handler)ar -> {}));
    }

    public Single<AmqpSender> rxCreateAnonymousSender() {
        return AsyncResultSingle.toSingle($handler -> this.createAnonymousSender((Handler<AsyncResult<AmqpSender>>)$handler));
    }

    public boolean isDisconnected() {
        boolean ret = this.delegate.isDisconnected();
        return ret;
    }

    public Future<Void> closeFuture() {
        Future ret = this.delegate.closeFuture().map(val -> val);
        return ret;
    }

    public ProtonConnection unwrap() {
        ProtonConnection ret = this.delegate.unwrap();
        return ret;
    }

    public static AmqpConnection newInstance(io.vertx.amqp.AmqpConnection arg) {
        return arg != null ? new AmqpConnection(arg) : null;
    }
}

